/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.passes.AutoescaperPass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ResolveExpressionTypesPass;
import com.google.template.soy.passes.RunAfter;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RunBefore(value={AutoescaperPass.class})
@RunAfter(value={ResolveExpressionTypesPass.class})
final class SoyElementCompositionPass
implements CompilerFileSetPass {
    private static final SoyErrorKind ILLEGAL_CHILD = SoyErrorKind.of("Only HTML attributes are allowed as children of this template call.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_ATTRIBUTE = SoyErrorKind.of("Attribute specified multiple times.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SKIP_NODE_NOT_ALLOWED = SoyErrorKind.of("Skip nodes are not allowed on this template call.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final ImmutableList<? extends SoyPrintDirective> printDirectives;

    SoyElementCompositionPass(ErrorReporter errorReporter, ImmutableList<? extends SoyPrintDirective> printDirectives) {
        this.errorReporter = errorReporter;
        this.printDirectives = printDirectives;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.CONTINUE;
        }
        for (SoyFileNode file : sourceFiles) {
            this.run(file, idGenerator);
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : SoyTreeUtils.getAllNodesOfType(file, TemplateNode.class)) {
            for (HtmlTagNode tagNode : SoyTreeUtils.getAllNodesOfType(template, HtmlTagNode.class)) {
                this.process(template, tagNode, nodeIdGen, file.getTemplateRegistry());
            }
        }
    }

    private void process(TemplateNode template, HtmlTagNode tagNode, IdGenerator nodeIdGen, TemplateRegistry registry) {
        CallBasicNode call;
        TemplateType templateType;
        CallParamContentNode attributesNode;
        TagName name = tagNode.getTagName();
        if (name.isStatic()) {
            return;
        }
        PrintNode printNode = name.getDynamicTagName();
        if (!tagNode.getTagName().isTemplateCall()) {
            return;
        }
        if (tagNode instanceof HtmlOpenTagNode) {
            ContextualAutoescaper.annotateAndRewriteHtmlTag((HtmlOpenTagNode)tagNode, registry, nodeIdGen, this.errorReporter, this.printDirectives);
        }
        Preconditions.checkState((tagNode.getTaggedPairs().size() <= 1 ? 1 : 0) != 0);
        SourceLocation unknown = template.getSourceLocation().clearRange();
        Map attrs = template.getAllParams().stream().filter(p -> p instanceof AttrParam).map(AttrParam.class::cast).collect(Collectors.toMap(AbstractVarDefn::name, Function.identity()));
        SourceLocation location = tagNode.getSourceLocation();
        if (!tagNode.getTaggedPairs().isEmpty()) {
            location = location.extend(tagNode.getTaggedPairs().get(0).getSourceLocation());
        }
        CallParamContentNode callParamContentNode = attributesNode = (templateType = (TemplateType)(call = new CallBasicNode(nodeIdGen.genId(), location, unknown, printNode.getExpr().getRoot().copy(new CopyState()), (List<CommandTagAttribute>)ImmutableList.of(), false, this.errorReporter)).getCalleeExpr().getRoot().getType()).getAllowExtraAttributes() ? new CallParamContentNode(nodeIdGen.genId(), location, SourceLocation.UNKNOWN, Identifier.create("__soyInternalAttributes", SourceLocation.UNKNOWN), new CommandTagAttribute(Identifier.create("kind", SourceLocation.UNKNOWN), QuoteStyle.SINGLE, "attributes", SourceLocation.UNKNOWN, SourceLocation.UNKNOWN), this.errorReporter) : null;
        if (!tagNode.getTaggedPairs().isEmpty()) {
            HtmlTagNode closeTag = tagNode.getTaggedPairs().get(0);
            List params = templateType.getParameters().stream().filter(p -> SoyTypes.transitivelyContainsKind(p.getType(), SoyType.Kind.HTML)).map(TemplateType.Parameter::getName).collect(Collectors.toCollection(ArrayList::new));
            SoyNode.StandaloneNode next = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(tagNode);
            if (params.size() != 1 || next instanceof HtmlOpenTagNode && ((HtmlOpenTagNode)next).isSlot()) {
                while (next != closeTag) {
                    if ((next = this.consumeSlot(call, next, nodeIdGen)) != null) continue;
                    return;
                }
            } else if (params.size() == 1) {
                CallParamContentNode callParamContent = new CallParamContentNode(nodeIdGen.genId(), unknown, unknown, Identifier.create((String)params.get(0), unknown), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, "html", unknown, unknown), this.errorReporter);
                call.addChild(callParamContent);
                while (next != closeTag) {
                    SoyNode.StandaloneNode sibling = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(next);
                    next.getParent().removeChild(next);
                    callParamContent.addChild(next);
                    next = sibling;
                }
            }
            closeTag.getParent().removeChild(closeTag);
        }
        call.getCalleeExpr().setType(printNode.getExpr().getType());
        call.setHtmlContext(HtmlContext.HTML_PCDATA);
        tagNode.getParent().replaceChild(tagNode, call);
        ImmutableMap<String, SoyType> parameterMap = templateType.getParameterMap();
        HashSet seenAttr = new HashSet();
        tagNode.getChildren().stream().skip(1L).forEach(c -> {
            if (c.getKind() == SoyNode.Kind.IF_NODE) {
                IfNode ifNode = (IfNode)c;
                if (ifNode.numChildren() != 1) {
                    this.errorReporter.report(c.getSourceLocation(), ILLEGAL_CHILD, new Object[0]);
                    return;
                }
                IfCondNode ifCond = (IfCondNode)ifNode.getChild(0);
                LetValueNode letValueNode = new LetValueNode(nodeIdGen.genId(), unknown, "$__internal_call_" + nodeIdGen.genId(), unknown, ifCond.getExpr().getRoot().copy(new CopyState()));
                letValueNode.getVar().setType(ifCond.getExpr().getRoot().getType());
                call.getParent().addChild(call.getParent().getChildIndex(call), letValueNode);
                for (SoyNode.StandaloneNode child : ifCond.getChildren()) {
                    VarRefNode ref = new VarRefNode(letValueNode.getVarRefName(), unknown, letValueNode.getVar());
                    ref.setSubstituteType(letValueNode.getVar().type());
                    this.maybeConsumeAttribute(child, call, nodeIdGen, seenAttr, (Map<String, SoyType>)parameterMap, attrs, attributesNode, Optional.of(ref));
                }
            } else if (c instanceof KeyNode) {
                call.setKeyExpr(((KeyNode)c).getExpr().copy(new CopyState()));
            } else if (c instanceof SkipNode) {
                this.errorReporter.report(c.getSourceLocation(), SKIP_NODE_NOT_ALLOWED, new Object[0]);
            } else {
                this.maybeConsumeAttribute((SoyNode.StandaloneNode)c, call, nodeIdGen, seenAttr, (Map<String, SoyType>)parameterMap, attrs, attributesNode, Optional.empty());
            }
        });
        if (attributesNode != null && attributesNode.numChildren() > 0) {
            call.addChild(attributesNode);
        }
    }

    private void maybeConsumeAttribute(SoyNode.StandaloneNode c, CallBasicNode call, IdGenerator nodeIdGen, Set<String> seenAttr, Map<String, SoyType> parameterMap, Map<String, AttrParam> attrs, @Nullable CallParamContentNode attributesNode, Optional<ExprNode> conditional) {
        if (c.getKind() == SoyNode.Kind.HTML_ATTRIBUTE_NODE) {
            HtmlAttributeNode attrNode = (HtmlAttributeNode)c;
            if (attrNode.getStaticKey() != null) {
                CallParamNode param = this.consumeAttribute(attrNode, nodeIdGen, seenAttr, parameterMap, attrs, attributesNode, call, conditional);
                if (param != null) {
                    param.setOriginalName(attrNode.getStaticKey());
                    call.addChild(param);
                }
                return;
            }
            if (attrNode.numChildren() == 1 && attributesNode != null && SoyElementCompositionPass.isOkToPutInElement(attrNode)) {
                SoyElementCompositionPass.maybePrintAttribute(attributesNode, conditional, nodeIdGen, attrNode);
                return;
            }
        }
        this.errorReporter.report(c.getSourceLocation(), ILLEGAL_CHILD, new Object[0]);
    }

    private static void maybePrintAttribute(CallParamContentNode attributesNode, Optional<ExprNode> conditional, IdGenerator nodeIdGen, HtmlAttributeNode attrNode) {
        SourceLocation unknown = attributesNode.getSourceLocation().clearRange();
        if (conditional.isPresent()) {
            IfNode ifNode = new IfNode(nodeIdGen.genId(), unknown);
            IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), unknown, unknown, "if", conditional.get().copy(new CopyState()));
            ifNode.addChild(ifCondNode);
            ifCondNode.getExpr().setType(conditional.get().getType());
            ifCondNode.addChild(attrNode.copy(new CopyState()));
            attributesNode.addChild(ifNode);
        } else {
            attributesNode.addChild(attrNode.copy(new CopyState()));
        }
    }

    static boolean isOkToPutInElement(HtmlAttributeNode attrNode) {
        return ((SoyNode.StandaloneNode)attrNode.getChild(0)).getKind() == SoyNode.Kind.PRINT_NODE && SoyTypes.makeNullable(SanitizedType.AttributesType.getInstance()).isAssignableFromStrict(((PrintNode)attrNode.getChild(0)).getExpr().getType()) || ((SoyNode.StandaloneNode)attrNode.getChild(0)).getKind() == SoyNode.Kind.CALL_BASIC_NODE && ((TemplateType)((CallBasicNode)attrNode.getChild(0)).getCalleeExpr().getType()).getContentKind().getSanitizedContentKind() == SanitizedContentKind.ATTRIBUTES;
    }

    private SoyNode.StandaloneNode consumeSlot(CallBasicNode callNode, SoyNode startNode, IdGenerator nodeIdGen) {
        SourceLocation unknown = startNode.getSourceLocation().clearRange();
        HtmlOpenTagNode nextOpenTag = (HtmlOpenTagNode)startNode;
        String paramName = ((HtmlAttributeNode)nextOpenTag.getChild(1)).getStaticContent();
        HtmlTagNode closeTag = nextOpenTag.getTaggedPairs().get(0);
        CallParamContentNode callParamContent = new CallParamContentNode(nodeIdGen.genId(), startNode.getSourceLocation(), unknown, Identifier.create(paramName, unknown), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, "html", startNode.getSourceLocation().extend(closeTag.getSourceLocation()), unknown), this.errorReporter);
        callNode.addChild(callParamContent);
        SoyNode.StandaloneNode next = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(nextOpenTag);
        while (next != closeTag) {
            SoyNode.StandaloneNode sibling = (SoyNode.StandaloneNode)SoyTreeUtils.nextSibling(next);
            next.getParent().removeChild(next);
            callParamContent.addChild(next);
            next = sibling;
        }
        nextOpenTag.getParent().removeChild(nextOpenTag);
        SoyNode retNode = SoyTreeUtils.nextSibling(closeTag);
        closeTag.getParent().removeChild(closeTag);
        return (SoyNode.StandaloneNode)retNode;
    }

    @Nullable
    private CallParamNode consumeAttribute(HtmlAttributeNode attr, IdGenerator nodeIdGen, Set<String> seenAttr, Map<String, SoyType> parameterMap, Map<String, AttrParam> attrs, @Nullable CallParamContentNode attributesNode, CallBasicNode call, Optional<ExprNode> condition) {
        SourceLocation unknown = attr.getSourceLocation().clearRange();
        String attrName = attr.getStaticKey();
        boolean isSoyAttr = attrName.startsWith("@");
        if (isSoyAttr) {
            attrName = attrName.substring(1);
        }
        if (!seenAttr.add(attrName)) {
            this.errorReporter.report(((SoyNode.StandaloneNode)attr.getChild(0)).getSourceLocation(), DUPLICATE_ATTRIBUTE, new Object[0]);
            return null;
        }
        String paramName = TemplateType.Parameter.attrToParamName(attrName);
        if (!parameterMap.containsKey(paramName)) {
            SoyElementCompositionPass.maybePrintAttribute(attributesNode, condition, nodeIdGen, attr);
            return null;
        }
        if (isSoyAttr) {
            VarRefNode val = new VarRefNode("$" + paramName, unknown, attrs.get(paramName));
            if (condition.isPresent()) {
                return new CallParamValueNode(nodeIdGen.genId(), attr.getSourceLocation(), Identifier.create(paramName, unknown), Operator.CONDITIONAL.createNode(unknown, unknown, condition.get(), val, new NullNode(unknown)));
            }
            return new CallParamValueNode(nodeIdGen.genId(), attr.getSourceLocation(), Identifier.create(paramName, unknown), val);
        }
        SoyNode.StandaloneNode value = (SoyNode.StandaloneNode)attr.getChild(1);
        if (value.getKind() != SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)value;
        if (!condition.isPresent()) {
            CallParamContentNode contentNode = new CallParamContentNode(nodeIdGen.genId(), attr.getSourceLocation(), unknown, Identifier.create(paramName, unknown), new CommandTagAttribute(Identifier.create("kind", unknown), QuoteStyle.SINGLE, SoyElementCompositionPass.getKind(parameterMap.get(paramName)), unknown, unknown), this.errorReporter);
            CopyState copyState = new CopyState();
            for (SoyNode.StandaloneNode node : attrValue.getChildren()) {
                contentNode.addChild(node.copy(copyState));
            }
            return contentNode;
        }
        LetContentNode letContentNode = LetContentNode.forVariable(nodeIdGen.genId(), unknown, "$__internal_call_" + paramName + nodeIdGen.genId(), unknown, parameterMap.containsKey(paramName) ? SanitizedContentKind.fromAttributeValue(SoyElementCompositionPass.getKind(parameterMap.get(paramName))).get() : SanitizedContentKind.TEXT);
        call.getParent().addChild(call.getParent().getChildIndex(call), letContentNode);
        IfNode ifNode = new IfNode(nodeIdGen.genId(), unknown);
        letContentNode.addChild(ifNode);
        IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), unknown, unknown, "if", condition.get().copy(new CopyState()));
        ifNode.addChild(ifCondNode);
        ifCondNode.getExpr().setType(condition.get().getType());
        CopyState copyState = new CopyState();
        for (SoyNode.StandaloneNode node : attrValue.getChildren()) {
            ifCondNode.addChild(node.copy(copyState));
        }
        VarRefNode varRef = new VarRefNode("$" + letContentNode.getVar().name(), unknown, letContentNode.getVar());
        OperatorNodes.ConditionalOpNode op = (OperatorNodes.ConditionalOpNode)Operator.CONDITIONAL.createNode(unknown, unknown, condition.get(), varRef, new NullNode(unknown));
        op.setType(UnionType.of(NullType.getInstance(), varRef.getType()));
        return new CallParamValueNode(nodeIdGen.genId(), unknown, Identifier.create(paramName, unknown), op);
    }

    private static String getKind(SoyType attrType) {
        attrType = SoyTypes.removeNull(attrType);
        if (SanitizedType.TrustedResourceUriType.getInstance().isAssignableFromStrict(attrType)) {
            return "trusted_resource_uri";
        }
        if (SanitizedType.UriType.getInstance().isAssignableFromStrict(attrType)) {
            return "uri";
        }
        if (SanitizedType.StyleType.getInstance().isAssignableFromStrict(attrType)) {
            return "css";
        }
        return "text";
    }
}

