/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;

final class ValidateSkipNodesPass
implements CompilerFilePass {
    private static final SoyErrorKind SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Skip element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_SKIP_MUST_BE_DIRECT_CHILD_OF_TAG = SoyErrorKind.of("Skip commands must be direct children of html tags.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public ValidateSkipNodesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getTemplates()) {
            int id = 0;
            for (SkipNode skipNode : SoyTreeUtils.getAllNodesOfType(template, SkipNode.class)) {
                if (skipNode.getParent() instanceof HtmlOpenTagNode) {
                    HtmlOpenTagNode openTag = (HtmlOpenTagNode)skipNode.getParent();
                    openTag.setSkipRoot();
                    if (!openTag.isSelfClosing() && openTag.getTaggedPairs().size() > 1) {
                        this.errorReporter.report(openTag.getSourceLocation(), SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                        continue;
                    }
                    skipNode.setSkipId(template.getTemplateName() + "-skip-" + id++);
                    continue;
                }
                this.errorReporter.report(skipNode.getSourceLocation(), SOY_SKIP_MUST_BE_DIRECT_CHILD_OF_TAG, new Object[0]);
            }
        }
    }
}

