/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.plugin.java.internal.CompiledJarsPluginSignatureReader;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.internal.PluginSignatureReader;
import com.google.template.soy.plugin.java.internal.ValidatorErrorReporter;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import java.io.File;
import java.util.List;

public class MethodSignatureValidator {
    private final ErrorReporter errorReporter;
    private final CompiledJarsPluginSignatureReader sigReader;

    public MethodSignatureValidator(List<File> pluginRuntimeJars, ErrorReporter errorReporter) {
        this.sigReader = new CompiledJarsPluginSignatureReader(pluginRuntimeJars);
        this.errorReporter = errorReporter;
    }

    public void validate(String fnName, SoyJavaSourceFunction fn, SourceLocation sourceLocation, boolean includeTriggeredInTemplateMsg) {
        ValidatorErrorReporter reporter = new ValidatorErrorReporter(this.errorReporter, fnName, fn.getClass(), sourceLocation, includeTriggeredInTemplateMsg);
        PluginAnalyzer.PluginMetadata metadata = PluginAnalyzer.analyze(fn);
        for (MethodSignature ref : metadata.instanceMethodSignatures()) {
            this.validateMethodSignature(true, ref, reporter);
        }
        for (MethodSignature ref : metadata.staticMethodSignatures()) {
            this.validateMethodSignature(false, ref, reporter);
        }
    }

    private void validateMethodSignature(boolean expectedInstance, MethodSignature expectedMethod, ValidatorErrorReporter reporter) {
        PluginSignatureReader.ReadMethodData readMethod = this.sigReader.findMethod(expectedMethod);
        if (readMethod == null) {
            reporter.invalidPluginMethod(expectedMethod);
        } else if (expectedInstance != readMethod.instanceMethod()) {
            reporter.staticMismatch(expectedMethod, expectedInstance);
        } else if (!readMethod.returnType().equals(expectedMethod.returnType().getName())) {
            reporter.wrongPluginMethodReturnType(readMethod.returnType(), expectedMethod);
        } else if (readMethod.classIsInterface() != expectedMethod.inInterface()) {
            reporter.interfaceMismatch(expectedMethod);
        }
    }
}

