/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.MsgFuncGenerator;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public final class GenPyExprsVisitor
extends AbstractSoyNodeVisitor<List<PyExpr>> {
    private static final SoyErrorKind UNKNOWN_SOY_PY_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyPySrcPrintDirective ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    private final PythonValueFactoryImpl pluginValueFactory;
    private final GenPyCallExprVisitor genPyCallExprVisitor;
    private final LocalVariableStack localVarExprs;
    private List<PyExpr> pyExprs;
    private final ErrorReporter errorReporter;

    GenPyExprsVisitor(IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, GenPyExprsVisitorFactory genPyExprsVisitorFactory, GenPyCallExprVisitor genPyCallExprVisitor, PythonValueFactoryImpl pluginValueFactory, LocalVariableStack localVarExprs, ErrorReporter errorReporter) {
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
        this.genPyCallExprVisitor = genPyCallExprVisitor;
        this.pluginValueFactory = pluginValueFactory;
        this.localVarExprs = localVarExprs;
        this.errorReporter = errorReporter;
    }

    @Override
    public List<PyExpr> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsPyExprVisitor.exec(node)));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visit(node);
        return this.pyExprs;
    }

    List<PyExpr> execOnChildren(SoyNode.ParentSoyNode<?> node) {
        Preconditions.checkArgument((boolean)this.isComputableAsPyExprVisitor.execOnChildren(node));
        this.pyExprs = new ArrayList<PyExpr>();
        this.visitChildren(node);
        return this.pyExprs;
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        String exprText = BaseUtils.escapeToSoyString(node.getRawText(), false, QuoteStyle.SINGLE);
        this.pyExprs.add(new PyStringExpr(exprText));
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarExprs, this.pluginValueFactory, node, this.errorReporter);
        PyExpr pyExpr = (PyExpr)translator.exec(node.getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPrintDirective directive = directiveNode.getPrintDirective();
            if (!(directive instanceof SoyPySrcPrintDirective)) {
                this.errorReporter.report(directiveNode.getSourceLocation(), UNKNOWN_SOY_PY_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                continue;
            }
            ImmutableList<ExprRootNode> args = directiveNode.getArgs();
            ArrayList<PyExpr> argsPyExprs = new ArrayList<PyExpr>(args.size());
            for (ExprRootNode arg : args) {
                argsPyExprs.add((PyExpr)translator.exec(arg));
            }
            pyExpr = ((SoyPySrcPrintDirective)directive).applyForPySrc(pyExpr, argsPyExprs);
        }
        this.pyExprs.add(pyExpr);
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        PyExpr msg = this.generateMsgFunc(node.getMsg(), false);
        String ternaryExpression = "(%s) if (translator_impl.is_msg_available(%d) or not translator_impl.is_msg_available(%d)) else (%s)";
        long msgId = MsgUtils.computeMsgIdForDualFormat(node.getMsg());
        String usePrimaryOrAlternateMsg = node.getMsg().getAlternateId().isPresent() ? String.format(ternaryExpression, msg.getText(), msgId, node.getMsg().getAlternateId().getAsLong(), this.generateMsgFunc(node.getMsg(), true).getText()) : msg.getText();
        String pyExprText = "";
        if (node.hasFallbackMsg()) {
            long fbAlternateId;
            String useFbOrFbAlternateMsg;
            long fallbackId = MsgUtils.computeMsgIdForDualFormat(node.getFallbackMsg());
            PyStringExpr fallbackMsg = this.generateMsgFunc(node.getFallbackMsg(), false);
            String string = useFbOrFbAlternateMsg = node.getFallbackMsg().getAlternateId().isPresent() ? String.format(ternaryExpression, fallbackMsg.getText(), fallbackId, node.getFallbackMsg().getAlternateId().getAsLong(), this.generateMsgFunc(node.getFallbackMsg(), true).getText()) : fallbackMsg.getText();
            if (node.getMsg().getAlternateId().isPresent()) {
                long alternateId = node.getMsg().getAlternateId().getAsLong();
                if (node.getFallbackMsg().getAlternateId().isPresent()) {
                    fbAlternateId = node.getFallbackMsg().getAlternateId().getAsLong();
                    pyExprText = String.format(usePrimaryOrAlternateMsg + " if (translator_impl.is_msg_available(%d) or translator_impl.is_msg_available(%d) or (not translator_impl.is_msg_available(%d) and not translator_impl.is_msg_available(%d))) else " + useFbOrFbAlternateMsg, msgId, alternateId, fallbackId, fbAlternateId);
                } else {
                    pyExprText = String.format(usePrimaryOrAlternateMsg + " if (translator_impl.is_msg_available(%d) or translator_impl.is_msg_available(%d) or not translator_impl.is_msg_available(%d)) else " + useFbOrFbAlternateMsg, msgId, alternateId, fallbackId);
                }
            } else if (node.getFallbackMsg().getAlternateId().isPresent()) {
                fbAlternateId = node.getFallbackMsg().getAlternateId().getAsLong();
                pyExprText = String.format(usePrimaryOrAlternateMsg + " if (translator_impl.is_msg_available(%d) or (not translator_impl.is_msg_available(%d) and not translator_impl.is_msg_available(%d))) else " + useFbOrFbAlternateMsg, msgId, fallbackId, fbAlternateId);
            } else {
                pyExprText = String.format(ternaryExpression, msg.getText(), msgId, fallbackId, fallbackMsg.getText());
            }
            msg = new PyStringExpr(pyExprText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
        }
        if (!node.hasFallbackMsg() && node.getMsg().getAlternateId().isPresent()) {
            pyExprText = usePrimaryOrAlternateMsg;
            msg = new PyStringExpr(pyExprText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
        }
        for (SoyPrintDirective directive : node.getEscapingDirectives()) {
            Preconditions.checkState((boolean)(directive instanceof SoyPySrcPrintDirective), (String)"Contextual autoescaping produced a bogus directive: %s", (Object)directive.getName());
            msg = ((SoyPySrcPrintDirective)directive).applyForPySrc(msg, (List<PyExpr>)ImmutableList.of());
        }
        this.pyExprs.add(msg);
    }

    private PyStringExpr generateMsgFunc(MsgNode msg, boolean useAlternateId) {
        return new MsgFuncGenerator(this.genPyExprsVisitorFactory, this.pluginValueFactory, msg, this.localVarExprs, this.errorReporter, useAlternateId).getPyExpr();
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenPyExprsVisitor genPyExprsVisitor = this.genPyExprsVisitorFactory.create(this.localVarExprs, this.errorReporter);
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarExprs, this.pluginValueFactory, node, this.errorReporter);
        StringBuilder pyExprTextSb = new StringBuilder();
        boolean hasElse = false;
        int pendingParens = 0;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                PyExpr condBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(icn)).toPyString();
                condBlock = PyExprUtils.maybeProtect(condBlock, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
                pyExprTextSb.append("(").append(condBlock.getText());
                PyExpr condPyExpr = (PyExpr)translator.exec(icn.getExpr());
                pyExprTextSb.append(") if (").append(condPyExpr.getText()).append(") else (");
                ++pendingParens;
                continue;
            }
            if (child instanceof IfElseNode) {
                hasElse = true;
                IfElseNode ien = (IfElseNode)child;
                PyStringExpr elseBlock = PyExprUtils.concatPyExprs(genPyExprsVisitor.exec(ien)).toPyString();
                pyExprTextSb.append(elseBlock.getText()).append(")");
                --pendingParens;
                continue;
            }
            throw new AssertionError((Object)("Unexpected if child node type. Child: " + child));
        }
        if (!hasElse) {
            pyExprTextSb.append("''");
        }
        for (int i = 0; i < pendingParens; ++i) {
            pyExprTextSb.append(")");
        }
        this.pyExprs.add(new PyStringExpr(pyExprTextSb.toString(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL)));
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.pyExprs.add(this.genPyCallExprVisitor.exec(node, this.localVarExprs, this.errorReporter));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    public static final class GenPyExprsVisitorFactory {
        private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
        private final PythonValueFactoryImpl pluginValueFactory;
        private final Supplier<GenPyCallExprVisitor> genPyCallExprVisitor;

        GenPyExprsVisitorFactory(IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, PythonValueFactoryImpl pluginValueFactory, Supplier<GenPyCallExprVisitor> genPyCallExprVisitor) {
            this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
            this.pluginValueFactory = pluginValueFactory;
            this.genPyCallExprVisitor = genPyCallExprVisitor;
        }

        public GenPyExprsVisitor create(LocalVariableStack localVarExprs, ErrorReporter errorReporter) {
            return new GenPyExprsVisitor(this.isComputableAsPyExprVisitor, this, (GenPyCallExprVisitor)this.genPyCallExprVisitor.get(), this.pluginValueFactory, localVarExprs, errorReporter);
        }
    }
}

