/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TranslateToPyExprVisitor
extends AbstractReturningExprNodeVisitor<PyExpr> {
    private static final SoyErrorKind PROTO_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Proto accessors are not supported in pysrc.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_INIT_NOT_SUPPORTED = SoyErrorKind.of("Proto init is not supported in pysrc.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_PY_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Failed to find SoyPySrcFunction ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_PY_SRC_METHOD_NOT_FOUND = SoyErrorKind.of("Failed to find SoyPythonSourceFunction for method ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNTYPED_BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Bracket access on values of unknown type is not supported in pysrc. The expression should be declared as a list or map.", new SoyErrorKind.StyleAllowance[0]);
    private static final PyExpr ERROR = new PyExpr("raise Exception('Soy compilation failed')", Integer.MAX_VALUE);
    private static final PyExpr NONE = new PyExpr("None", Integer.MAX_VALUE);
    private static final PyExpr DATA = new PyExpr("data", Integer.MAX_VALUE);
    private static final PyExpr IJ_DATA = new PyExpr("ijData", Integer.MAX_VALUE);
    private final LocalVariableStack localVarExprs;
    private final ErrorReporter errorReporter;
    private final PythonValueFactoryImpl pluginValueFactory;
    private final SoyFileNode containingFile;

    TranslateToPyExprVisitor(LocalVariableStack localVarExprs, PythonValueFactoryImpl pluginValueFactory, SoyNode containingNode, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.pluginValueFactory = pluginValueFactory;
        this.containingFile = containingNode.getNearestAncestor(SoyFileNode.class);
        this.localVarExprs = localVarExprs;
    }

    @Override
    protected PyExpr visitExprRootNode(ExprRootNode node) {
        return (PyExpr)this.visit(node.getRoot());
    }

    @Override
    protected PyExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new PyExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitStringNode(StringNode node) {
        return new PyStringExpr(node.toSourceString());
    }

    @Override
    protected PyExpr visitNullNode(NullNode node) {
        return NONE;
    }

    @Override
    protected PyExpr visitBooleanNode(BooleanNode node) {
        return new PyExpr(node.getValue() ? "True" : "False", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitListLiteralNode(ListLiteralNode node) {
        return PyExprUtils.convertIterableToPyListExpr(node.getChildren().stream().map(n -> (PyExpr)this.visit((ExprNode)n)).collect(Collectors.toList()));
    }

    @Override
    protected PyExpr visitListComprehensionNode(ListComprehensionNode node) {
        PyExpr originalListExpr = (PyExpr)this.visit(node.getListExpr());
        String baseListIterVarName = node.getListIterVar().name();
        String uniqueListIterVarName = String.format("%sListComprehensions%d", baseListIterVarName, node.getNodeId());
        this.localVarExprs.pushFrame();
        this.localVarExprs.addVariable(baseListIterVarName, new PyExpr(uniqueListIterVarName, Integer.MAX_VALUE));
        String uniqueIndexVarName = null;
        if (node.getIndexVar() != null) {
            String baseIndexVarName = node.getIndexVar().name();
            uniqueIndexVarName = String.format("%sListComprehensions%d", baseIndexVarName, node.getNodeId());
            this.localVarExprs.addVariable(baseIndexVarName, new PyExpr(uniqueIndexVarName, Integer.MAX_VALUE));
        }
        PyExpr itemTransformExpr = (PyExpr)this.visit(node.getListItemTransformExpr());
        PyExpr filterExpr = node.getFilterExpr() == null ? null : (PyExpr)this.visit(node.getFilterExpr());
        PyExpr comprehensionExpr = PyExprUtils.genPyListComprehensionExpr(originalListExpr, itemTransformExpr, filterExpr, uniqueListIterVarName, uniqueIndexVarName);
        this.localVarExprs.popFrame();
        return comprehensionExpr;
    }

    @Override
    protected PyExpr visitRecordLiteralNode(RecordLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() == node.getKeys().size() ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        for (int i = 0; i < node.numChildren(); ++i) {
            dict.put(new PyStringExpr("'" + node.getKey(i) + "'"), (PyExpr)this.visit(node.getChild(i)));
        }
        return PyExprUtils.convertMapToOrderedDict(dict);
    }

    @Override
    protected PyExpr visitMapLiteralNode(MapLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() % 2 == 0 ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            PyExpr key = (PyExpr)this.visit(keyNode);
            key = new PyFunctionExprBuilder("runtime.check_not_null").addArg(key).asPyExpr();
            ExprNode valueNode = node.getChild(i + 1);
            dict.put(key, (PyExpr)this.visit(valueNode));
        }
        return PyExprUtils.convertMapToPyExpr(dict);
    }

    @Override
    protected PyExpr visitVarRefNode(VarRefNode node) {
        if (node.getDefnDecl().kind() == VarDefn.Kind.STATE) {
            throw new AssertionError();
        }
        if (node.isInjected()) {
            return new PyExpr(TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(IJ_DATA, node.getNameWithoutLeadingDollar()), Integer.MAX_VALUE);
        }
        PyExpr translation = this.localVarExprs.getVariableExpression(node.getNameWithoutLeadingDollar());
        if (translation != null) {
            return new PyExpr(translation.getText(), Integer.MAX_VALUE);
        }
        NotFoundBehavior notFoundBehavior = NotFoundBehavior.throwException();
        if (node.getDefnDecl().kind() == VarDefn.Kind.PARAM && ((TemplateParam)node.getDefnDecl()).hasDefault()) {
            PyExpr defaultValue = (PyExpr)this.visit(((TemplateParam)node.getDefnDecl()).defaultValue());
            notFoundBehavior = NotFoundBehavior.defaultValue(defaultValue);
        }
        return new PyExpr(TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(DATA, node.getNameWithoutLeadingDollar(), notFoundBehavior), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitDataAccessNode(DataAccessNode node) {
        Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
        PyExpr base = (PyExpr)this.visit(node.getBaseExprChild());
        return new PyExpr(this.visitDataAccessNode(node, base), Integer.MAX_VALUE);
    }

    private PyExpr visitDataAccessNode(DataAccessNode dataAccess, StringBuilder nullSafetyPrefix, PyExpr base, boolean nullSafe, boolean hasAssertNonNull) {
        if (nullSafe) {
            nullSafetyPrefix.append("None if ").append(base.getText()).append(" is None else ");
        }
        PyExpr result = new PyExpr(this.visitDataAccessNode(dataAccess, base), Integer.MAX_VALUE);
        if (hasAssertNonNull) {
            result = TranslateToPyExprVisitor.assertNotNull(result);
        }
        return result;
    }

    private String visitDataAccessNode(DataAccessNode dataAccess, PyExpr base) {
        if (dataAccess.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
            FieldAccessNode fieldAccess = (FieldAccessNode)dataAccess;
            return this.genCodeForFieldAccess(fieldAccess, fieldAccess.getBaseExprChild().getType(), base, fieldAccess.getFieldName());
        }
        if (dataAccess.getKind() == ExprNode.Kind.METHOD_CALL_NODE) {
            MethodCallNode methodCall = (MethodCallNode)dataAccess;
            return this.genCodeForMethodCall(methodCall, base);
        }
        ItemAccessNode itemAccess = (ItemAccessNode)dataAccess;
        SoyType.Kind baseKind = itemAccess.getBaseExprChild().getType().getKind();
        PyExpr keyPyExpr = (PyExpr)this.visit(itemAccess.getKeyExprChild());
        switch (baseKind) {
            case LIST: {
                return TranslateToPyExprVisitor.genCodeForKeyAccess(base, keyPyExpr, NotFoundBehavior.returnNone());
            }
            case UNKNOWN: {
                this.errorReporter.report(itemAccess.getKeyExprChild().getSourceLocation(), UNTYPED_BRACKET_ACCESS_NOT_SUPPORTED, new Object[0]);
            }
            case MAP: 
            case UNION: {
                return TranslateToPyExprVisitor.genCodeForKeyAccess(base, keyPyExpr, NotFoundBehavior.returnNone());
            }
            case LEGACY_OBJECT_MAP: 
            case RECORD: {
                return TranslateToPyExprVisitor.genCodeForKeyAccess(base, keyPyExpr, NotFoundBehavior.throwException());
            }
        }
        throw new AssertionError((Object)("illegal item access on " + (Object)((Object)baseKind)));
    }

    @Override
    protected PyExpr visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        PyExpr access = (PyExpr)this.visit(nullSafeAccessNode.getBase());
        ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
        while (dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
            access = this.accumulateDataAccess((DataAccessNode)node.getBase(), access, nullSafetyPrefix, false);
            dataAccess = node.getDataAccess();
        }
        access = this.accumulateDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, access, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return access;
        }
        return new PyExpr(nullSafetyPrefix + access.getText(), PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private PyExpr accumulateDataAccess(DataAccessNode dataAccessNode, PyExpr base, StringBuilder nullSafetyPrefix, boolean hasAssertNonNull) {
        boolean nullSafe = true;
        if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
            base = this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), base, nullSafetyPrefix, false);
            nullSafe = false;
        }
        return this.visitDataAccessNode(dataAccessNode, nullSafetyPrefix, base, nullSafe, hasAssertNonNull);
    }

    private PyExpr accumulateDataAccessTail(ExprNode.AccessChainComponentNode dataAccessNode, PyExpr base, StringBuilder nullSafetyPrefix) {
        boolean hasAssertNonNull = false;
        if (dataAccessNode.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
            OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccessNode;
            dataAccessNode = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
            hasAssertNonNull = true;
        }
        return this.accumulateDataAccess((DataAccessNode)dataAccessNode, base, nullSafetyPrefix, hasAssertNonNull);
    }

    @Override
    protected PyExpr visitGlobalNode(GlobalNode node) {
        return (PyExpr)this.visit(node.getValue());
    }

    @Override
    protected PyExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genPyExprUsingSoySyntax(node);
    }

    @Override
    protected PyExpr visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List children = this.visitChildren(node);
        PyExpr conditionalExpr = PyExprUtils.genPyNotNullCheck((PyExpr)children.get(0));
        PyExpr trueExpr = (PyExpr)children.get(0);
        PyExpr falseExpr = (PyExpr)children.get(1);
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("not runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", PyExprUtils.pyPrecedenceForOperator(Operator.NOT));
    }

    @Override
    protected PyExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_add(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Operator op = Operator.CONDITIONAL;
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        List operandExprs = this.visitChildren(node);
        Operator.Operand conditionalOperand = (Operator.Operand)syntax.get(0);
        PyExpr conditionalExpr = (PyExpr)operandExprs.get(conditionalOperand.getIndex());
        Operator.Operand trueOperand = (Operator.Operand)syntax.get(4);
        PyExpr trueExpr = (PyExpr)operandExprs.get(trueOperand.getIndex());
        Operator.Operand falseOperand = (Operator.Operand)syntax.get(8);
        PyExpr falseExpr = (PyExpr)operandExprs.get(falseOperand.getIndex());
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
        return this.assertNotNull(node.getChild(0));
    }

    @Override
    protected PyExpr visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            return this.visitNonPluginFunction(node, (BuiltinFunction)soyFunction);
        }
        if (soyFunction instanceof SoyPythonSourceFunction) {
            return this.pluginValueFactory.applyFunction(node.getSourceLocation(), node.getStaticFunctionName(), (SoyPythonSourceFunction)soyFunction, this.visitChildren(node));
        }
        if (soyFunction instanceof SoyPySrcFunction) {
            List<PyExpr> args = this.visitChildren(node);
            return ((SoyPySrcFunction)soyFunction).computeForPySrc(args);
        }
        if (soyFunction instanceof LoggingFunction) {
            return new PyStringExpr("'" + ((LoggingFunction)soyFunction).getPlaceholder() + "'");
        }
        this.errorReporter.report(node.getSourceLocation(), SOY_PY_SRC_FUNCTION_NOT_FOUND, node.getStaticFunctionName());
        return ERROR;
    }

    private PyExpr visitNonPluginFunction(FunctionNode node, BuiltinFunction nonpluginFn) {
        switch (nonpluginFn) {
            case IS_PARAM_SET: {
                return this.visitIsSetFunction(node);
            }
            case IS_FIRST: {
                return this.visitForEachFunction(node, "__isFirst");
            }
            case IS_LAST: {
                return this.visitForEachFunction(node, "__isLast");
            }
            case INDEX: {
                return this.visitForEachFunction(node, "__index");
            }
            case CHECK_NOT_NULL: {
                return this.assertNotNull(node.getChild(0));
            }
            case CSS: {
                return this.visitCssFunction(node);
            }
            case XID: {
                return this.visitXidFunction(node);
            }
            case SOY_SERVER_KEY: {
                return this.visitSoyServerKeyFunction(node);
            }
            case IS_PRIMARY_MSG_IN_USE: {
                return this.visitIsPrimaryMsgInUseFunction(node);
            }
            case TO_FLOAT: {
                return (PyExpr)this.visit(node.getChild(0));
            }
            case DEBUG_SOY_TEMPLATE_INFO: {
                return new PyExpr("False", Integer.MAX_VALUE);
            }
            case LEGACY_DYNAMIC_TAG: 
            case UNKNOWN_JS_GLOBAL: {
                throw new UnsupportedOperationException("the " + nonpluginFn.getName() + " function can't be used in templates compiled to Python");
            }
            case VE_DATA: {
                return NONE;
            }
            case MSG_WITH_ID: 
            case REMAINDER: 
            case TEMPLATE: {
                throw new AssertionError();
            }
            case PROTO_INIT: {
                this.errorReporter.report(node.getSourceLocation(), PROTO_INIT_NOT_SUPPORTED, new Object[0]);
                return ERROR;
            }
        }
        throw new AssertionError();
    }

    private PyExpr visitForEachFunction(FunctionNode node, String suffix) {
        String varName = ((VarRefNode)node.getChild(0)).getNameWithoutLeadingDollar();
        return this.localVarExprs.getVariableExpression(varName + suffix);
    }

    private PyExpr visitIsSetFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getNameWithoutLeadingDollar();
        return new PyFunctionExprBuilder("runtime.is_set").addArg(varName).addArg(DATA).asPyExpr();
    }

    private PyExpr assertNotNull(ExprNode node) {
        return TranslateToPyExprVisitor.assertNotNull((PyExpr)this.visit(node));
    }

    private static PyExpr assertNotNull(PyExpr expr) {
        return new PyFunctionExprBuilder("runtime.check_not_null").addArg(expr).asPyExpr();
    }

    private PyExpr visitCssFunction(FunctionNode node) {
        return new PyFunctionExprBuilder("runtime.get_css_name").addArgs(this.visitChildren(node)).asPyExpr();
    }

    private PyExpr visitXidFunction(FunctionNode node) {
        return new PyFunctionExprBuilder("runtime.get_xid_name").addArg((PyExpr)this.visit(node.getChild(0))).asPyExpr();
    }

    private PyExpr visitSoyServerKeyFunction(FunctionNode node) {
        return (PyExpr)this.visit(node.getChild(0));
    }

    private PyExpr visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        long primaryMsgId = ((IntegerNode)node.getChild(1)).getValue();
        long fallbackMsgId = ((IntegerNode)node.getChild(2)).getValue();
        return new PyExpr("translator_impl.is_msg_available(" + primaryMsgId + ") or not " + "translator_impl" + ".is_msg_available(" + fallbackMsgId + ")", PyExprUtils.pyPrecedenceForOperator(Operator.OR));
    }

    private static String genCodeForLiteralKeyAccess(PyExpr containerExpr, String key) {
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(containerExpr, key, NotFoundBehavior.throwException());
    }

    private static String genCodeForLiteralKeyAccess(PyExpr containerExpr, String key, NotFoundBehavior notFoundBehavior) {
        return TranslateToPyExprVisitor.genCodeForKeyAccess(containerExpr, new PyStringExpr("'" + key + "'"), notFoundBehavior);
    }

    private static String genCodeForKeyAccess(PyExpr containerExpr, PyExpr key, NotFoundBehavior notFoundBehavior) {
        switch (notFoundBehavior.getType()) {
            case RETURN_NONE: {
                return new PyFunctionExprBuilder("runtime.key_safe_data_access").addArg(containerExpr).addArg(key).build();
            }
            case THROW: {
                return new PyFunctionExprBuilder(containerExpr.getText() + ".get").addArg(key).build();
            }
            case DEFAULT_VALUE: {
                return new PyFunctionExprBuilder(containerExpr.getText() + ".get").addArg(key).addArg(notFoundBehavior.getDefaultValue()).build();
            }
        }
        throw new AssertionError((Object)notFoundBehavior.getType());
    }

    private String genCodeForFieldAccess(ExprNode node, SoyType baseType, PyExpr containerExpr, String fieldName) {
        if (baseType != null && baseType.getKind() == SoyType.Kind.PROTO) {
            this.errorReporter.report(node.getSourceLocation(), PROTO_ACCESS_NOT_SUPPORTED, new Object[0]);
            return ".ERROR";
        }
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(containerExpr, fieldName);
    }

    private String genCodeForMethodCall(MethodCallNode methodCallNode, PyExpr containerExpr) {
        Preconditions.checkArgument((boolean)methodCallNode.isMethodResolved());
        SoyMethod method = methodCallNode.getSoyMethod();
        containerExpr = TranslateToPyExprVisitor.assertNotNull(containerExpr);
        if (method instanceof BuiltinMethod) {
            switch ((BuiltinMethod)method) {
                case BIND: {
                    return new PyFunctionExprBuilder("runtime.bind_template_params").addArg(containerExpr).addArg((PyExpr)this.visit(methodCallNode.getChild(1))).asPyExpr().getText();
                }
                case GET_EXTENSION: 
                case HAS_PROTO_FIELD: {
                    this.errorReporter.report(methodCallNode.getAccessSourceLocation(), SOY_PY_SRC_METHOD_NOT_FOUND, methodCallNode.getMethodName());
                    return ".ERROR";
                }
            }
        } else if (method instanceof SoySourceFunctionMethod) {
            SoySourceFunction function = ((SoySourceFunctionMethod)method).getImpl();
            if (function instanceof SoyPythonSourceFunction) {
                ArrayList<PyExpr> args = new ArrayList<PyExpr>();
                args.add(containerExpr);
                methodCallNode.getParams().forEach(n -> args.add((PyExpr)this.visit((ExprNode)n)));
                return this.pluginValueFactory.applyFunction(methodCallNode.getSourceLocation(), methodCallNode.getMethodName().identifier(), (SoyPythonSourceFunction)function, args).getText();
            }
            this.errorReporter.report(methodCallNode.getAccessSourceLocation(), SOY_PY_SRC_METHOD_NOT_FOUND, methodCallNode.getMethodName());
            return ".ERROR";
        }
        throw new AssertionError();
    }

    private PyExpr genPyExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        List operandPyExprs = this.visitChildren(opNode);
        String newExpr = PyExprUtils.genExprWithNewToken(opNode.getOperator(), operandPyExprs, null);
        return new PyExpr(newExpr, PyExprUtils.pyPrecedenceForOperator(opNode.getOperator()));
    }

    private PyExpr genTernaryConditional(PyExpr conditionalExpr, PyExpr trueExpr, PyExpr falseExpr) {
        int conditionalPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL);
        StringBuilder exprSb = new StringBuilder().append(PyExprUtils.maybeProtect(trueExpr, conditionalPrecedence).getText()).append(" if ").append(PyExprUtils.maybeProtect(conditionalExpr, conditionalPrecedence).getText()).append(" else ").append(PyExprUtils.maybeProtect(falseExpr, conditionalPrecedence).getText());
        return new PyExpr(exprSb.toString(), conditionalPrecedence);
    }

    @Override
    protected PyExpr visitVeLiteralNode(VeLiteralNode node) {
        return NONE;
    }

    @Override
    protected PyExpr visitTemplateLiteralNode(TemplateLiteralNode node) {
        String name;
        TemplateNode template = this.getTemplateIfInSameFile(node);
        if (template != null) {
            name = GenPyCallExprVisitor.getLocalTemplateName(template);
        } else {
            String resolvedName = node.getResolvedName();
            int secondToLastDotIndex = resolvedName.lastIndexOf(46, resolvedName.lastIndexOf(46) - 1);
            name = resolvedName.substring(secondToLastDotIndex + 1);
        }
        PyExpr calleeExpr = new PyExpr(name, Integer.MAX_VALUE);
        return node.isSynthetic() ? calleeExpr : new PyFunctionExprBuilder("runtime.create_template_type").addArg(calleeExpr).addArg(new PyStringExpr("'" + node.getResolvedName() + "'")).asPyExpr();
    }

    @Nullable
    private TemplateNode getTemplateIfInSameFile(TemplateLiteralNode templateLiteralNode) {
        for (TemplateNode template : this.containingFile.getTemplates()) {
            if (!(template instanceof TemplateBasicNode) && !(template instanceof TemplateElementNode) || !template.getTemplateName().equals(templateLiteralNode.getResolvedName())) continue;
            return template;
        }
        return null;
    }

    private static class NotFoundBehavior {
        private static final NotFoundBehavior RETURN_NONE = new NotFoundBehavior(Type.RETURN_NONE);
        private static final NotFoundBehavior THROW = new NotFoundBehavior(Type.THROW);
        private final Type type;
        @Nullable
        private final PyExpr defaultValue;

        private static NotFoundBehavior returnNone() {
            return RETURN_NONE;
        }

        private static NotFoundBehavior throwException() {
            return THROW;
        }

        private static NotFoundBehavior defaultValue(PyExpr defaultValue) {
            return new NotFoundBehavior(defaultValue);
        }

        private NotFoundBehavior(Type type) {
            this.type = type;
            this.defaultValue = null;
        }

        private NotFoundBehavior(PyExpr defaultValue) {
            this.type = Type.DEFAULT_VALUE;
            this.defaultValue = (PyExpr)Preconditions.checkNotNull((Object)defaultValue);
        }

        private Type getType() {
            return this.type;
        }

        private PyExpr getDefaultValue() {
            return this.defaultValue;
        }

        private static enum Type {
            RETURN_NONE,
            THROW,
            DEFAULT_VALUE;

        }
    }
}

