/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal.gencode;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.soytree.ImportNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaGenerationUtils {
    private static final Pattern ALL_UPPER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [A-Z]+  (?= [^A-Za-z] | $)", 4);
    private static final Pattern ALL_LOWER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [a-z]+  (?= [^a-z] | $)", 4);
    private static final Pattern NON_LETTER_DIGIT = Pattern.compile("[^A-Za-z0-9]");

    private JavaGenerationUtils() {
    }

    public static void appendJavadoc(IndentedLinesBuilder ilb, String doc, boolean forceMultiline, boolean wrapAt100Chars) {
        if (wrapAt100Chars) {
            int wrapLen = 100 - ilb.getCurrIndentLen() - 7;
            ArrayList wrappedLines = Lists.newArrayList();
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                while (line.length() > wrapLen) {
                    int spaceIndex = line.lastIndexOf(32, wrapLen);
                    if (spaceIndex >= 0) {
                        wrappedLines.add(line.substring(0, spaceIndex));
                        line = line.substring(spaceIndex + 1);
                        continue;
                    }
                    wrappedLines.add(line.substring(0, wrapLen));
                    line = line.substring(wrapLen);
                }
                wrappedLines.add(line);
            }
            doc = Joiner.on((String)"\n").join((Iterable)wrappedLines);
        }
        if (doc.contains("\n") || forceMultiline) {
            ilb.appendLine("/**");
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                ilb.appendLine(" * ", line);
            }
            ilb.appendLine(" */");
        } else {
            ilb.appendLine("/** ", doc, " */");
        }
    }

    public static String makeUpperCamelCase(String str) {
        str = JavaGenerationUtils.makeWordsCapitalized(str, ALL_UPPER_WORD);
        str = JavaGenerationUtils.makeWordsCapitalized(str, ALL_LOWER_WORD);
        str = NON_LETTER_DIGIT.matcher(str).replaceAll("");
        return str;
    }

    public static String makeLowerCamelCase(String str) {
        str = JavaGenerationUtils.makeUpperCamelCase(str);
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    private static String makeWordsCapitalized(String str, Pattern wordPattern) {
        StringBuffer sb = new StringBuffer();
        Matcher wordMatcher = wordPattern.matcher(str);
        while (wordMatcher.find()) {
            String oldWord = wordMatcher.group();
            StringBuilder newWord = new StringBuilder();
            int n = oldWord.length();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    newWord.append(Character.toUpperCase(oldWord.charAt(i)));
                    continue;
                }
                newWord.append(Character.toLowerCase(oldWord.charAt(i)));
            }
            wordMatcher.appendReplacement(sb, Matcher.quoteReplacement(newWord.toString()));
        }
        wordMatcher.appendTail(sb);
        return sb.toString();
    }

    public static void appendImmutableList(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        ilb.appendLineStart("");
        JavaGenerationUtils.appendImmutableListInline(ilb, typeParamSnippet, itemSnippets);
    }

    public static void appendImmutableListInline(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "ImmutableList." + typeParamSnippet + "of", itemSnippets);
    }

    public static void appendImmutableSet(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        ilb.appendLineStart("");
        JavaGenerationUtils.appendImmutableSetInline(ilb, typeParamSnippet, itemSnippets);
    }

    public static void appendImmutableSetInline(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "ImmutableSet." + typeParamSnippet + "of", itemSnippets);
    }

    public static void appendImmutableMap(IndentedLinesBuilder ilb, String typeParamSnippet, Map<String, String> entrySnippetPairs) {
        if (entrySnippetPairs.isEmpty()) {
            ilb.appendLineStart("ImmutableMap.", typeParamSnippet, "of()");
        } else {
            ilb.appendLine("ImmutableMap.", typeParamSnippet, "builder()");
            ilb.increaseIndent(2);
            for (Map.Entry<String, String> entrySnippetPair : entrySnippetPairs.entrySet()) {
                ilb.appendLine(".put(", entrySnippetPair.getKey(), ", ", entrySnippetPair.getValue(), ")");
            }
            ilb.appendLineStart(".build()");
            ilb.decreaseIndent(2);
        }
    }

    public static void appendFunctionCallWithParamsOnNewLines(IndentedLinesBuilder ilb, String functionCallSnippet, Collection<String> params) {
        if (params.isEmpty()) {
            ilb.appendParts(functionCallSnippet, "()");
            return;
        }
        ilb.appendLineEnd(functionCallSnippet, "(");
        ilb.increaseIndent(2);
        boolean isFirst = true;
        for (String param : params) {
            if (isFirst) {
                isFirst = false;
            } else {
                ilb.appendLineEnd(",");
            }
            ilb.appendLineStart(param);
        }
        ilb.append(")");
        ilb.decreaseIndent(2);
    }

    public static Set<String> getProtoTypes(SoyFileNode node, SoyTypeRegistry typeRegistry) {
        Stream<String> fromImports = node.getImports().stream().filter(i -> i.getImportType() == ImportNode.ImportType.PROTO).flatMap(i -> i.getIdentifiers().stream()).map(varName -> typeRegistry.getType(varName.name())).filter(Objects::nonNull).map(type -> {
            if (type.getKind() == SoyType.Kind.PROTO) {
                return ((SoyProtoType)type).getDescriptorExpression();
            }
            if (type.getKind() == SoyType.Kind.PROTO_ENUM) {
                return ((SoyProtoEnumType)type).getDescriptorExpression();
            }
            return null;
        }).filter(Objects::nonNull);
        return Streams.concat((Stream[])new Stream[]{fromImports, SoyTreeUtils.allNodesOfType(node, TemplateNode.class).flatMap(template -> JavaGenerationUtils.getProtoTypes(template, typeRegistry))}).collect(Collectors.toSet());
    }

    private static Stream<String> getProtoTypes(TemplateNode template, SoyTypeRegistry typeRegistry) {
        Stream fromHeader = template.getHeaderParams().stream().flatMap(varDefn -> JavaGenerationUtils.findProtoTypes(varDefn.type(), typeRegistry));
        Stream fromCall = SoyTreeUtils.allNodesOfType(template, MethodCallNode.class).filter(MethodCallNode::isMethodResolved).filter(n -> n.getSoyMethod() instanceof BuiltinMethod).flatMap(methodNode -> ((BuiltinMethod)methodNode.getSoyMethod()).getProtoDependencyTypes((MethodCallNode)methodNode).stream());
        Stream<String> fromGlobal = SoyTreeUtils.allNodesOfType(template, GlobalNode.class).filter(global -> global.isResolved() && global.getType().getKind() == SoyType.Kind.PROTO_ENUM).map(global -> ((SoyProtoEnumType)global.getType()).getDescriptorExpression());
        Stream fromProtoInit = SoyTreeUtils.allNodesOfType(template, FunctionNode.class).filter(fctNode -> fctNode.getSoyFunction() == BuiltinFunction.PROTO_INIT).filter(fctNode -> fctNode.getType().getKind() == SoyType.Kind.PROTO).flatMap(fctNode -> {
            SoyProtoType proto = (SoyProtoType)fctNode.getType();
            return Streams.concat((Stream[])new Stream[]{Stream.of(proto.getDescriptorExpression()), fctNode.getParamNames().stream().map(paramName -> proto.getFieldDescriptor(paramName.identifier())).filter(Descriptors.FieldDescriptor::isExtension).map(ProtoUtils::getQualifiedOuterClassname)});
        });
        return Streams.concat((Stream[])new Stream[]{fromHeader, fromCall, fromGlobal, fromProtoInit});
    }

    private static Stream<String> findProtoTypes(SoyType root, SoyTypeRegistry typeRegistry) {
        return Streams.stream(JavaGenerationUtils.typeIterator(root, typeRegistry)).map(type -> {
            switch (type.getKind()) {
                case PROTO: {
                    return ((SoyProtoType)type).getDescriptorExpression();
                }
                case PROTO_ENUM: {
                    return ((SoyProtoEnumType)type).getDescriptorExpression();
                }
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private static Iterator<? extends SoyType> typeIterator(SoyType root, SoyTypeRegistry typeRegistry) {
        return SoyTypes.getTypeTraverser(root, typeRegistry);
    }
}

