/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import com.google.template.soy.sharedpasses.opti.PreevalVisitorFactory;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

final class PrerenderVisitor
extends RenderVisitor {
    PrerenderVisitor(PreevalVisitorFactory preevalVisitorFactory, Appendable outputBuf, ImmutableMap<String, TemplateNode> basicTemplates) {
        super(preevalVisitorFactory, outputBuf, basicTemplates, new DelTemplateSelector.Builder().build(), ParamStore.EMPTY_INSTANCE, null, null, null, null, null, false, (ImmutableMap<String, Supplier<Object>>)ImmutableMap.of());
    }

    @Override
    protected PrerenderVisitor createHelperInstance(Appendable outputBuf, SoyRecord data) {
        return new PrerenderVisitor((PreevalVisitorFactory)this.evalVisitorFactory, outputBuf, (ImmutableMap<String, TemplateNode>)this.basicTemplates);
    }

    @Override
    public Void exec(SoyNode soyNode) {
        this.env = Environment.prerenderingEnvironment();
        try {
            return super.exec(soyNode);
        }
        catch (RenderException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw RenderException.create("Failed prerender due to exception: " + e.getMessage(), e);
        }
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        throw RenderException.create("Cannot prerender MsgFallbackGroupNode.");
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        throw RenderException.create("Cannot prerender CallDelegateNode.");
    }

    @Override
    protected void visitLogNode(LogNode node) {
        throw RenderException.create("Cannot prerender LogNode.");
    }

    @Override
    protected void visitKeyNode(KeyNode node) {
        throw RenderException.create("Cannot prerender KeyNode.");
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        throw RenderException.create("Cannot prerender DebuggerNode.");
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            if (this.isSoyPurePrintDirective(directiveNode)) continue;
            throw RenderException.create("Cannot prerender a node with some impure print directive.");
        }
        super.visitPrintNode(node);
    }

    @Override
    protected void visitPrintDirectiveNode(PrintDirectiveNode node) {
        if (!this.isSoyPurePrintDirective(node)) {
            throw RenderException.create("Cannot prerender impure print directive.");
        }
        super.visitPrintDirectiveNode(node);
    }

    private boolean isSoyPurePrintDirective(PrintDirectiveNode node) {
        SoyPrintDirective directive = node.getPrintDirective();
        return directive instanceof SoyJavaPrintDirective && directive.getClass().isAnnotationPresent(SoyPurePrintDirective.class);
    }
}

