/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;

public abstract class Environment {
    Environment() {
    }

    static Environment create(TemplateNode template, SoyRecord data, SoyRecord ijData) {
        return new Impl(template, data, ijData);
    }

    public static Environment prerenderingEnvironment() {
        return new EmptyImpl();
    }

    abstract void bind(VarDefn var1, SoyValueProvider var2);

    abstract void bindLoopPosition(VarDefn var1, SoyValueProvider var2, int var3, boolean var4);

    abstract SoyValue getVar(VarDefn var1);

    abstract boolean hasVar(VarDefn var1);

    abstract SoyValueProvider getVarProvider(VarDefn var1);

    abstract boolean isLast(VarDefn var1);

    abstract int getIndex(VarDefn var1);

    @Nullable
    abstract ConstNode lookupConst(ConstVar var1);

    private static final class EmptyImpl
    extends Environment {
        private EmptyImpl() {
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void bindLoopPosition(VarDefn loopVar, SoyValueProvider value, int index, boolean isLast) {
            throw new UnsupportedOperationException();
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        SoyValue getVar(VarDefn var) {
            return UndefinedData.INSTANCE;
        }

        @Override
        boolean hasVar(VarDefn var) {
            return false;
        }

        @Override
        boolean isLast(VarDefn loopVar) {
            return UndefinedData.INSTANCE.booleanValue();
        }

        @Override
        int getIndex(VarDefn loopVar) {
            return UndefinedData.INSTANCE.integerValue();
        }

        @Override
        ConstNode lookupConst(ConstVar defnDecl) {
            return null;
        }
    }

    private static final class Impl
    extends Environment {
        final IdentityHashMap<VarDefn, Object> localVariables = new IdentityHashMap();
        final ImmutableMap<String, ConstNode> constants;
        final SoyRecord data;

        Impl(TemplateNode template, SoyRecord data, SoyRecord ijData) {
            this.data = data;
            for (TemplateParam param : template.getAllParams()) {
                SoyValueProvider provider = (param.isInjected() ? ijData : data).getFieldProvider(param.name());
                if (provider == null) {
                    provider = param.isRequired() || param.hasDefault() ? UndefinedData.INSTANCE : NullData.INSTANCE;
                }
                this.bind(param, provider);
            }
            this.constants = (ImmutableMap)template.getParent().getConstants().stream().collect(ImmutableMap.toImmutableMap(c -> c.getVar().name(), c -> c));
        }

        @Override
        void bind(VarDefn var, SoyValueProvider value) {
            this.localVariables.put(var, value);
        }

        @Override
        void bindLoopPosition(VarDefn loopVar, SoyValueProvider value, int index, boolean isLast) {
            LoopPosition position = (LoopPosition)this.localVariables.computeIfAbsent(loopVar, ignored -> new LoopPosition());
            position.item = value;
            position.index = index;
            position.isLast = isLast;
        }

        @Override
        SoyValueProvider getVarProvider(VarDefn var) {
            if (var.kind() == VarDefn.Kind.UNDECLARED) {
                SoyValueProvider provider = this.data.getFieldProvider(var.name());
                return provider != null ? provider : UndefinedData.INSTANCE;
            }
            Object o = this.localVariables.get(var);
            if (o instanceof LoopPosition) {
                return ((LoopPosition)o).item;
            }
            return (SoyValueProvider)o;
        }

        @Override
        SoyValue getVar(VarDefn var) {
            return this.getVarProvider(var).resolve();
        }

        @Override
        boolean hasVar(VarDefn var) {
            return this.data.hasField(var.name());
        }

        @Override
        boolean isLast(VarDefn var) {
            return ((LoopPosition)this.localVariables.get((Object)var)).isLast;
        }

        @Override
        int getIndex(VarDefn var) {
            return ((LoopPosition)this.localVariables.get((Object)var)).index;
        }

        @Override
        ConstNode lookupConst(ConstVar defnDecl) {
            return (ConstNode)this.constants.get((Object)defnDecl.name());
        }

        private static final class LoopPosition {
            boolean isLast;
            int index;
            SoyValueProvider item;

            private LoopPosition() {
            }
        }
    }
}

