/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyRecords;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.TofuTemplateValue;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.plugin.internal.JavaPluginExecContext;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.BuiltinMethod;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyMethod;
import com.google.template.soy.shared.restricted.SoySourceFunctionMethod;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.TofuPluginContext;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.sharedpasses.render.TofuValueFactory;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.defn.ConstVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class EvalVisitor
extends AbstractReturningExprNodeVisitor<SoyValue> {
    static final SoyVisualElement UNDEFINED_VE = SoyVisualElement.create(-1L, "UndefinedVe");
    static final SoyVisualElementData UNDEFINED_VE_DATA = SoyVisualElementData.create(UNDEFINED_VE, null);
    private final Environment env;
    @Nullable
    private final SoyMsgBundle msgBundle;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final boolean debugSoyTemplateInfo;
    private final TofuPluginContext context;
    private final ImmutableMap<String, Supplier<Object>> pluginInstances;
    private final UndefinedDataHandlingMode undefinedDataHandlingMode;

    protected EvalVisitor(Environment env, @Nullable SoyCssRenamingMap cssRenamingMap, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyMsgBundle msgBundle, boolean debugSoyTemplateInfo, ImmutableMap<String, Supplier<Object>> pluginInstances, UndefinedDataHandlingMode undefinedDataHandlingMode) {
        this.env = (Environment)Preconditions.checkNotNull((Object)env);
        this.msgBundle = msgBundle;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.context = new TofuPluginContext(msgBundle);
        this.pluginInstances = (ImmutableMap)Preconditions.checkNotNull(pluginInstances);
        this.undefinedDataHandlingMode = (UndefinedDataHandlingMode)((Object)Preconditions.checkNotNull((Object)((Object)undefinedDataHandlingMode)));
    }

    @Override
    protected SoyValue visitExprRootNode(ExprRootNode node) {
        return (SoyValue)this.visit(node.getRoot());
    }

    @Override
    protected SoyValue visitNullNode(NullNode node) {
        return NullData.INSTANCE;
    }

    @Override
    protected SoyValue visitBooleanNode(BooleanNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitIntegerNode(IntegerNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitFloatNode(FloatNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitStringNode(StringNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitProtoEnumValueNode(ProtoEnumValueNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitGlobalNode(GlobalNode node) {
        return (SoyValue)this.visit(node.getValue());
    }

    @Override
    protected SoyValue visitListLiteralNode(ListLiteralNode node) {
        List values = this.visitChildren(node);
        return ListImpl.forProviderList(values);
    }

    @Override
    protected SoyValue visitListComprehensionNode(ListComprehensionNode node) {
        ExprNode listExpr = node.getListExpr();
        SoyValue listValue = (SoyValue)this.visit(listExpr);
        if (!(listValue instanceof SoyList)) {
            throw RenderException.create(String.format("List expression is not a list: %s", listValue));
        }
        ExprNode mapExpr = node.getListItemTransformExpr();
        ExprNode filterExpr = node.getFilterExpr();
        ListComprehensionNode.ComprehensionVarDefn itemName = node.getListIterVar();
        ImmutableList.Builder mappedValues = ImmutableList.builder();
        List<? extends SoyValueProvider> list = ((SoyList)listValue).asJavaList();
        for (int i = 0; i < list.size(); ++i) {
            this.env.bind(itemName, list.get(i));
            if (node.getIndexVar() != null) {
                this.env.bind(node.getIndexVar(), SoyValueConverter.INSTANCE.convert(i));
            }
            if (filterExpr != null && !((SoyValue)this.visit(filterExpr)).coerceToBoolean()) continue;
            SoyValue mappedValue = (SoyValue)this.visit(mapExpr);
            mappedValues.add((Object)mappedValue);
        }
        return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)mappedValues.build());
    }

    @Override
    protected SoyValue visitRecordLiteralNode(RecordLiteralNode node) {
        int numItems = node.numChildren();
        LinkedHashMap<String, SoyValue> map = new LinkedHashMap<String, SoyValue>();
        for (int i = 0; i < numItems; ++i) {
            map.put(node.getKey(i).identifier(), (SoyValue)this.visit(node.getChild(i)));
        }
        return DictImpl.forProviderMap(map, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    @Override
    protected SoyValue visitMapLiteralNode(MapLiteralNode node) {
        int numItems = node.numChildren() / 2;
        HashMap<SoyValue, SoyValue> map = new HashMap<SoyValue, SoyValue>();
        for (int i = 0; i < numItems; ++i) {
            SoyValue key = (SoyValue)this.visit(node.getChild(2 * i));
            SoyValue value = (SoyValue)this.visit(node.getChild(2 * i + 1));
            if (EvalVisitor.isNullOrUndefinedBase(key)) {
                throw RenderException.create(String.format("null key in entry: null=%s", value));
            }
            map.put(key, value);
        }
        return SoyMapImpl.forProviderMap(map);
    }

    @Override
    protected SoyValue visitVarRefNode(VarRefNode node) {
        if (node.getDefnDecl().kind() == VarDefn.Kind.STATE) {
            throw new AssertionError();
        }
        if (node.getDefnDecl().kind() == VarDefn.Kind.CONST) {
            ConstNode def = this.env.lookupConst((ConstVar)node.getDefnDecl());
            return (SoyValue)this.visit(def.getExpr());
        }
        SoyValue value = this.env.getVar(node.getDefnDecl());
        if (node.getDefnDecl().kind() == VarDefn.Kind.PARAM && ((TemplateParam)node.getDefnDecl()).hasDefault() && UndefinedData.INSTANCE == value) {
            value = (SoyValue)this.visit(((TemplateParam)node.getDefnDecl()).defaultValue());
        }
        return value;
    }

    @Override
    protected SoyValue visitDataAccessNode(DataAccessNode node) {
        Preconditions.checkArgument((!node.isNullSafe() ? 1 : 0) != 0);
        SoyValue base = (SoyValue)this.visit(node.getBaseExprChild());
        return this.visitDataAccessNode(node, base, false, false);
    }

    private SoyValue visitDataAccessNode(DataAccessNode node, SoyValue base, boolean nullSafe, boolean hasAssertNonNull) {
        SoyValue result;
        switch (node.getKind()) {
            case FIELD_ACCESS_NODE: {
                result = this.visitFieldAccessNode((FieldAccessNode)node, base, nullSafe);
                break;
            }
            case ITEM_ACCESS_NODE: {
                result = this.visitItemAccessNode((ItemAccessNode)node, base, nullSafe);
                break;
            }
            case METHOD_CALL_NODE: {
                result = this.visitMethodCallNode((MethodCallNode)node, base);
                break;
            }
            default: {
                throw new AssertionError((Object)node.getKind());
            }
        }
        if (hasAssertNonNull) {
            result = EvalVisitor.assertNotNull(result, node);
        }
        return result;
    }

    @Override
    protected SoyValue visitNullSafeAccessNode(NullSafeAccessNode nullSafeAccessNode) {
        SoyValue value = (SoyValue)this.visit(nullSafeAccessNode.getBase());
        ExprNode dataAccess = nullSafeAccessNode.getDataAccess();
        while (!EvalVisitor.isNullOrUndefinedBase(value) && dataAccess.getKind() == ExprNode.Kind.NULL_SAFE_ACCESS_NODE) {
            NullSafeAccessNode node = (NullSafeAccessNode)dataAccess;
            value = this.accumulateDataAccess((DataAccessNode)node.getBase(), value, false);
            dataAccess = node.getDataAccess();
        }
        if (EvalVisitor.isNullOrUndefinedBase(value)) {
            return NullData.INSTANCE;
        }
        return this.accumulateDataAccessTail((ExprNode.AccessChainComponentNode)dataAccess, value);
    }

    private SoyValue accumulateDataAccess(DataAccessNode dataAccessNode, SoyValue base, boolean hasAssertNonNull) {
        boolean accessChain = false;
        if (dataAccessNode.getBaseExprChild() instanceof DataAccessNode) {
            base = this.accumulateDataAccess((DataAccessNode)dataAccessNode.getBaseExprChild(), base, false);
            accessChain = true;
        }
        return this.visitDataAccessNode(dataAccessNode, base, !accessChain, hasAssertNonNull);
    }

    private SoyValue accumulateDataAccessTail(ExprNode.AccessChainComponentNode dataAccessNode, SoyValue base) {
        boolean hasAssertNonNull = false;
        if (dataAccessNode.getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE) {
            OperatorNodes.AssertNonNullOpNode assertNonNull = (OperatorNodes.AssertNonNullOpNode)dataAccessNode;
            dataAccessNode = (ExprNode.AccessChainComponentNode)assertNonNull.getChild(0);
            hasAssertNonNull = true;
        }
        return this.accumulateDataAccess((DataAccessNode)dataAccessNode, base, hasAssertNonNull);
    }

    private SoyValue visitFieldAccessNode(FieldAccessNode fieldAccess, SoyValue base, boolean nullSafe) {
        Preconditions.checkArgument((!fieldAccess.isNullSafe() ? 1 : 0) != 0);
        if (!(base instanceof SoyRecord) && !(base instanceof SoyProtoValue)) {
            if (nullSafe && !EvalVisitor.isNullOrUndefinedBase(base)) {
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-record just before accessing \"%s\".", fieldAccess.toSourceString(), fieldAccess.getSourceStringSuffix()));
            }
            if (this.undefinedDataHandlingMode == UndefinedDataHandlingMode.BUGGED) {
                return UndefinedData.INSTANCE;
            }
            if (EvalVisitor.isNullOrUndefinedBase(base)) {
                throw RenderException.create(String.format("Attempted to access field \"%s\" of null.", fieldAccess.getFieldName()));
            }
            throw RenderException.create(String.format("Attempted to access field \"%s\" of non-record type: %s.", fieldAccess.getFieldName(), base.getClass().getName()));
        }
        if (EvalVisitor.isProtoOrUnionOfProtos(fieldAccess.getBaseExprChild().getType())) {
            return ((SoyProtoValue)base).getProtoField(fieldAccess.getFieldName());
        }
        EvalVisitor.maybeMarkBadProtoAccess(fieldAccess, base);
        SoyValue value = ((SoyRecord)base).getField(fieldAccess.getFieldName());
        if (value != null && !TofuTypeChecks.isInstance(fieldAccess.getType(), value, fieldAccess.getSourceLocation())) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", fieldAccess.getType(), value.getClass().getSimpleName()));
        }
        return value != null ? value : (this.undefinedDataHandlingMode == UndefinedDataHandlingMode.BUGGED ? UndefinedData.INSTANCE : NullData.INSTANCE);
    }

    private static boolean isProtoOrUnionOfProtos(SoyType type) {
        if (type.getKind() == SoyType.Kind.PROTO) {
            return true;
        }
        if (type.getKind() == SoyType.Kind.UNION) {
            for (SoyType memberType : ((UnionType)type).getMembers()) {
                if (memberType.getKind() == SoyType.Kind.PROTO || memberType.getKind() == SoyType.Kind.NULL) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private SoyValue visitItemAccessNode(ItemAccessNode itemAccess, SoyValue base, boolean nullSafe) {
        SoyValue value;
        Preconditions.checkArgument((!itemAccess.isNullSafe() ? 1 : 0) != 0);
        if (!(base instanceof SoyLegacyObjectMap) && !(base instanceof SoyMap)) {
            if (nullSafe && !EvalVisitor.isNullOrUndefinedBase(base)) {
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-map/list just before accessing \"%s\".", itemAccess.toSourceString(), itemAccess.getSourceStringSuffix()));
            }
            if (this.undefinedDataHandlingMode == UndefinedDataHandlingMode.BUGGED) {
                return UndefinedData.INSTANCE;
            }
            if (EvalVisitor.isNullOrUndefinedBase(base)) {
                throw RenderException.create(String.format("Attempted to access item \"%s\" of null.", itemAccess.getSourceStringSuffix()));
            }
            throw RenderException.create(String.format("While evaluating \"%s\", encountered non-map/list just before accessing \"%s\".", itemAccess.toSourceString(), itemAccess.getSourceStringSuffix()));
        }
        EvalVisitor.maybeMarkBadProtoAccess(itemAccess, base);
        SoyValue key = (SoyValue)this.visit(itemAccess.getKeyExprChild());
        SoyType baseType = SoyTypes.removeNull(itemAccess.getBaseExprChild().getType());
        boolean shouldUseNewMap = MapType.ANY_MAP.isAssignableFromStrict(baseType);
        SoyValue soyValue = value = shouldUseNewMap ? ((SoyMap)base).get(key) : ((SoyLegacyObjectMap)base).getItem(key);
        if (value != null && !TofuTypeChecks.isInstance(itemAccess.getType(), value, itemAccess.getSourceLocation())) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", itemAccess.getType(), value.getClass().getSimpleName()));
        }
        if (value != null) {
            return value;
        }
        if (shouldUseNewMap || this.undefinedDataHandlingMode != UndefinedDataHandlingMode.BUGGED) {
            return NullData.INSTANCE;
        }
        return UndefinedData.INSTANCE;
    }

    private static void maybeMarkBadProtoAccess(ExprNode expr, SoyValue value) {
        if (value instanceof SoyProtoValue) {
            ((SoyProtoValue)value).setAccessLocationKey(expr.getSourceLocation());
        }
    }

    private SoyValue visitMethodCallNode(MethodCallNode methodNode, SoyValue base) {
        Preconditions.checkArgument((!methodNode.isNullSafe() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)methodNode.isMethodResolved());
        base = EvalVisitor.assertNotNull(base, methodNode.getBaseExprChild());
        SoyMethod method = methodNode.getSoyMethod();
        if (method instanceof BuiltinMethod) {
            BuiltinMethod builtinMethod = (BuiltinMethod)method;
            switch (builtinMethod) {
                case GET_EXTENSION: {
                    return ((SoyProtoValue)base).getProtoField(BuiltinMethod.getProtoExtensionIdFromMethodCall(methodNode), true);
                }
                case HAS_PROTO_FIELD: {
                    return BooleanData.forValue(((SoyProtoValue)base).hasProtoField(BuiltinMethod.getProtoFieldNameFromMethodCall(methodNode)));
                }
                case BIND: {
                    TofuTemplateValue template = (TofuTemplateValue)base;
                    SoyRecord params = (SoyRecord)this.visit(methodNode.getParams().get(0));
                    return TofuTemplateValue.createWithBoundParameters(template.getTemplateName(), template.getBoundParameters().isPresent() ? SoyRecords.merge(template.getBoundParameters().get(), params) : params);
                }
            }
        } else if (method instanceof SoySourceFunctionMethod) {
            SoySourceFunctionMethod sourceMethod = (SoySourceFunctionMethod)method;
            ArrayList<SoyValue> args = new ArrayList<SoyValue>(methodNode.numParams() + 1);
            args.add(base);
            methodNode.getParams().forEach(n -> args.add((SoyValue)this.visit((ExprNode)n)));
            return this.computeFunctionHelper(args, JavaPluginExecContext.forMethodCallNode(methodNode, sourceMethod));
        }
        throw new AssertionError(method.getClass());
    }

    private static boolean isNullOrUndefinedBase(SoyValue base) {
        return base == null || base instanceof NullData || base instanceof UndefinedData;
    }

    @Override
    protected SoyValue visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        return SharedRuntime.negative((SoyValue)this.visit(node.getChild(0)));
    }

    @Override
    protected SoyValue visitNotOpNode(OperatorNodes.NotOpNode node) {
        SoyValue operand = (SoyValue)this.visit(node.getChild(0));
        return this.convertResult(!operand.coerceToBoolean());
    }

    @Override
    protected SoyValue visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        return SharedRuntime.times((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        return FloatData.forValue(SharedRuntime.dividedBy((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitModOpNode(OperatorNodes.ModOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return SharedRuntime.mod(operand0, operand1);
    }

    @Override
    protected SoyValue visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        return SharedRuntime.plus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        return SharedRuntime.minus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.convertResult(SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return this.convertResult(!SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitAndOpNode(OperatorNodes.AndOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (!operand0.coerceToBoolean()) {
            return this.convertResult(false);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitOrOpNode(OperatorNodes.OrOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return this.convertResult(true);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return (SoyValue)this.visit(node.getChild(2));
    }

    @Override
    protected SoyValue visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0 instanceof NullData || operand0 instanceof UndefinedData) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return operand0;
    }

    @Override
    protected SoyValue visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
        return this.assertNotNull(node.getChild(0));
    }

    @Override
    protected SoyValue visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            BuiltinFunction nonpluginFn = (BuiltinFunction)soyFunction;
            switch (nonpluginFn) {
                case IS_PARAM_SET: {
                    return this.visitIsSetFunction(node);
                }
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case CHECK_NOT_NULL: {
                    return this.assertNotNull(node.getChild(0));
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case SOY_SERVER_KEY: {
                    return this.visitSoyServerKeyFunction(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUseFunction(node);
                }
                case PROTO_INIT: {
                    return this.visitProtoInitFunction(node);
                }
                case UNKNOWN_JS_GLOBAL: 
                case LEGACY_DYNAMIC_TAG: {
                    throw new UnsupportedOperationException("the " + nonpluginFn.getName() + " function can't be used in templates compiled to Java");
                }
                case TO_FLOAT: {
                    return this.visitToFloatFunction(node);
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return BooleanData.forValue(this.debugSoyTemplateInfo);
                }
                case VE_DATA: {
                    return UNDEFINED_VE_DATA;
                }
                case MSG_WITH_ID: 
                case REMAINDER: 
                case TEMPLATE: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof SoyJavaFunction) {
            List<SoyValue> args = this.visitChildren(node);
            SoyJavaFunction fn = (SoyJavaFunction)soyFunction;
            return this.computeFunctionHelper(fn, args, node);
        }
        if (soyFunction instanceof SoyJavaSourceFunction) {
            List<SoyValue> args = this.visitChildren(node);
            SoyJavaSourceFunction fn = (SoyJavaSourceFunction)soyFunction;
            return this.computeFunctionHelper(args, JavaPluginExecContext.forFunctionNode(node, fn));
        }
        if (soyFunction instanceof LoggingFunction) {
            return StringData.forValue(((LoggingFunction)soyFunction).getPlaceholder());
        }
        throw RenderException.create("Failed to find Soy function with name '" + node.getStaticFunctionName() + "' (function call \"" + node.toSourceString() + "\").");
    }

    protected SoyValue visitProtoInitFunction(FunctionNode node) {
        SoyProtoType soyProto = (SoyProtoType)node.getType();
        ImmutableList<Identifier> paramNames = node.getParamNames();
        SoyProtoValue.Builder builder = new SoyProtoValue.Builder(soyProto.getDescriptor());
        for (int i = 0; i < node.numChildren(); ++i) {
            SoyValue visit = (SoyValue)this.visit(node.getChild(i));
            if (visit instanceof NullData || visit instanceof UndefinedData) continue;
            builder.setField(((Identifier)paramNames.get(i)).identifier(), visit);
        }
        return builder.build();
    }

    private SoyValue assertNotNull(ExprNode child) {
        return EvalVisitor.assertNotNull((SoyValue)this.visit(child), child);
    }

    private static SoyValue assertNotNull(SoyValue value, ExprNode node) {
        if (value instanceof NullData || value instanceof UndefinedData) {
            throw new SoyDataException(node.toSourceString() + " is null");
        }
        return value;
    }

    @ForOverride
    protected SoyValue computeFunctionHelper(SoyJavaFunction fn, List<SoyValue> args, FunctionNode fnNode) {
        try {
            return fn.computeForJava(args);
        }
        catch (Exception e) {
            throw RenderException.create("While computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage(), e);
        }
    }

    @ForOverride
    protected SoyValue computeFunctionHelper(List<SoyValue> args, JavaPluginExecContext fnNode) {
        try {
            return new TofuValueFactory(fnNode, this.pluginInstances).computeForJava(fnNode.getSourceFunction(), args, this.context);
        }
        catch (Exception e) {
            throw RenderException.create("While computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage(), e);
        }
    }

    private SoyValue visitIsSetFunction(FunctionNode node) {
        return BooleanData.forValue(this.env.hasVar(((VarRefNode)node.getChild(0)).getDefnDecl()));
    }

    private SoyValue visitIsFirstFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex(dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex == 0);
    }

    private SoyValue visitIsLastFunction(FunctionNode node) {
        boolean isLast;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            isLast = this.env.isLast(dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(isLast);
    }

    private SoyValue visitIndexFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex(dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex);
    }

    private SoyValue visitCssFunction(FunctionNode node) {
        List children = this.visitChildren(node);
        String selector = ((SoyValue)Iterables.getLast(children)).stringValue();
        String renamedSelector = this.cssRenamingMap.get(selector);
        if (renamedSelector == null) {
            renamedSelector = selector;
        }
        if (node.numChildren() == 1) {
            return StringData.forValue(renamedSelector);
        }
        String fullSelector = ((SoyValue)children.get(0)).stringValue() + "-" + renamedSelector;
        return StringData.forValue(fullSelector);
    }

    private SoyValue visitXidFunction(FunctionNode node) {
        String xid = ((SoyValue)this.visit(node.getChild(0))).stringValue();
        String renamed = this.xidRenamingMap.get(xid);
        return renamed != null ? StringData.forValue(renamed) : StringData.forValue(xid + "_");
    }

    private SoyValue visitSoyServerKeyFunction(FunctionNode node) {
        SoyValue value = (SoyValue)this.visit(node.getChild(0));
        return StringData.forValue(SharedRuntime.soyServerKey(value instanceof NullData || value instanceof UndefinedData ? null : value));
    }

    private SoyValue visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        if (this.msgBundle == null) {
            return BooleanData.TRUE;
        }
        long primaryMsgId = ((IntegerNode)node.getChild(1)).getValue();
        if (!this.msgBundle.getMsgParts(primaryMsgId).isEmpty()) {
            return BooleanData.TRUE;
        }
        long fallbackMsgId = ((IntegerNode)node.getChild(2)).getValue();
        return BooleanData.forValue(this.msgBundle.getMsgParts(fallbackMsgId).isEmpty());
    }

    private SoyValue visitToFloatFunction(FunctionNode node) {
        IntegerData v = (IntegerData)this.visit(node.getChild(0));
        return FloatData.forValue(v.longValue());
    }

    @Override
    protected SoyValue visitVeLiteralNode(VeLiteralNode node) {
        return UNDEFINED_VE;
    }

    @Override
    protected SoyValue visitTemplateLiteralNode(TemplateLiteralNode node) {
        return TofuTemplateValue.create(node.getResolvedName());
    }

    private SoyValue convertResult(boolean b) {
        return BooleanData.forValue(b);
    }

    private SoyValue convertResult(long i) {
        return IntegerData.forValue(i);
    }

    private SoyValue convertResult(double f) {
        return FloatData.forValue(f);
    }

    private SoyValue convertResult(String s) {
        return StringData.forValue(s);
    }

    public static interface EvalVisitorFactory {
        public EvalVisitor create(Environment var1, @Nullable SoyCssRenamingMap var2, @Nullable SoyIdRenamingMap var3, @Nullable SoyMsgBundle var4, boolean var5, ImmutableMap<String, Supplier<Object>> var6);
    }

    public static enum UndefinedDataHandlingMode {
        BUGGED,
        NORMAL;

    }
}

