/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.MoreObjects;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.Token;

final class Tokens {
    static SourceLocation createSrcLoc(SourceFilePath filePath, Token first, Token ... rest) {
        int beginLine = first.beginLine;
        int beginColumn = first.beginColumn;
        int endLine = first.endLine;
        int endColumn = first.endColumn;
        for (Token next : rest) {
            if (!Tokens.startsLaterThan(next, beginLine, beginColumn)) {
                throw new IllegalArgumentException(String.format("In file: %s, expected %s to start after (%d, %d)", filePath, Tokens.toString(next), beginLine, beginColumn));
            }
            if (!Tokens.endsLaterThan(next, endLine, endColumn)) {
                throw new IllegalArgumentException(String.format("In file: %s, expected %s to end after (%d, %d)", filePath, Tokens.toString(next), endLine, endColumn));
            }
            endLine = next.endLine;
            endColumn = next.endColumn;
        }
        if (beginLine == 0 && endLine == 0 && beginColumn == 0 && endColumn == 0) {
            return new SourceLocation(filePath);
        }
        return new SourceLocation(filePath, beginLine, beginColumn, endLine, endColumn);
    }

    private static boolean startsLaterThan(Token tok, int beginLine, int beginCol) {
        return tok.beginLine > beginLine || tok.beginLine == beginLine && tok.beginColumn > beginCol;
    }

    private static boolean endsLaterThan(Token tok, int endLine, int endCol) {
        return tok.endLine > endLine || tok.endLine == endLine && tok.endColumn > endCol;
    }

    static boolean areAdjacent(Token first, Token second) {
        return first.endLine == second.beginLine && first.endColumn == second.beginColumn - 1;
    }

    static String toString(Token token) {
        return MoreObjects.toStringHelper(Token.class).add("type", (Object)Tokens.getTokenDisplayName(token.kind)).add("image", (Object)token.image).add("beginLine", token.beginLine).add("beginColumn", token.beginColumn).add("endLine", token.endLine).add("endColumn", token.endColumn).toString();
    }

    static String getTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 10: {
                return "{alias";
            }
            case 12: {
                return "{delpackage";
            }
            case 31: {
                return "{deltemplate";
            }
            case 11: {
                return "{namespace";
            }
            case 14: {
                return "{[export ]const";
            }
            case 32: {
                return "{template";
            }
            case 33: {
                return "{element";
            }
            case 0: {
                return "eof";
            }
            case 55: {
                return "{call";
            }
            case 56: {
                return "{delcall";
            }
            case 59: {
                return "{param";
            }
            case 61: {
                return "{msg";
            }
            case 62: {
                return "{fallbackmsg";
            }
            case 64: {
                return "{if";
            }
            case 65: {
                return "{elseif";
            }
            case 68: {
                return "{let";
            }
            case 70: {
                return "{for";
            }
            case 72: {
                return "{plural";
            }
            case 74: {
                return "{select";
            }
            case 76: {
                return "{switch";
            }
            case 78: {
                return "{case";
            }
            case 84: {
                return "{print";
            }
            case 86: {
                return "{key";
            }
            case 87: {
                return "{velog";
            }
            case 92: 
            case 150: {
                return "identifier";
            }
            case 151: {
                return "attribute identifier";
            }
            case 25: 
            case 26: {
                return "attribute value";
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 102: {
                return "text";
            }
            case 101: {
                return "whitespace";
            }
            case 106: 
            case 107: 
            case 108: {
                return "number";
            }
            case 109: 
            case 110: {
                return "string";
            }
            case 141: {
                return "'for'";
            }
            case 142: {
                return "'in'";
            }
            case 162: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return SoyFileParserConstants.tokenImage[tokenId];
    }

    private Tokens() {
    }
}

