/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.ConstVar;

public final class ConstNode
extends AbstractCommandNode
implements SoyNode.ExprHolderNode {
    private final ConstVar var;
    private final ExprRootNode valueExpr;
    private final boolean exported;

    public ConstNode(int id, SourceLocation location, String varName, SourceLocation varNameLocation, ExprNode expr, boolean exported) {
        super(id, location, "const");
        this.var = new ConstVar(varName, varNameLocation, null);
        this.valueExpr = new ExprRootNode(expr);
        this.exported = exported;
    }

    private ConstNode(ConstNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new ConstVar(orig.var);
        this.valueExpr = orig.valueExpr.copy(copyState);
        this.exported = orig.exported;
        copyState.updateRefs(orig.var, this.var);
    }

    public ConstVar getVar() {
        return this.var;
    }

    public boolean isExported() {
        return this.exported;
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CONST_NODE;
    }

    public ExprRootNode getExpr() {
        return this.valueExpr;
    }

    @Override
    public String getCommandText() {
        return this.var.name() + ": " + this.valueExpr.toSourceString();
    }

    @Override
    public String getTagString() {
        return this.getTagString(true);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.valueExpr);
    }

    @Override
    public ConstNode copy(CopyState copyState) {
        return new ConstNode(this, copyState);
    }
}

