/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class FileSetTemplateRegistry
implements TemplateRegistry {
    private static final SoyErrorKind DUPLICATE_TEMPLATES = SoyErrorKind.of("Template/element ''{0}'' already defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME = SoyErrorKind.of("Found deltemplate {0} with the same name as a template/element at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DEFAULT_DELEGATE_TEMPLATES = SoyErrorKind.of("Delegate template ''{0}'' already has a default defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE = SoyErrorKind.of("Delegate template ''{0}'' already defined in delpackage {1}: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ImmutableMap<SourceFilePath, TemplatesPerFile> templatesPerFile;
    private final Map<String, TemplateMetadata> basicTemplatesOrElementsMap;
    private final DelTemplateSelector<TemplateMetadata> delTemplateSelector;
    private final ImmutableMap<String, TemplateMetadata> allTemplates;

    private FileSetTemplateRegistry(ImmutableMap<SourceFilePath, TemplatesPerFile> templatesPerFile, Map<String, TemplateMetadata> basicTemplatesOrElementsMap, DelTemplateSelector<TemplateMetadata> delTemplateSelector, ImmutableMap<String, TemplateMetadata> allTemplates) {
        this.templatesPerFile = templatesPerFile;
        this.basicTemplatesOrElementsMap = basicTemplatesOrElementsMap;
        this.delTemplateSelector = delTemplateSelector;
        this.allTemplates = allTemplates;
    }

    public static Builder builder(ErrorReporter errorReporter) {
        return new Builder(errorReporter);
    }

    @Override
    public ImmutableSet<String> getBasicTemplateOrElementNames() {
        return ImmutableSet.copyOf(this.basicTemplatesOrElementsMap.keySet());
    }

    @Override
    public ImmutableList<TemplateType> getTemplates(CallNode node) {
        if (node instanceof CallBasicNode) {
            SoyType calleeType = ((CallBasicNode)node).getCalleeExpr().getType();
            if (calleeType == null) {
                return ImmutableList.of();
            }
            if (calleeType.getKind() == SoyType.Kind.TEMPLATE) {
                return ImmutableList.of((Object)((TemplateType)calleeType));
            }
            if (calleeType.getKind() == SoyType.Kind.UNION) {
                ImmutableList.Builder signatures = ImmutableList.builder();
                for (SoyType member : ((UnionType)calleeType).getMembers()) {
                    Preconditions.checkState((member.getKind() == SoyType.Kind.TEMPLATE ? 1 : 0) != 0);
                    signatures.add((Object)((TemplateType)member));
                }
                return signatures.build();
            }
            if (calleeType.getKind() == SoyType.Kind.UNKNOWN) {
                return ImmutableList.of();
            }
            throw new IllegalStateException("Unexpected type in call: " + calleeType.getClass() + " - " + node.toSourceString());
        }
        String calleeName = ((CallDelegateNode)node).getDelCalleeName();
        return (ImmutableList)this.delTemplateSelector.delTemplateNameToValues().get((Object)calleeName).stream().map(TemplateMetadata::getTemplateType).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableMap<SourceFilePath, TemplatesPerFile> getTemplatesPerFile() {
        return this.templatesPerFile;
    }

    @Override
    public TemplatesPerFile getTemplatesPerFile(SourceFilePath fileName) {
        return (TemplatesPerFile)this.templatesPerFile.get((Object)fileName);
    }

    @Override
    @Nullable
    public TemplateMetadata getBasicTemplateOrElement(String templateName) {
        return this.basicTemplatesOrElementsMap.get(templateName);
    }

    public void updateTemplate(TemplateNode templateNode) {
        this.basicTemplatesOrElementsMap.put(templateNode.getTemplateName(), TemplateMetadata.fromTemplate(templateNode));
    }

    @Override
    public DelTemplateSelector<TemplateMetadata> getDelTemplateSelector() {
        return this.delTemplateSelector;
    }

    @Override
    public TemplateMetadata getMetadata(TemplateNode node) {
        return (TemplateMetadata)Preconditions.checkNotNull((Object)((TemplateMetadata)this.allTemplates.get(Preconditions.checkNotNull((Object)node.getTemplateName()))), (String)"Cannot find template metadata for file: %s. Known file names are: %s. Are you missing a dependency?", (Object)node, (Object)this.templatesPerFile.keySet());
    }

    @Override
    public ImmutableList<TemplateMetadata> getAllTemplates() {
        return ImmutableList.copyOf((Collection)this.allTemplates.values());
    }

    @Override
    public ImmutableSet<SourceFilePath> getAllFileNames() {
        return this.templatesPerFile.keySet();
    }

    @Override
    public Optional<SanitizedContentKind> getCallContentKind(CallNode node) {
        ImmutableList<TemplateType> templateNodes = this.getTemplates(node);
        if (!templateNodes.isEmpty()) {
            return Optional.of(((TemplateType)templateNodes.get(0)).getContentKind().getSanitizedContentKind());
        }
        return Optional.empty();
    }

    public static final class Builder {
        private final ErrorReporter errorReporter;
        private final Map<SourceFilePath, TemplatesPerFile.Builder> templatesPerFileBuilder = new LinkedHashMap<SourceFilePath, TemplatesPerFile.Builder>();
        DelTemplateSelector.Builder<TemplateMetadata> delTemplateSelectorBuilder = new DelTemplateSelector.Builder();
        Map<String, TemplateMetadata> basicTemplatesOrElementsMap = new LinkedHashMap<String, TemplateMetadata>();
        Multimap<String, TemplateMetadata> delegateTemplates = HashMultimap.create();
        Map<String, TemplateMetadata> allTemplatesBuilder = new LinkedHashMap<String, TemplateMetadata>();

        private Builder(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        public void addTemplatesForFile(SourceFilePath filePath, ImmutableList<TemplateMetadata> templates) {
            templates.forEach(t -> this.addTemplateForFile(filePath, (TemplateMetadata)t));
        }

        public void addTemplateForFile(SourceFilePath filePath, TemplateMetadata template) {
            this.addTemplateToPerFileRegistry(filePath, template);
            this.allTemplatesBuilder.put(template.getTemplateName(), template);
            switch (template.getTemplateType().getTemplateKind()) {
                case BASIC: 
                case ELEMENT: {
                    TemplateMetadata prev = this.basicTemplatesOrElementsMap.put(template.getTemplateName(), template);
                    if (prev == null || prev.getSourceLocation().getFileName().equals(template.getSourceLocation().getFileName())) break;
                    this.errorReporter.report(template.getSourceLocation(), DUPLICATE_TEMPLATES, template.getTemplateName(), prev.getSourceLocation());
                    break;
                }
                case DELTEMPLATE: {
                    String delTemplateName = template.getDelTemplateName();
                    String delPackageName = template.getDelPackageName();
                    String variant = template.getDelTemplateVariant();
                    if (delPackageName == null) {
                        TemplateMetadata previous = this.delTemplateSelectorBuilder.addDefault(delTemplateName, variant, template);
                        if (previous != null) {
                            this.errorReporter.report(template.getSourceLocation(), DUPLICATE_DEFAULT_DELEGATE_TEMPLATES, delTemplateName, previous.getSourceLocation());
                        }
                    } else {
                        TemplateMetadata previous = this.delTemplateSelectorBuilder.add(delTemplateName, delPackageName, variant, template);
                        if (previous != null) {
                            this.errorReporter.report(template.getSourceLocation(), DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE, delTemplateName, delPackageName, previous.getSourceLocation());
                        }
                    }
                    this.delegateTemplates.put((Object)delTemplateName, (Object)template);
                }
            }
        }

        public Map<SourceFilePath, TemplatesPerFile.Builder> getTemplatesPerFileBuilder() {
            return this.templatesPerFileBuilder;
        }

        private void addTemplateToPerFileRegistry(SourceFilePath filePath, TemplateMetadata template) {
            TemplatesPerFile.Builder fileRegistry = this.templatesPerFileBuilder.computeIfAbsent(filePath, TemplatesPerFile::builder);
            fileRegistry.addTemplate(template);
        }

        public FileSetTemplateRegistry build() {
            for (Map.Entry entry : this.delegateTemplates.entries()) {
                TemplateMetadata node = this.basicTemplatesOrElementsMap.get(entry.getKey());
                if (node == null) continue;
                this.errorReporter.report(((TemplateMetadata)entry.getValue()).getSourceLocation(), TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME, entry.getKey(), node.getSourceLocation());
            }
            return new FileSetTemplateRegistry((ImmutableMap)this.templatesPerFileBuilder.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((TemplatesPerFile.Builder)e.getValue()).build())), this.basicTemplatesOrElementsMap, this.delTemplateSelectorBuilder.build(), ImmutableMap.copyOf(this.allTemplatesBuilder));
        }
    }
}

