/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class HtmlAttributeNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode {
    private static final ImmutableMap<String, String> CONCATENATED_ATTRIBUTES = ImmutableMap.of((Object)"@class", (Object)" ", (Object)"@style", (Object)";", (Object)"@jsdata", (Object)";", (Object)"@jsaction", (Object)";", (Object)"@jsmodel", (Object)";");
    @Nullable
    private final SourceLocation.Point equalsSignLocation;

    public HtmlAttributeNode(int id, SourceLocation location, @Nullable SourceLocation.Point equalsSignLocation) {
        super(id, location);
        this.equalsSignLocation = equalsSignLocation;
    }

    @Nullable
    public String getConcatenationDelimiter() {
        if (this.getStaticKey() != null && CONCATENATED_ATTRIBUTES.containsKey((Object)this.getStaticKey())) {
            return (String)CONCATENATED_ATTRIBUTES.get((Object)this.getStaticKey());
        }
        return null;
    }

    public HtmlAttributeNode(int id, SourceLocation location, @Nullable SourceLocation.Point equalsSignLocation, boolean isSoyAttr) {
        super(id, location);
        this.equalsSignLocation = equalsSignLocation;
    }

    private HtmlAttributeNode(HtmlAttributeNode orig, CopyState copyState) {
        super(orig, copyState);
        this.equalsSignLocation = orig.equalsSignLocation;
    }

    public boolean hasValue() {
        return this.equalsSignLocation != null;
    }

    public boolean isSoyAttr() {
        return this.getStaticKey() != null && this.getStaticKey().startsWith("@");
    }

    @Nullable
    public String getStaticContent() {
        if (!this.hasValue()) {
            return null;
        }
        Node value = this.getChild(1);
        if (!(value instanceof HtmlAttributeValueNode)) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)value;
        if (attrValue.numChildren() == 0) {
            return "";
        }
        if (attrValue.numChildren() > 1) {
            return null;
        }
        SoyNode.StandaloneNode attrValueNode = (SoyNode.StandaloneNode)attrValue.getChild(0);
        if (!(attrValueNode instanceof RawTextNode)) {
            return null;
        }
        return ((RawTextNode)attrValueNode).getRawText();
    }

    @Nullable
    public String getStaticKey() {
        if (this.getChild(0) instanceof RawTextNode) {
            return ((RawTextNode)this.getChild(0)).getRawText();
        }
        return null;
    }

    public SourceLocation getEqualsLocation() {
        Preconditions.checkState((this.equalsSignLocation != null ? 1 : 0) != 0, (Object)"This attribute doesn't have a value");
        return this.equalsSignLocation.asLocation(this.getSourceLocation().getFilePath());
    }

    public boolean definitelyMatchesAttributeName(String attributeName) {
        return this.getChild(0) instanceof RawTextNode && Ascii.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)((RawTextNode)this.getChild(0)).getRawText());
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_ATTRIBUTE_NODE;
    }

    @Override
    public HtmlAttributeNode copy(CopyState copyState) {
        return new HtmlAttributeNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((SoyNode.StandaloneNode)this.getChild(0)).toSourceString());
        if (this.hasValue()) {
            sb.append('=');
            sb.append(((SoyNode.StandaloneNode)this.getChild(1)).toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }
}

