/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.soytree.DelegatingTemplateRegistry;
import com.google.template.soy.soytree.FileSetTemplateRegistry;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplatesPerFile;
import com.google.template.soy.types.DelegatingSoyTypeRegistry;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class ImportsContext {
    private SoyTypeRegistry typeRegistry = null;
    private ImportsTemplateRegistry templateRegistry = null;
    private final Set<String> allImportedSymbols = new LinkedHashSet<String>();

    public boolean addImportedSymbol(String symbol) {
        return this.allImportedSymbols.add(symbol);
    }

    public void setTypeRegistry(SoyTypeRegistry typeRegistry) {
        Preconditions.checkState((this.typeRegistry == null ? 1 : 0) != 0, (Object)"Type registry is already set; cannot be overwritten.");
        this.typeRegistry = typeRegistry;
    }

    public SoyTypeRegistry getTypeRegistry() {
        return (SoyTypeRegistry)Preconditions.checkNotNull((Object)this.typeRegistry, (Object)"Type registry has not been set yet.");
    }

    public void setTemplateRegistry(ImportsTemplateRegistry templateRegistry) {
        Preconditions.checkState((this.templateRegistry == null ? 1 : 0) != 0, (Object)"Template registry is already set; use overrideTemplateRegistry if you're sure you want to override.");
        this.templateRegistry = templateRegistry;
    }

    public void overrideTemplateRegistry(ImportsTemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    public boolean hasTemplateRegistry() {
        return this.templateRegistry != null;
    }

    public ImportsTemplateRegistry getTemplateRegistry() {
        return (ImportsTemplateRegistry)Preconditions.checkNotNull((Object)this.templateRegistry, (Object)"Template registry has not been set yet.");
    }

    public static final class ImportsTemplateRegistry
    extends DelegatingTemplateRegistry {
        private final ImmutableMap<String, TemplatesPerFile.TemplateName> symbolToTemplateMap;
        private final SoyFileNode file;

        public ImportsTemplateRegistry(SoyFileNode file, ImmutableMap<String, TemplatesPerFile.TemplateName> symbolToTemplateMap) {
            this.symbolToTemplateMap = symbolToTemplateMap;
            this.file = file;
        }

        @Override
        public FileSetTemplateRegistry getDelegate() {
            return this.fileSetRegistry();
        }

        public void updateTemplate(TemplateNode node) {
            this.fileSetRegistry().updateTemplate(node);
        }

        @Override
        public TemplateMetadata getBasicTemplateOrElement(String callTmplName) {
            if (this.symbolToTemplateMap.containsKey((Object)callTmplName)) {
                return this.fileSetRegistry().getBasicTemplateOrElement(((TemplatesPerFile.TemplateName)this.symbolToTemplateMap.get((Object)callTmplName)).fullyQualifiedName());
            }
            return this.fileSetRegistry().getBasicTemplateOrElement(callTmplName);
        }

        public ImmutableMap<String, TemplatesPerFile.TemplateName> getSymbolsToTemplateNamesMap() {
            return this.symbolToTemplateMap;
        }

        public ImmutableSet<String> getImportedSymbols() {
            return this.symbolToTemplateMap.keySet();
        }

        private FileSetTemplateRegistry fileSetRegistry() {
            return this.file.getParent().getFileSetTemplateRegistry();
        }
    }

    public static final class ImportsTypeRegistry
    extends DelegatingSoyTypeRegistry {
        private final ImmutableMap<String, String> msgAndEnumLocalToFqn;
        private final ImmutableMap<String, String> allLocalToFqn;

        public ImportsTypeRegistry(SoyTypeRegistry delegate, ImmutableMap<String, String> msgAndEnumLocalToFqn, ImmutableMap<String, String> allLocalToFqn) {
            super(delegate);
            this.msgAndEnumLocalToFqn = msgAndEnumLocalToFqn;
            this.allLocalToFqn = allLocalToFqn;
        }

        @Override
        @Nullable
        public SoyType getType(String typeName) {
            String fullType = SoyTypes.localToFqn(typeName, this.msgAndEnumLocalToFqn);
            return fullType != null ? this.getProtoRegistry().getProtoType(fullType) : super.getType(typeName);
        }

        @Override
        public Identifier resolve(Identifier id) {
            String resolved = SoyTypes.localToFqn(id.identifier(), this.allLocalToFqn);
            if (resolved != null) {
                return Identifier.create(resolved, id.originalName(), id.location());
            }
            return super.resolve(id);
        }

        @Override
        public Iterable<String> getAllSortedTypeNames() {
            return () -> Streams.concat((Stream[])new Stream[]{this.msgAndEnumLocalToFqn.keySet().stream(), Streams.stream(super.getAllSortedTypeNames())}).sorted().iterator();
        }
    }
}

