/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.CommandTagAttribute;
import java.util.List;
import javax.annotation.Nullable;

public final class NamespaceDeclaration {
    private final Identifier namespace;
    private final ImmutableList<String> requiredCssNamespaces;
    private final ImmutableList<String> requiredCssPaths;
    private final String cssBaseNamespace;
    private final String cssPrefix;
    private final SourceLocation srcLoc;
    final ImmutableList<CommandTagAttribute> attrs;

    public NamespaceDeclaration(Identifier namespace, List<CommandTagAttribute> attrs, ErrorReporter errorReporter, SourceLocation srcLoc) {
        ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
        ImmutableList<String> requiredCssPaths = ImmutableList.of();
        String cssBaseNamespace = null;
        String cssPrefix = null;
        block14: for (CommandTagAttribute attr : attrs) {
            switch (attr.getName().identifier()) {
                case "requirecss": {
                    requiredCssNamespaces = attr.valueAsRequireCss(errorReporter);
                    continue block14;
                }
                case "requirecsspath": {
                    requiredCssPaths = attr.valueAsRequireCssPath();
                    continue block14;
                }
                case "cssprefix": {
                    cssPrefix = attr.getValue();
                    if (cssBaseNamespace == null) continue block14;
                    errorReporter.report(attr.getSourceLocation(), CommandTagAttribute.CSS_PREFIX_AND_CSS_BASE, new Object[0]);
                    continue block14;
                }
                case "cssbase": {
                    cssBaseNamespace = attr.getValue();
                    if (cssPrefix == null) continue block14;
                    errorReporter.report(attr.getSourceLocation(), CommandTagAttribute.CSS_PREFIX_AND_CSS_BASE, new Object[0]);
                    continue block14;
                }
                case "stricthtml": {
                    errorReporter.report(attr.getName().location(), CommandTagAttribute.NAMESPACE_STRICTHTML_ATTRIBUTE, new Object[0]);
                    continue block14;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, attr.getName().identifier(), "namespace", ImmutableList.of((Object)"cssbase", (Object)"requirecss", (Object)"requirecsspath", (Object)"cssprefix"));
        }
        this.namespace = namespace;
        this.requiredCssNamespaces = requiredCssNamespaces;
        this.requiredCssPaths = requiredCssPaths;
        this.cssBaseNamespace = cssBaseNamespace;
        this.srcLoc = srcLoc;
        this.attrs = ImmutableList.copyOf(attrs);
        this.cssPrefix = cssPrefix;
    }

    public NamespaceDeclaration copy(CopyState copyState) {
        return new NamespaceDeclaration(this.namespace, (List)this.attrs.stream().map(attr -> attr.copy(copyState)).collect(ImmutableList.toImmutableList()), ErrorReporter.exploding(), this.srcLoc);
    }

    public String getNamespace() {
        return this.namespace.identifier();
    }

    ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    ImmutableList<String> getRequiredCssPaths() {
        return this.requiredCssPaths;
    }

    @Nullable
    String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    @Nullable
    String getCssPrefix() {
        return this.cssPrefix;
    }

    public SourceLocation getSourceLocation() {
        return this.srcLoc;
    }

    public String toSourceString() {
        return "{namespace " + this.namespace.identifier() + (this.attrs.isEmpty() ? "" : " " + Joiner.on((char)' ').join(this.attrs)) + "}\n";
    }
}

