/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class SoyTreeUtils {
    static final ImmutableSet<SoyNode.Kind> NODES_THAT_DONT_CONTRIBUTE_OUTPUT = Sets.immutableEnumSet((Enum)SoyNode.Kind.LET_CONTENT_NODE, (Enum[])new SoyNode.Kind[]{SoyNode.Kind.LET_VALUE_NODE, SoyNode.Kind.DEBUGGER_NODE, SoyNode.Kind.LOG_NODE});
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");

    private SoyTreeUtils() {
    }

    @SafeVarargs
    public static boolean hasNodesOfType(Node node, Class<? extends Node> ... types) {
        return SoyTreeUtils.allNodes(node).anyMatch(n -> {
            for (Class type : types) {
                if (!type.isInstance(n)) continue;
                return true;
            }
            return false;
        });
    }

    public static SoyNode nextSibling(SoyNode node) {
        return (SoyNode)SoyTreeUtils.nextSiblingNode(node);
    }

    public static Node nextSiblingNode(Node node) {
        ParentNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        int index = parent.getChildIndex(node);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0);
        int nextIndex = index + 1;
        return parent.numChildren() > nextIndex ? (Node)parent.getChild(nextIndex) : null;
    }

    private static VisitDirective visitAll(Node n) {
        return VisitDirective.CONTINUE;
    }

    private static VisitDirective visitNonExpr(Node n) {
        return n instanceof ExprNode ? VisitDirective.SKIP_CHILDREN : VisitDirective.CONTINUE;
    }

    public static void visitAllNodes(Node node, NodeVisitor<? super Node, VisitDirective> visitor) {
        long unused = SoyTreeUtils.allNodes(node, visitor).count();
    }

    public static Stream<? extends Node> allNodes(Node node) {
        return SoyTreeUtils.allNodes(node, SoyTreeUtils::visitAll);
    }

    public static <T extends Node> Stream<T> allNodesOfType(Node rootSoyNode, Class<T> classObject) {
        boolean exploreExpressions = ExprNode.class.isAssignableFrom(classObject);
        return SoyTreeUtils.allNodes(rootSoyNode, exploreExpressions ? SoyTreeUtils::visitAll : SoyTreeUtils::visitNonExpr).filter(classObject::isInstance).map(classObject::cast);
    }

    public static Stream<? extends Node> allNodes(Node root, final NodeVisitor<? super Node, VisitDirective> visitor) {
        final ArrayDeque<Node> generations = new ArrayDeque<Node>();
        generations.add(root);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<Node>(Long.MAX_VALUE, 17){

            @Override
            public boolean tryAdvance(Consumer<? super Node> action) {
                Node next = (Node)generations.poll();
                if (next == null) {
                    return false;
                }
                switch ((VisitDirective)((Object)visitor.exec(next))) {
                    case SKIP_CHILDREN: {
                        break;
                    }
                    case CONTINUE: {
                        if (next instanceof ParentNode) {
                            generations.addAll(((ParentNode)next).getChildren());
                        }
                        if (!(next instanceof SoyNode.ExprHolderNode)) break;
                        generations.addAll(((SoyNode.ExprHolderNode)next).getExprList());
                    }
                }
                action.accept(next);
                return true;
            }
        }, false);
    }

    public static <T extends Node> ImmutableList<T> getAllNodesOfType(Node rootSoyNode, Class<T> classObject) {
        return (ImmutableList)SoyTreeUtils.allNodesOfType(rootSoyNode, classObject).collect(ImmutableList.toImmutableList());
    }

    public static Stream<FunctionNode> allFunctionInvocations(Node rootSoyNode, SoyFunction functionToMatch) {
        return SoyTreeUtils.allNodesOfType(rootSoyNode, FunctionNode.class).filter(function -> function.isResolved() && functionToMatch.equals(function.getSoyFunction()));
    }

    public static StringBuilder buildAstString(SoyNode.ParentSoyNode<?> node, int indent, StringBuilder sb) {
        for (SoyNode child : node.getChildren()) {
            sb.append(Strings.repeat((String)"  ", (int)indent)).append((Object)child.getKind()).append('\n');
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            SoyTreeUtils.buildAstString((SoyNode.ParentSoyNode)child, indent + 1, sb);
        }
        return sb;
    }

    public static FunctionNode buildNotNull(ExprNode node, SoySourceFunction isNonNullFn) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        FunctionNode isNonnull = FunctionNode.newPositional(Identifier.create("isNonnull", unknown), isNonNullFn, unknown);
        ExprRootNode exprNode = new ExprRootNode(node.copy(new CopyState()));
        exprNode.setType(node.getType());
        isNonnull.addChild(exprNode);
        isNonnull.setType(BoolType.getInstance());
        isNonnull.setAllowedParamTypes((List<SoyType>)ImmutableList.of((Object)UnknownType.getInstance()));
        return isNonnull;
    }

    public static IfNode buildPrintIfNotNull(ExprNode node, Supplier<Integer> id, SoySourceFunction isNonnull) {
        SourceLocation unknown = node.getSourceLocation().clearRange();
        IfNode ifNode = new IfNode(id.get(), unknown);
        IfCondNode ifCondNode = new IfCondNode(id.get(), unknown, unknown, "if", SoyTreeUtils.buildNotNull(node, isNonnull));
        ifCondNode.getExpr().setType(BoolType.getInstance());
        ifNode.addChild(ifCondNode);
        PrintNode printNode = new PrintNode(id.get(), unknown, true, node, (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        printNode.getExpr().setType(node.getType());
        ifCondNode.addChild(printNode);
        return ifNode;
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, AbstractNodeVisitor<ExprNode, R> exprNodeVisitor) {
        SoyTreeUtils.allNodes(node, SoyTreeUtils::visitNonExpr).filter(n -> n instanceof SoyNode.ExprHolderNode).map(SoyNode.ExprHolderNode.class::cast).flatMap(n -> n.getExprList().stream()).forEach(exprNodeVisitor::exec);
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode, IdGenerator nodeIdGen) {
        SoyNode clone = origNode.copy(new CopyState());
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return (T)clone;
    }

    public static <T extends SoyNode> List<T> cloneListWithNewIds(List<T> origNodes, IdGenerator nodeIdGen) {
        Preconditions.checkNotNull(origNodes);
        ArrayList<SoyNode> clones = new ArrayList<SoyNode>(origNodes.size());
        for (SoyNode origNode : origNodes) {
            SoyNode clone = origNode.copy(new CopyState());
            new GenNewIdsVisitor(nodeIdGen).exec(clone);
            clones.add(clone);
        }
        return clones;
    }

    public static boolean isDescendantOf(Node node, Node ancestor) {
        if (node instanceof ExprNode) {
            ExprNode nodeAsExpr = (ExprNode)node;
            if (ancestor instanceof ExprNode) {
                return SoyTreeUtils.isDescendantOf(nodeAsExpr, (ExprNode)ancestor);
            }
            return SoyTreeUtils.isDescendantOf(nodeAsExpr, (SoyNode)ancestor);
        }
        if (ancestor instanceof ExprNode) {
            return false;
        }
        return SoyTreeUtils.isDescendantOf((SoyNode)node, (SoyNode)ancestor);
    }

    public static boolean isDescendantOf(SoyNode node, SoyNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, ExprNode ancestor) {
        return SoyTreeUtils.doIsDescendantOf(node, ancestor);
    }

    public static boolean isDescendantOf(ExprNode node, SoyNode ancestor) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        ExprNode nodeRoot = node;
        return SoyTreeUtils.allNodesOfType(ancestor, SoyNode.ExprHolderNode.class).flatMap(holder -> holder.getExprList().stream()).anyMatch(root -> root == nodeRoot);
    }

    private static boolean doIsDescendantOf(Node node, Node ancestor) {
        while (node != null) {
            if (ancestor == node) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static String toSourceString(List<? extends Node> nodes) {
        ArrayList<String> strings = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            strings.add(node.toSourceString());
        }
        return COMMA_JOINER.join(strings);
    }

    private static boolean isNonConstant(ExprNode expr) {
        switch (expr.getKind()) {
            case VAR_REF_NODE: {
                return true;
            }
            case FUNCTION_NODE: {
                return !((FunctionNode)expr).isPure();
            }
        }
        return false;
    }

    public static boolean isConstantExpr(ExprNode rootSoyNode) {
        return SoyTreeUtils.allNodes(rootSoyNode).map(ExprNode.class::cast).noneMatch(SoyTreeUtils::isNonConstant);
    }

    public static ImmutableList<ExprNode> getNonConstantChildren(ExprNode rootSoyNode) {
        return (ImmutableList)SoyTreeUtils.allNodes(rootSoyNode).map(ExprNode.class::cast).filter(SoyTreeUtils::isNonConstant).collect(ImmutableList.toImmutableList());
    }

    public static HtmlTagNode getNodeAsHtmlTagNode(SoyNode node, boolean openTag) {
        MsgHtmlTagNode msgHtmlTagNode;
        MsgPlaceholderNode placeholderNode;
        SoyNode.Kind tagKind;
        if (node == null) {
            return null;
        }
        SoyNode.Kind kind = tagKind = openTag ? SoyNode.Kind.HTML_OPEN_TAG_NODE : SoyNode.Kind.HTML_CLOSE_TAG_NODE;
        if (NODES_THAT_DONT_CONTRIBUTE_OUTPUT.contains((Object)node.getKind())) {
            return SoyTreeUtils.getNodeAsHtmlTagNode(SoyTreeUtils.nextSibling(node), openTag);
        }
        if (node.getKind() == tagKind) {
            return (HtmlTagNode)node;
        }
        if (node.getKind() == SoyNode.Kind.MSG_PLACEHOLDER_NODE && (placeholderNode = (MsgPlaceholderNode)node).numChildren() == 1 && ((SoyNode.StandaloneNode)placeholderNode.getChild(0)).getKind() == SoyNode.Kind.MSG_HTML_TAG_NODE && (msgHtmlTagNode = (MsgHtmlTagNode)placeholderNode.getChild(0)).numChildren() == 1 && ((SoyNode.StandaloneNode)msgHtmlTagNode.getChild(0)).getKind() == tagKind) {
            return (HtmlTagNode)msgHtmlTagNode.getChild(0);
        }
        return null;
    }

    private static class GenNewIdsExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final IdGenerator nodeIdGen;

        public GenNewIdsExprVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
            node.setNodeId(this.nodeIdGen.genId());
            this.visitChildren(node);
        }
    }

    private static class GenNewIdsVisitor
    extends AbstractNodeVisitor<SoyNode, Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visit(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ExprHolderNode) {
                SoyNode.ExprHolderNode exprHolderNode = (SoyNode.ExprHolderNode)node;
                for (ExprRootNode expr : exprHolderNode.getExprList()) {
                    new GenNewIdsExprVisitor(this.nodeIdGen).exec(expr);
                }
            }
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    public static enum VisitDirective {
        SKIP_CHILDREN,
        CONTINUE;

    }
}

