/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.soytree.AutoValue_TemplateMetadata;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.SoyElementMetadataP;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnknownType;
import javax.annotation.Nullable;

@AutoValue
public abstract class TemplateMetadata {
    public static TemplateMetadata fromTemplate(TemplateNode template) {
        Builder builder = TemplateMetadata.builder().setTemplateName(template.getTemplateName()).setSourceLocation(template.getSourceLocation()).setSoyFileKind(SoyFileKind.SRC).setSoyElement(SoyElementMetadataP.newBuilder().setIsSoyElement(template instanceof TemplateElementNode).build()).setTemplateType(TemplateType.builder().setTemplateKind(TemplateMetadata.convertKind(template.getKind())).setAllowExtraAttributes(template.getAllowExtraAttributes()).setReservedAttributes(template.getReservedAttributes()).setContentKind(template.getTemplateContentKind()).setStrictHtml(template.isStrictHtml()).setParameters(TemplateMetadata.directParametersFromTemplate(template)).setDataAllCallSituations(TemplateMetadata.dataAllCallSituationFromTemplate(template)).setIdentifierForDebugging(template.getTemplateName()).setInferredType(true).build()).setComponent(template.getComponent()).setDelPackageName(template.getDelPackageName()).setVisibility(template.getVisibility());
        if (template.getHtmlElementMetadata() != null) {
            builder.setHtmlElement(template.getHtmlElementMetadata());
        }
        if (template.getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE) {
            TemplateDelegateNode deltemplate = (TemplateDelegateNode)template;
            builder.setDelTemplateName(deltemplate.getDelTemplateName());
            builder.setDelTemplateVariant(deltemplate.getDelTemplateVariant());
        }
        return builder.build();
    }

    public static Builder builder() {
        return new AutoValue_TemplateMetadata.Builder();
    }

    private static ImmutableList<TemplateType.Parameter> directParametersFromTemplate(TemplateNode node) {
        ImmutableList.Builder params = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            params.add((Object)TemplateMetadata.parameterFromTemplateParam(param));
        }
        return params.build();
    }

    public static TemplateType.Parameter parameterFromTemplateParam(TemplateParam param) {
        return TemplateType.Parameter.builder().setName(param.name()).setKind(param instanceof AttrParam ? TemplateType.ParameterKind.ATTRIBUTE : TemplateType.ParameterKind.PARAM).setType(param.hasType() ? param.type() : UnknownType.getInstance()).setRequired(param.isRequired()).setImplicit(param.isImplicit()).setDescription(param.desc()).build();
    }

    private static ImmutableList<TemplateType.DataAllCallSituation> dataAllCallSituationFromTemplate(TemplateNode node) {
        return ((ImmutableSet)SoyTreeUtils.allNodesOfType(node, CallNode.class).filter(CallNode::isPassingAllData).map(call -> {
            TemplateType.DataAllCallSituation.Builder builder = TemplateType.DataAllCallSituation.builder();
            ImmutableSet.Builder explicitlyPassedParams = ImmutableSet.builder();
            for (CallParamNode param : call.getChildren()) {
                explicitlyPassedParams.add((Object)param.getKey().identifier());
            }
            builder.setExplicitlyPassedParameters((ImmutableSet<String>)explicitlyPassedParams.build());
            switch (call.getKind()) {
                case CALL_BASIC_NODE: {
                    builder.setDelCall(false);
                    if (((CallBasicNode)call).isStaticCall()) {
                        builder.setTemplateName(((CallBasicNode)call).getCalleeName());
                        break;
                    }
                    builder.setTemplateName("$error");
                    break;
                }
                case CALL_DELEGATE_NODE: {
                    builder.setDelCall(true).setTemplateName(((CallDelegateNode)call).getDelCalleeName());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected call kind: " + (Object)((Object)call.getKind())));
                }
            }
            return builder.build();
        }).collect(ImmutableSet.toImmutableSet())).asList();
    }

    public abstract SoyFileKind getSoyFileKind();

    public abstract SourceLocation getSourceLocation();

    @Nullable
    public abstract HtmlElementMetadataP getHtmlElement();

    @Nullable
    public abstract SoyElementMetadataP getSoyElement();

    public abstract String getTemplateName();

    @Nullable
    public abstract String getDelTemplateName();

    @Nullable
    public abstract String getDelTemplateVariant();

    public abstract TemplateType getTemplateType();

    public abstract Visibility getVisibility();

    @Nullable
    public abstract String getDelPackageName();

    public abstract boolean getComponent();

    public abstract Builder toBuilder();

    private static TemplateType.TemplateKind convertKind(SoyNode.Kind kind) {
        switch (kind) {
            case TEMPLATE_BASIC_NODE: {
                return TemplateType.TemplateKind.BASIC;
            }
            case TEMPLATE_DELEGATE_NODE: {
                return TemplateType.TemplateKind.DELTEMPLATE;
            }
            case TEMPLATE_ELEMENT_NODE: {
                return TemplateType.TemplateKind.ELEMENT;
            }
        }
        throw new AssertionError((Object)("unexpected template kind: " + (Object)((Object)kind)));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSoyFileKind(SoyFileKind var1);

        public abstract Builder setSourceLocation(SourceLocation var1);

        public abstract Builder setHtmlElement(HtmlElementMetadataP var1);

        public abstract Builder setSoyElement(SoyElementMetadataP var1);

        public abstract Builder setTemplateName(String var1);

        public abstract Builder setDelTemplateName(String var1);

        public abstract Builder setDelTemplateVariant(String var1);

        public abstract Builder setTemplateType(TemplateType var1);

        public abstract Builder setDelPackageName(@Nullable String var1);

        public abstract Builder setVisibility(Visibility var1);

        public abstract Builder setComponent(boolean var1);

        public final TemplateMetadata build() {
            TemplateMetadata built = this.autobuild();
            if (built.getTemplateType().getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE) {
                Preconditions.checkState((built.getDelTemplateName() != null ? 1 : 0) != 0, (Object)"Deltemplates must have a deltemplateName");
                Preconditions.checkState((built.getDelTemplateVariant() != null ? 1 : 0) != 0, (Object)"Deltemplates must have a deltemplateName");
            } else {
                Preconditions.checkState((built.getDelTemplateVariant() == null ? 1 : 0) != 0, (Object)"non-Deltemplates must not have a variant");
                Preconditions.checkState((built.getDelTemplateName() == null ? 1 : 0) != 0, (Object)"non-Deltemplates must not have a deltemplateName");
            }
            return built;
        }

        abstract TemplateMetadata autobuild();
    }
}

