/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.soytree.AutoValue_TemplateNameRegistry;
import com.google.template.soy.soytree.TemplatesPerFile;

@AutoValue
public abstract class TemplateNameRegistry {
    public static TemplateNameRegistry create(ImmutableMap<SourceFilePath, TemplatesPerFile> filePathsToTemplates) {
        return new AutoValue_TemplateNameRegistry(filePathsToTemplates);
    }

    abstract ImmutableMap<SourceFilePath, TemplatesPerFile> filePathsToTemplates();

    public boolean hasFile(SourceFilePath filePath) {
        return this.filePathsToTemplates().containsKey((Object)filePath);
    }

    public TemplatesPerFile getTemplatesForFile(SourceFilePath filePath) {
        Preconditions.checkState((boolean)this.hasFile(filePath), (String)"TemplateNameRegistry does not contain info for file: %s", (Object)filePath);
        return (TemplatesPerFile)this.filePathsToTemplates().get((Object)filePath);
    }

    public ImmutableSet<SourceFilePath> allFiles() {
        return this.filePathsToTemplates().keySet();
    }
}

