/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.DelPackageDeclaration;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.AttrParam;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.TemplateImportType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class TemplateNode
extends AbstractBlockCommandNode
implements SoyNode.RenderUnitNode,
SoyNode.ExprHolderNode,
CommandTagAttribute.CommandTagAttributesHolder {
    private static final SoyErrorKind INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE = SoyErrorKind.of("Not allowed to alias the last part of the file''s namespace ({0}) to another namespace ({1}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_ALIAS = SoyErrorKind.of("Duplicate alias definition ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyFileHeaderInfo soyFileHeaderInfo;
    private final String templateName;
    private final Identifier partialTemplateName;
    private final Visibility visibility;
    private final WhitespaceMode whitespaceMode;
    private final TemplateContentKind contentKind;
    private final ImmutableList<String> requiredCssNamespaces;
    private final String cssBaseNamespace;
    private String soyDoc;
    private String soyDocDesc;
    private final boolean strictHtml;
    private HtmlElementMetadataP templateMetadata = null;
    private final String commandText;
    private final SourceLocation openTagLocation;
    private ImmutableList<TemplateHeaderVarDefn> headerParams;
    private final List<CommandTagAttribute> attributes;
    private final SourceLocation allowExtraAttributesLoc;
    private ImmutableSet<String> reservedAttributes;
    private final boolean component;

    TemplateNode(TemplateNodeBuilder<?> nodeBuilder, String cmdName, SoyFileHeaderInfo soyFileHeaderInfo, Visibility visibility, ImmutableList<TemplateHeaderVarDefn> params) {
        super(nodeBuilder.getId(), nodeBuilder.sourceLocation, nodeBuilder.openTagLocation, cmdName);
        Preconditions.checkNotNull(params);
        this.headerParams = params == null ? ImmutableList.of() : params;
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.templateName = nodeBuilder.getTemplateName();
        this.partialTemplateName = nodeBuilder.getPartialTemplateName();
        this.visibility = visibility;
        this.whitespaceMode = nodeBuilder.getWhitespaceMode();
        this.contentKind = (TemplateContentKind)Preconditions.checkNotNull((Object)nodeBuilder.getContentKind());
        this.requiredCssNamespaces = nodeBuilder.getRequiredCssNamespaces();
        this.cssBaseNamespace = nodeBuilder.getCssBaseNamespace();
        this.soyDoc = nodeBuilder.getSoyDoc();
        this.soyDocDesc = nodeBuilder.getSoyDocDesc();
        this.strictHtml = this.computeStrictHtmlMode(nodeBuilder.getStrictHtmlDisabled());
        this.commandText = nodeBuilder.getCmdText().trim();
        this.openTagLocation = nodeBuilder.openTagLocation;
        this.attributes = nodeBuilder.getAttributes();
        this.allowExtraAttributesLoc = nodeBuilder.allowExtraAttributesLoc;
        this.reservedAttributes = ImmutableSet.of();
        this.component = nodeBuilder.getComponent();
    }

    protected TemplateNode(TemplateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.headerParams = TemplateNode.copyParams(orig.headerParams, copyState);
        this.soyFileHeaderInfo = orig.soyFileHeaderInfo.copy();
        this.templateName = orig.templateName;
        this.partialTemplateName = orig.partialTemplateName;
        this.visibility = orig.visibility;
        this.whitespaceMode = orig.whitespaceMode;
        this.contentKind = orig.contentKind;
        this.requiredCssNamespaces = orig.requiredCssNamespaces;
        this.cssBaseNamespace = orig.cssBaseNamespace;
        this.soyDoc = orig.soyDoc;
        this.soyDocDesc = orig.soyDocDesc;
        this.strictHtml = orig.strictHtml;
        this.commandText = orig.commandText;
        this.openTagLocation = orig.openTagLocation;
        this.templateMetadata = orig.templateMetadata;
        this.attributes = (List)orig.attributes.stream().map(c -> c.copy(copyState)).collect(ImmutableList.toImmutableList());
        this.allowExtraAttributesLoc = orig.allowExtraAttributesLoc;
        this.reservedAttributes = orig.reservedAttributes;
        this.component = orig.component;
    }

    private static ImmutableList<TemplateHeaderVarDefn> copyParams(ImmutableList<TemplateHeaderVarDefn> orig, CopyState copyState) {
        ImmutableList.Builder newParams = ImmutableList.builder();
        for (TemplateHeaderVarDefn prev : orig) {
            TemplateHeaderVarDefn next = prev.copy(copyState);
            newParams.add((Object)next);
            copyState.updateRefs(prev, next);
        }
        return newParams.build();
    }

    public SoyFileHeaderInfo getSoyFileHeaderInfo() {
        return this.soyFileHeaderInfo;
    }

    public String getDelPackageName() {
        return this.soyFileHeaderInfo.getDelPackageName();
    }

    @Override
    public List<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean getAllowExtraAttributes() {
        return this.allowExtraAttributesLoc != null;
    }

    public SourceLocation getAllowExtraAttributesLoc() {
        return this.allowExtraAttributesLoc;
    }

    public ImmutableSet<String> getReservedAttributes() {
        return this.reservedAttributes;
    }

    public void setReservedAttributes(ImmutableSet<String> reservedAttributes) {
        this.reservedAttributes = reservedAttributes;
    }

    public abstract String getTemplateNameForUserMsgs();

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean getComponent() {
        return this.component;
    }

    public SourceLocation getTemplateNameLocation() {
        return this.partialTemplateName.location();
    }

    public void clearStateVars() {
        this.headerParams = (ImmutableList)this.headerParams.stream().filter(p -> !(p instanceof TemplateStateVar)).collect(ImmutableList.toImmutableList());
    }

    public String getPartialTemplateName() {
        return this.partialTemplateName.identifier();
    }

    public String getLocalTemplateSymbol() {
        String s = this.partialTemplateName.identifier();
        return s != null && s.startsWith(".") ? s.substring(1) : s;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.openTagLocation;
    }

    public WhitespaceMode getWhitespaceMode() {
        return this.whitespaceMode;
    }

    private String getDeclName(TemplateHeaderVarDefn headerVar) {
        if (headerVar instanceof TemplateStateVar) {
            return "@state";
        }
        if (headerVar instanceof AttrParam) {
            return "@attribute";
        }
        if (headerVar.isInjected()) {
            return "@inject";
        }
        return "@param";
    }

    private boolean computeStrictHtmlMode(boolean strictHtmlDisabled) {
        if (strictHtmlDisabled) {
            return false;
        }
        return this.contentKind.getSanitizedContentKind().isHtml();
    }

    public boolean isStrictHtml() {
        return this.strictHtml;
    }

    @Override
    public SanitizedContentKind getContentKind() {
        return this.contentKind.getSanitizedContentKind();
    }

    public TemplateContentKind getTemplateContentKind() {
        return this.contentKind;
    }

    public ImmutableList<String> getRequiredCssNamespaces() {
        return this.requiredCssNamespaces;
    }

    public String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    public void clearSoyDocStrings() {
        this.soyDoc = null;
        this.soyDocDesc = null;
    }

    @Nullable
    public String getSoyDoc() {
        return this.soyDoc;
    }

    @Nullable
    public String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    public ImmutableList<TemplateParam> getParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam) || header.isInjected()) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    public void setHtmlElementMetadata(HtmlElementMetadataP metadata) {
        this.templateMetadata = metadata;
    }

    public HtmlElementMetadataP getHtmlElementMetadata() {
        return this.templateMetadata;
    }

    public ImmutableList<TemplateParam> getInjectedParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam) || !header.isInjected()) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    public ImmutableList<TemplateParam> getAllParams() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateParam)) continue;
            builder.add((Object)((TemplateParam)header));
        }
        return builder.build();
    }

    @Override
    public SoyFileNode getParent() {
        return (SoyFileNode)super.getParent();
    }

    @Override
    public String getCommandText() {
        return this.commandText;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder exprs = ImmutableList.builder();
        for (TemplateHeaderVarDefn param : this.getParams()) {
            ExprRootNode defaultValue = param.defaultValue();
            if (defaultValue == null) continue;
            exprs.add((Object)defaultValue);
        }
        for (CommandTagAttribute attribute : this.attributes) {
            if (!attribute.hasExprValue()) continue;
            exprs.addAll(attribute.valueAsExprList());
        }
        return exprs.build();
    }

    public void addParam(TemplateParam param) {
        this.headerParams = ImmutableList.builder().addAll(this.headerParams).add((Object)param).build();
    }

    public ImmutableList<TemplateHeaderVarDefn> getHeaderParams() {
        return this.headerParams;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.soyDoc != null) {
            sb.append(this.soyDoc).append("\n");
        }
        sb.append(this.getTagString()).append("\n");
        this.appendHeaderVarDecl(this.getHeaderParams(), sb);
        StringBuilder bodySb = new StringBuilder();
        this.appendSourceStringForChildren(bodySb);
        int bodyLen = bodySb.length();
        if (bodyLen != 0) {
            if (bodyLen != 1 && bodySb.charAt(bodyLen - 1) == ' ') {
                bodySb.replace(bodyLen - 1, bodyLen, "{sp}");
            }
            if (bodySb.charAt(0) == ' ') {
                bodySb.replace(0, 1, "{sp}");
            }
        }
        sb.append((CharSequence)bodySb);
        sb.append("\n");
        sb.append("{/").append(this.getCommandName()).append("}\n");
        return sb.toString();
    }

    protected void appendHeaderVarDecl(ImmutableList<? extends TemplateHeaderVarDefn> headerVars, StringBuilder sb) {
        for (TemplateHeaderVarDefn headerVar : headerVars) {
            sb.append("  {").append(this.getDeclName(headerVar));
            if (!headerVar.isRequired()) {
                sb.append("?");
            }
            sb.append(" ").append(headerVar.name()).append(": ").append(headerVar.hasType() ? headerVar.type() : headerVar.getTypeNode()).append("}");
            if (headerVar.desc() != null) {
                sb.append("  /** ").append(headerVar.desc()).append(" */");
            }
            sb.append("\n");
        }
    }

    public StackTraceElement createStackTraceElement(SourceLocation srcLocation) {
        return new StackTraceElement(this.soyFileHeaderInfo.namespace, this.partialTemplateName.identifier().substring(1), srcLocation.getFileName(), srcLocation.getBeginLine());
    }

    public VarDefn asVarDefn() {
        return new TemplateVarDefn(this.getLocalTemplateSymbol(), this.getTemplateNameLocation(), TemplateImportType.create(this.getTemplateName()));
    }

    private static class TemplateVarDefn
    extends AbstractVarDefn {
        public TemplateVarDefn(String name, @Nullable SourceLocation nameLocation, @Nullable SoyType type) {
            super(name, nameLocation, type);
        }

        @Override
        public VarDefn.Kind kind() {
            return VarDefn.Kind.TEMPLATE;
        }

        @Override
        public boolean isInjected() {
            return false;
        }
    }

    public static class SoyFileHeaderInfo {
        public static final SoyFileHeaderInfo EMPTY = new SoyFileHeaderInfo("sample.ns");
        private final ImmutableMap<String, String> aliasToNamespaceMap;
        private final ImmutableList<AliasDeclaration> aliasDeclarations;
        private final ImmutableList<String> importSymbols;
        @Nullable
        private final DelPackageDeclaration delPackage;
        private final Priority priority;
        @Nullable
        private final String namespace;
        private final Set<String> usedAliases;

        public SoyFileHeaderInfo(ErrorReporter errorReporter, @Nullable DelPackageDeclaration delPackage, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases, Collection<String> importSymbols) {
            this(delPackage, namespaceDeclaration.getNamespace(), SoyFileHeaderInfo.createAliasMap(errorReporter, namespaceDeclaration, aliases), (ImmutableList<AliasDeclaration>)ImmutableList.copyOf(aliases), (ImmutableList<String>)ImmutableList.copyOf(importSymbols));
        }

        @VisibleForTesting
        public SoyFileHeaderInfo(String namespace) {
            this(null, namespace, (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<AliasDeclaration>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
        }

        private SoyFileHeaderInfo(@Nullable DelPackageDeclaration delPackage, String namespace, ImmutableMap<String, String> aliasToNamespaceMap, ImmutableList<AliasDeclaration> aliasDeclarations, ImmutableList<String> importSymbols) {
            this.delPackage = delPackage;
            this.priority = delPackage == null ? Priority.STANDARD : Priority.HIGH_PRIORITY;
            this.namespace = namespace;
            this.aliasToNamespaceMap = aliasToNamespaceMap;
            this.aliasDeclarations = aliasDeclarations;
            this.importSymbols = importSymbols;
            this.usedAliases = new HashSet<String>();
        }

        private SoyFileHeaderInfo(SoyFileHeaderInfo orig) {
            this.delPackage = orig.delPackage;
            this.priority = orig.priority;
            this.namespace = orig.namespace;
            this.aliasToNamespaceMap = orig.aliasToNamespaceMap;
            this.aliasDeclarations = orig.aliasDeclarations;
            this.importSymbols = orig.importSymbols;
            this.usedAliases = new HashSet<String>(orig.usedAliases);
        }

        public Identifier resolveAlias(Identifier identifier) {
            String remainder;
            String firstIdent;
            String fullName = identifier.identifier();
            SourceLocation sourceLocation = identifier.location();
            int i = fullName.indexOf(46);
            if (i > 0) {
                firstIdent = fullName.substring(0, i);
                remainder = fullName.substring(i);
            } else {
                firstIdent = fullName;
                remainder = "";
            }
            if (this.importSymbols.contains((Object)firstIdent)) {
                return identifier;
            }
            String alias = (String)this.aliasToNamespaceMap.get((Object)firstIdent);
            if (alias != null) {
                this.usedAliases.add(firstIdent);
            }
            return alias == null ? Identifier.create(fullName, sourceLocation) : Identifier.create(alias + remainder, fullName, sourceLocation);
        }

        public boolean hasAlias(String alias) {
            return this.aliasToNamespaceMap.containsKey((Object)alias);
        }

        public boolean aliasUsed(String alias) {
            return this.usedAliases.contains(alias);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getDelPackageName() {
            return this.delPackage == null ? null : this.delPackage.name().identifier();
        }

        public DelPackageDeclaration getDelPackage() {
            return this.delPackage;
        }

        public ImmutableList<AliasDeclaration> getAliases() {
            return this.aliasDeclarations;
        }

        public Priority getPriority() {
            return this.priority;
        }

        private static ImmutableMap<String, String> createAliasMap(ErrorReporter errorReporter, NamespaceDeclaration namespaceDeclaration, Collection<AliasDeclaration> aliases) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            String aliasForFileNamespace = BaseUtils.extractPartAfterLastDot(namespaceDeclaration.getNamespace());
            for (AliasDeclaration aliasDeclaration : aliases) {
                String aliasNamespace = aliasDeclaration.namespace().identifier();
                String alias = aliasDeclaration.alias().identifier();
                if (alias.equals(aliasForFileNamespace) && !aliasNamespace.equals(namespaceDeclaration.getNamespace())) {
                    errorReporter.report(aliasDeclaration.alias().location(), INVALID_ALIAS_FOR_LAST_PART_OF_NAMESPACE, namespaceDeclaration.getNamespace(), aliasNamespace);
                }
                if (map.containsKey(alias)) {
                    errorReporter.report(aliasDeclaration.alias().location(), DUPLICATE_ALIAS, alias);
                }
                map.put(alias, aliasNamespace);
            }
            return ImmutableMap.copyOf((Map)map);
        }

        public SoyFileHeaderInfo copy() {
            return new SoyFileHeaderInfo(this);
        }
    }

    public static enum Priority {
        STANDARD(0),
        HIGH_PRIORITY(1);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

