/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.soytree.AutoValue_TemplatesPerFile_TemplateName;
import com.google.template.soy.soytree.TemplateMetadata;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class TemplatesPerFile {
    private final SourceFilePath filePath;
    private final ImmutableSet<TemplateName> templates;

    private TemplatesPerFile(SourceFilePath filePath, ImmutableSet<TemplateName> templates) {
        this.filePath = filePath;
        this.templates = templates;
    }

    public SourceFilePath getFilePath() {
        return this.filePath;
    }

    public String getNamespace() {
        Preconditions.checkState((!this.templates.isEmpty() ? 1 : 0) != 0);
        return ((TemplateName)Iterables.getFirst(this.templates, null)).getNamespace();
    }

    public ImmutableSet<TemplateName> getTemplateNames() {
        return this.templates;
    }

    public ImmutableSet<String> getUnqualifiedTemplateNames() {
        return (ImmutableSet)this.templates.stream().map(TemplateName::unqualifiedName).collect(ImmutableSet.toImmutableSet());
    }

    public boolean hasTemplateWithUnqualifiedName(String unqualifiedTemplateName) {
        return this.templates.stream().anyMatch(name -> name.unqualifiedName().equals(unqualifiedTemplateName));
    }

    public TemplateName getFullTemplateName(String unqualifiedTemplateName) {
        Preconditions.checkArgument((boolean)this.hasTemplateWithUnqualifiedName(unqualifiedTemplateName), (String)"File: %s does not contain template name: %s", (Object)this.filePath, (Object)unqualifiedTemplateName);
        return this.templates.stream().filter(k -> k.unqualifiedName().equals(unqualifiedTemplateName)).findFirst().get();
    }

    public static Builder builder(SourceFilePath filePath) {
        return new Builder(filePath);
    }

    @AutoValue
    public static abstract class TemplateName {
        static TemplateName create(String fullyQualifiedName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fullyQualifiedName) ? 1 : 0) != 0, (String)"Template name cannot be null or empty %s", (Object)fullyQualifiedName);
            int startOfUnqualifiedName = fullyQualifiedName.lastIndexOf(46);
            String unqualifiedName = fullyQualifiedName.substring(startOfUnqualifiedName + 1);
            return new AutoValue_TemplatesPerFile_TemplateName(fullyQualifiedName, unqualifiedName);
        }

        public abstract String fullyQualifiedName();

        public abstract String unqualifiedName();

        public String getNamespace() {
            if (this.fullyQualifiedName().equals(this.unqualifiedName())) {
                return "";
            }
            return this.fullyQualifiedName().substring(0, this.fullyQualifiedName().length() - (1 + this.unqualifiedName().length()));
        }
    }

    public static class Builder {
        private final SourceFilePath filePath;
        private final Set<TemplateName> templates;

        private Builder(SourceFilePath filePath) {
            this.filePath = filePath;
            this.templates = new LinkedHashSet<TemplateName>();
        }

        public Builder addAllTemplates(List<TemplateMetadata> templateList) {
            templateList.forEach(this::addTemplate);
            return this;
        }

        public Builder addTemplate(TemplateMetadata template) {
            this.addTemplate(template.getTemplateName());
            return this;
        }

        public Builder addTemplate(String fullTemplateName) {
            this.templates.add(TemplateName.create(fullTemplateName));
            return this;
        }

        public TemplatesPerFile build() {
            return new TemplatesPerFile(this.filePath, ImmutableSet.copyOf(this.templates));
        }
    }
}

