/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree.defn;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.exprtree.AbstractVarDefn;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnknownType;
import javax.annotation.Nullable;

public final class ImportedVar
extends AbstractVarDefn {
    public static final String MODULE_IMPORT = "*";
    private final String symbol;

    public static VarDefn nested(VarDefn parent, SoyType type) {
        return new NestedVarDefn(parent, type);
    }

    public ImportedVar(String name, @Nullable String alias, SourceLocation nameLocation) {
        super(alias != null ? alias : name, nameLocation, UnknownType.getInstance());
        Preconditions.checkArgument((alias == null || !alias.isEmpty() && !alias.equals(name) ? 1 : 0) != 0);
        this.symbol = name;
    }

    private ImportedVar(ImportedVar var) {
        super(var);
        this.symbol = var.symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public VarDefn.Kind kind() {
        return VarDefn.Kind.IMPORT_VAR;
    }

    public boolean isAliased() {
        return !this.name().equals(this.symbol);
    }

    public ImportedVar clone() {
        return new ImportedVar(this);
    }

    @Override
    public boolean isInjected() {
        return false;
    }

    public boolean isModuleImport() {
        return MODULE_IMPORT.equals(this.symbol);
    }

    public void setType(SoyType type) {
        this.type = type;
    }

    private static class NestedVarDefn
    implements VarDefn.ImmutableVarDefn {
        private final Identifier parentId;
        private final SoyType type;

        public NestedVarDefn(VarDefn parent, SoyType type) {
            this.parentId = Identifier.create(parent.name(), parent.nameLocation());
            this.type = (SoyType)Preconditions.checkNotNull((Object)type);
        }

        @Override
        public VarDefn.Kind kind() {
            return VarDefn.Kind.IMPORT_VAR;
        }

        @Override
        public String name() {
            return this.parentId.identifier();
        }

        @Override
        @Nullable
        public SourceLocation nameLocation() {
            return this.parentId.location();
        }

        @Override
        public SoyType type() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public boolean isInjected() {
            return false;
        }
    }
}

