/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.SoyTypeVisitor;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnknownType;

public abstract class SoyType {
    @LazyInit
    private SoyTypeP protoDual;

    SoyType() {
    }

    public abstract Kind getKind();

    public final boolean isAssignableFromLoose(SoyType srcType) {
        return this.isAssignableFromInternal(srcType, UnknownAssignmentPolicy.ALLOWED);
    }

    public final boolean isAssignableFromStrict(SoyType srcType) {
        return this.isAssignableFromInternal(srcType, UnknownAssignmentPolicy.DISALLOWED);
    }

    final boolean isAssignableFromInternal(SoyType soyType, UnknownAssignmentPolicy unknownPolicy) {
        if (unknownPolicy == UnknownAssignmentPolicy.ALLOWED && soyType == UnknownType.getInstance()) {
            return true;
        }
        for (SoyType type : SoyTypes.expandUnions(soyType)) {
            if (this.doIsAssignableFromNonUnionType(type, unknownPolicy)) continue;
            return false;
        }
        return true;
    }

    @ForOverride
    boolean doIsAssignableFromNonUnionType(SoyType type, UnknownAssignmentPolicy unknownPolicy) {
        return this.doIsAssignableFromNonUnionType(type);
    }

    @ForOverride
    boolean doIsAssignableFromNonUnionType(SoyType type) {
        throw new AbstractMethodError();
    }

    public abstract String toString();

    public final SoyTypeP toProto() {
        SoyTypeP local = this.protoDual;
        if (local == null) {
            SoyTypeP.Builder builder = SoyTypeP.newBuilder();
            this.doToProto(builder);
            this.protoDual = local = builder.build();
        }
        return local;
    }

    @ForOverride
    abstract void doToProto(SoyTypeP.Builder var1);

    public abstract <T> T accept(SoyTypeVisitor<T> var1);

    static enum UnknownAssignmentPolicy {
        ALLOWED,
        DISALLOWED;

    }

    public static enum Kind {
        ANY,
        UNKNOWN,
        NULL,
        BOOL,
        INT,
        FLOAT,
        STRING,
        HTML,
        ELEMENT,
        ATTRIBUTES,
        JS,
        CSS,
        URI,
        TRUSTED_RESOURCE_URI,
        LIST,
        RECORD,
        LEGACY_OBJECT_MAP,
        MAP,
        NAMED_TEMPLATE,
        MESSAGE,
        PROTO,
        PROTO_ENUM,
        TEMPLATE,
        UNION,
        VE,
        VE_DATA,
        PROTO_TYPE,
        PROTO_ENUM_TYPE,
        PROTO_EXTENSION,
        PROTO_MODULE,
        TEMPLATE_TYPE,
        TEMPLATE_MODULE;

        private static final ImmutableSet<Kind> STRING_KINDS;
        private static final ImmutableSet<Kind> ILLEGAL_OPERAND_KINDS_PLUS_OP;

        public boolean isKnownStringOrSanitizedContent() {
            return STRING_KINDS.contains((Object)this);
        }

        public boolean isKnownSanitizedContent() {
            return this != STRING && STRING_KINDS.contains((Object)this);
        }

        public boolean isIllegalOperandForBinaryOps() {
            return ILLEGAL_OPERAND_KINDS_PLUS_OP.contains((Object)this) || STRING_KINDS.contains((Object)this);
        }

        static {
            STRING_KINDS = Sets.immutableEnumSet((Enum)STRING, (Enum[])new Kind[]{HTML, ELEMENT, ATTRIBUTES, JS, CSS, URI, TRUSTED_RESOURCE_URI});
            ILLEGAL_OPERAND_KINDS_PLUS_OP = Sets.immutableEnumSet((Enum)LIST, (Enum[])new Kind[]{LEGACY_OBJECT_MAP, MAP, RECORD});
        }
    }
}

