/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.types.NamedTemplateType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnknownType;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class TemplateBindingUtil {
    private static final SoyErrorKind PARAMETER_NAME_MISMATCH = SoyErrorKind.of("Cannot bind parameter named `{0}` to template of type `{1}`; no such parameter.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PARAMETER_TYPE_MISMATCH = SoyErrorKind.of("Cannot bind parameter named `{0}` to template of type `{1}`; expected `{2}` but found `{3}`.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PARAMETER_ALREADY_BOUND = SoyErrorKind.of("Parameter named `{0}` already bound to template.", new SoyErrorKind.StyleAllowance[0]);

    public static SoyType bindParameters(SoyType base, RecordType parameterType, SoyTypeRegistry typeRegistry, ErrorReporter.LocationBound errorReporter) {
        Preconditions.checkArgument((boolean)SoyTypes.isKindOrUnionOfKinds(base, (Set<SoyType.Kind>)ImmutableSet.of((Object)((Object)SoyType.Kind.TEMPLATE), (Object)((Object)SoyType.Kind.NAMED_TEMPLATE))));
        HashSet<SoyType> types = new HashSet<SoyType>();
        block4: for (SoyType baseType : SoyTypes.expandUnions(base)) {
            switch (baseType.getKind()) {
                case TEMPLATE: {
                    types.add(TemplateBindingUtil.bindParametersToTemplate((TemplateType)baseType, parameterType, typeRegistry, errorReporter));
                    continue block4;
                }
                case NAMED_TEMPLATE: {
                    types.add(TemplateBindingUtil.bindParametersToNamedTemplate((NamedTemplateType)baseType, parameterType, typeRegistry, errorReporter));
                    continue block4;
                }
            }
            throw new AssertionError();
        }
        return typeRegistry.getOrCreateUnionType(types);
    }

    private static SoyType bindParametersToTemplate(TemplateType base, RecordType parameters, SoyTypeRegistry typeRegistry, ErrorReporter.LocationBound errorReporter) {
        HashSet unboundParameters = new HashSet(base.getParameterMap().keySet());
        boolean reportedErrors = false;
        for (RecordType.Member member : parameters.getMembers()) {
            if (!base.getParameterMap().containsKey((Object)member.name())) {
                String didYouMeanMessage = SoyErrors.getDidYouMeanMessage((Iterable<String>)base.getParameterMap().keySet(), member.name());
                errorReporter.report(PARAMETER_NAME_MISMATCH, member.name(), base, didYouMeanMessage);
                reportedErrors = true;
                continue;
            }
            if (!((SoyType)base.getParameterMap().get((Object)member.name())).isAssignableFromLoose(member.type())) {
                errorReporter.report(PARAMETER_TYPE_MISMATCH, member.name(), base, base.getParameterMap().get((Object)member.name()), member.type());
                reportedErrors = true;
            }
            unboundParameters.remove(member.name());
        }
        if (reportedErrors) {
            return UnknownType.getInstance();
        }
        TemplateType.Builder builder = base.toBuilder();
        ImmutableList newParameters = (ImmutableList)base.getParameters().stream().filter(parameter -> unboundParameters.contains(parameter.getName())).collect(ImmutableList.toImmutableList());
        builder.setIdentifierForDebugging(TemplateType.stringRepresentation((Iterable<TemplateType.Parameter>)newParameters, base.getContentKind(), (ImmutableSet<String>)ImmutableSet.of()));
        builder.setParameters((ImmutableList<TemplateType.Parameter>)newParameters);
        return typeRegistry.internTemplateType(builder.build());
    }

    private static SoyType bindParametersToNamedTemplate(NamedTemplateType base, RecordType parameters, SoyTypeRegistry typeRegistry, ErrorReporter.LocationBound errorReporter) {
        Optional<RecordType> alreadyBound = base.getBoundParameters();
        RecordType mergedParameters = null;
        boolean reportedErrors = false;
        if (alreadyBound.isPresent()) {
            for (String name : parameters.getMemberNames()) {
                if (alreadyBound.get().getMemberType(name) == null) continue;
                errorReporter.report(PARAMETER_ALREADY_BOUND, name);
                reportedErrors = true;
            }
            if (!reportedErrors) {
                mergedParameters = typeRegistry.getOrCreateRecordType(Iterables.concat(alreadyBound.get().getMembers(), parameters.getMembers()));
            }
        } else {
            mergedParameters = parameters;
        }
        if (reportedErrors) {
            return UnknownType.getInstance();
        }
        return NamedTemplateType.createWithBoundParameters(base.getTemplateName(), mergedParameters);
    }

    private TemplateBindingUtil() {
    }
}

