/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.AutoValue_SoyFileSetParser;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.FixedIdGenerator;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class SoyFileSetParser {
    public static Builder newBuilder() {
        return new AutoValue_SoyFileSetParser.Builder();
    }

    @Nullable
    abstract SoyAstCache cache();

    public abstract ImmutableMap<SourceFilePath, SoyFileSupplier> soyFileSuppliers();

    abstract ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits();

    abstract PassManager passManager();

    abstract ErrorReporter errorReporter();

    public abstract SoyTypeRegistry typeRegistry();

    public abstract Optional<CssRegistry> cssRegistry();

    public ParseResult parse() {
        try {
            return this.parseWithVersions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ParseResult parseWithVersions() throws IOException {
        SoyFileSetNode soyTree = new SoyFileSetNode(new IncrementingIdGenerator());
        boolean filesWereSkipped = false;
        FixedIdGenerator fixedIdGenerator = new FixedIdGenerator(-1);
        for (SoyFileSupplier fileSupplier : this.soyFileSuppliers().values()) {
            SoyFileNode node;
            SoyFileSupplier.Version version = fileSupplier.getVersion();
            SoyFileNode soyFileNode = node = this.cache() != null ? this.cache().get(fileSupplier.getFilePath(), version) : null;
            if (node == null) {
                node = this.parseSoyFileHelper(fileSupplier, fixedIdGenerator);
                if (node == null) {
                    filesWereSkipped = true;
                    continue;
                }
                this.passManager().runParsePasses(node, fixedIdGenerator);
                if (this.cache() != null) {
                    this.cache().put(fileSupplier.getFilePath(), version, node);
                }
            }
            node = SoyTreeUtils.cloneWithNewIds(node, soyTree.getNodeIdGenerator());
            soyTree.addChild(node);
        }
        if (filesWereSkipped) {
            return ParseResult.create(soyTree, Optional.empty(), Optional.empty());
        }
        FileSetMetadata partialRegistryForDeps = Metadata.metadataForDeps(this.compilationUnits(), this.errorReporter(), this.typeRegistry());
        this.passManager().runPasses(soyTree, partialRegistryForDeps);
        FileSetMetadata finalFileSetMetadata = this.passManager().getFinalTemplateRegistry();
        return ParseResult.create(soyTree, Optional.ofNullable(finalFileSetMetadata), this.cssRegistry());
    }

    private SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen) throws IOException {
        try (Reader soyFileReader = soyFileSupplier.open();){
            String filePath = soyFileSupplier.getFilePath().path();
            int lastBangIndex = filePath.lastIndexOf(33);
            if (lastBangIndex != -1) {
                filePath = filePath.substring(lastBangIndex + 1);
            }
            SoyFileNode soyFileNode = new SoyFileParser(nodeIdGen, soyFileReader, SourceFilePath.create(filePath), this.errorReporter()).parseSoyFile();
            return soyFileNode;
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setCache(SoyAstCache var1);

        public abstract Builder setSoyFileSuppliers(ImmutableMap<SourceFilePath, SoyFileSupplier> var1);

        public abstract Builder setCompilationUnits(ImmutableList<Metadata.CompilationUnitAndKind> var1);

        public abstract Builder setPassManager(PassManager var1);

        public abstract Builder setErrorReporter(ErrorReporter var1);

        public abstract Builder setTypeRegistry(SoyTypeRegistry var1);

        public abstract Builder setCssRegistry(Optional<CssRegistry> var1);

        public abstract SoyFileSetParser build();
    }

    public static class ParseResult {
        private final SoyFileSetNode soyTree;
        private final Optional<FileSetMetadata> registry;
        private final Optional<CssRegistry> cssRegistry;

        static ParseResult create(SoyFileSetNode soyTree, Optional<FileSetMetadata> registry, Optional<CssRegistry> cssRegistry) {
            return new ParseResult(soyTree, registry, cssRegistry);
        }

        ParseResult(SoyFileSetNode soyTree, Optional<FileSetMetadata> registry, Optional<CssRegistry> cssRegistry) {
            this.soyTree = soyTree;
            this.registry = registry;
            this.cssRegistry = cssRegistry;
        }

        public SoyFileSetNode fileSet() {
            return this.soyTree;
        }

        public final FileSetMetadata registry() {
            return this.registry.orElseThrow(() -> new IllegalStateException("No template registry, did you forget to check the error reporter?"));
        }

        public final CssRegistry cssRegistry() {
            return this.cssRegistry.orElseThrow(() -> new IllegalStateException("No template registry, did you forget to check the error reporter?"));
        }

        public final boolean hasRegistry() {
            return this.registry.isPresent();
        }
    }
}

