/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.AutoValue_HtmlToText_TagAndWs;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.shared.internal.Sanitizers;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class HtmlToText {
    private static final Pattern TAG = Pattern.compile("<(?:!--.*?--|(?:!|(/?[a-zA-Z][\\w:-]*))((?:[^>'\"]*|\"[^\"]*\"|'[^']*')*))>|\\z");
    private static final Pattern STYLE_ATTRIBUTE;
    private static final ImmutableSet<String> REMOVING_TAGS;
    private static final String WS_PRESERVING_TAGS = "pre";
    private static final String NEWLINE_TAGS = "br";
    private static final ImmutableSet<String> BLOCK_TAGS;
    private static final ImmutableSet<String> TAB_TAGS;
    private static final ImmutableSet<String> PRESERVE_WHITESPACE_STYLES;
    private static final ImmutableSet<String> COLLAPSE_WHITESPACE_STYLES;
    private static final Pattern HTML_WHITESPACE;

    private static ImmutableSet<String> createOpenTagSet(String ... tags) {
        return ImmutableSet.copyOf((Object[])tags);
    }

    private static ImmutableSet<String> createOpenAndCloseTagSet(String ... tags) {
        return (ImmutableSet)Stream.concat(Arrays.stream(tags).map(t -> "/" + t), Arrays.stream(tags)).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean endsWithNewline(StringBuffer builder) {
        return builder.length() == 0 || builder.charAt(builder.length() - 1) == '\n';
    }

    private static boolean emptyOrEndsWithWhitespace(StringBuffer builder) {
        return builder.length() == 0 || " \t\r\n".indexOf(builder.charAt(builder.length() - 1)) >= 0;
    }

    private static boolean matchesTag(String tag, ImmutableSet<String> tagSet) {
        return tagSet.contains((Object)tag);
    }

    private static boolean matchesTag(String tag, String tagSet) {
        return tagSet.equals(tag);
    }

    private static void replaceChar(StringBuffer builder, char from, char to) {
        for (int i = 0; i < builder.length(); ++i) {
            if (builder.charAt(i) != from) continue;
            builder.setCharAt(i, to);
        }
    }

    private HtmlToText() {
    }

    public static String convert(SoyValue value) {
        if (value == null || value instanceof NullData) {
            return "";
        }
        if (!(value instanceof SanitizedContent)) {
            return value.stringValue();
        }
        Preconditions.checkArgument((((SanitizedContent)value).getContentKind() == SanitizedContent.ContentKind.HTML ? 1 : 0) != 0);
        String html = value.stringValue();
        return new HtmlToTextConverter().convert(html);
    }

    static {
        String styleString = "[^:;\t\n\r ]*";
        String whitespace = "[\t\n\r ]";
        STYLE_ATTRIBUTE = Pattern.compile(String.format("%s*(%s)%s*:%s*(%s)%s*(?:;|$)", whitespace, styleString, whitespace, whitespace, styleString, whitespace));
        REMOVING_TAGS = HtmlToText.createOpenTagSet("script", "style", "textarea", "title");
        BLOCK_TAGS = HtmlToText.createOpenAndCloseTagSet("address", "blockquote", "dd", "div", "dl", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", WS_PRESERVING_TAGS, "table", "tr", "ul");
        TAB_TAGS = HtmlToText.createOpenTagSet("td", "th");
        PRESERVE_WHITESPACE_STYLES = ImmutableSet.of((Object)WS_PRESERVING_TAGS, (Object)"pre-wrap", (Object)"break-spaces");
        COLLAPSE_WHITESPACE_STYLES = ImmutableSet.of((Object)"normal", (Object)"nowrap");
        HTML_WHITESPACE = Pattern.compile("[ \t\r\n]+");
    }

    @AutoValue
    static abstract class TagAndWs {
        TagAndWs() {
        }

        static TagAndWs of(String tagName, boolean preserveWhitespace) {
            return new AutoValue_HtmlToText_TagAndWs(tagName, preserveWhitespace);
        }

        abstract String tagName();

        abstract boolean preserveWhitespace();
    }

    private static class HtmlToTextConverter {
        Matcher whitespaceMatcher = null;
        Matcher attributeMatcher = null;
        Matcher styleMatcher = null;
        ArrayDeque<TagAndWs> preserveWhitespaceStack = new ArrayDeque();

        private HtmlToTextConverter() {
        }

        private void resetWhitespaceMatcher(String html) {
            if (this.whitespaceMatcher == null) {
                this.whitespaceMatcher = HTML_WHITESPACE.matcher(html);
            } else {
                this.whitespaceMatcher.reset(html);
            }
        }

        private void resetAttributeMatcher(String html) {
            if (this.attributeMatcher == null) {
                this.attributeMatcher = Sanitizers.HTML_ATTRIBUTE_PATTERN.matcher(html);
            } else {
                this.attributeMatcher.reset(html);
            }
        }

        private void resetStyleMatcher(String html) {
            if (this.styleMatcher == null) {
                this.styleMatcher = STYLE_ATTRIBUTE.matcher(html);
            } else {
                this.styleMatcher.reset(html);
            }
        }

        String convert(String html) {
            StringBuffer text = new StringBuffer(html.length());
            int start = 0;
            String removingUntil = "";
            Matcher matcher = TAG.matcher(html);
            while (matcher.find()) {
                String lowerCaseTag;
                int offset = matcher.start();
                String tag = matcher.group(1);
                String attrs = matcher.group(2);
                String string = lowerCaseTag = tag != null ? Ascii.toLowerCase((String)tag) : null;
                if (removingUntil.isEmpty()) {
                    String chunk = html.substring(start, offset);
                    chunk = UnescapeUtils.unescapeHtml(chunk);
                    if (!this.shouldPreserveWhitespace()) {
                        this.resetWhitespaceMatcher(chunk);
                        while (this.whitespaceMatcher.find()) {
                            if (this.whitespaceMatcher.start() == 0 && HtmlToText.emptyOrEndsWithWhitespace(text)) {
                                this.whitespaceMatcher.appendReplacement(text, "");
                                continue;
                            }
                            this.whitespaceMatcher.appendReplacement(text, " ");
                        }
                        this.whitespaceMatcher.appendTail(text);
                    } else {
                        text.append(chunk);
                    }
                    if (lowerCaseTag != null) {
                        if (HtmlToText.matchesTag(lowerCaseTag, (ImmutableSet<String>)REMOVING_TAGS)) {
                            removingUntil = '/' + lowerCaseTag;
                        } else if (HtmlToText.matchesTag(lowerCaseTag, HtmlToText.NEWLINE_TAGS)) {
                            text.append('\n');
                        } else if (HtmlToText.matchesTag(lowerCaseTag, (ImmutableSet<String>)BLOCK_TAGS)) {
                            if (!HtmlToText.endsWithNewline(text)) {
                                text.append('\n');
                            }
                        } else if (HtmlToText.matchesTag(lowerCaseTag, (ImmutableSet<String>)TAB_TAGS)) {
                            text.append('\t');
                        }
                        if (!Sanitizers.HTML5_VOID_ELEMENTS.contains((Object)lowerCaseTag)) {
                            this.updatePreserveWhitespaceStack(lowerCaseTag, attrs);
                        }
                    }
                } else if (removingUntil.equals(lowerCaseTag)) {
                    removingUntil = "";
                }
                start = matcher.end();
            }
            HtmlToText.replaceChar(text, '\u00a0', ' ');
            return text.toString();
        }

        private boolean shouldPreserveWhitespace() {
            return !this.preserveWhitespaceStack.isEmpty() && this.preserveWhitespaceStack.peek().preserveWhitespace();
        }

        private Optional<Boolean> getStylePreservesWhitespace(String style) {
            this.resetStyleMatcher(style);
            while (this.styleMatcher.find()) {
                String whitespaceStyle;
                String styleAttribute = this.styleMatcher.group(1);
                String styleAttributeValue = this.styleMatcher.group(2);
                if (Strings.isNullOrEmpty((String)styleAttribute) || !Ascii.equalsIgnoreCase((CharSequence)styleAttribute, (CharSequence)"white-space")) continue;
                String string = whitespaceStyle = Strings.isNullOrEmpty((String)styleAttributeValue) ? "" : Ascii.toLowerCase((String)styleAttributeValue);
                if (PRESERVE_WHITESPACE_STYLES.contains((Object)whitespaceStyle)) {
                    return Optional.of(true);
                }
                if (!COLLAPSE_WHITESPACE_STYLES.contains((Object)whitespaceStyle)) continue;
                return Optional.of(false);
            }
            return Optional.empty();
        }

        private Optional<Boolean> getAttributesPreserveWhitespace(String attrs) {
            if (Strings.isNullOrEmpty((String)attrs)) {
                return Optional.empty();
            }
            this.resetAttributeMatcher(attrs);
            while (this.attributeMatcher.find()) {
                String attributeName = this.attributeMatcher.group(1);
                if (Strings.isNullOrEmpty((String)attributeName) || !Ascii.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)"style")) continue;
                String style = this.attributeMatcher.group(2);
                if (!Strings.isNullOrEmpty((String)style)) {
                    if (style.charAt(0) == '\'' || style.charAt(0) == '\"') {
                        style = style.substring(1, style.length() - 1);
                    }
                    return this.getStylePreservesWhitespace(style);
                }
                return Optional.empty();
            }
            return Optional.empty();
        }

        private void updatePreserveWhitespaceStack(String lowerCaseTag, String attrs) {
            if (lowerCaseTag.charAt(0) == '/') {
                lowerCaseTag = lowerCaseTag.substring(1);
                while (!this.preserveWhitespaceStack.isEmpty() && !this.preserveWhitespaceStack.pop().tagName().equals(lowerCaseTag)) {
                }
            } else if (HtmlToText.matchesTag(lowerCaseTag, HtmlToText.WS_PRESERVING_TAGS)) {
                this.preserveWhitespaceStack.push(TagAndWs.of(lowerCaseTag, true));
            } else {
                boolean preserveWhitespace = this.getAttributesPreserveWhitespace(attrs).orElseGet(this::shouldPreserveWhitespace);
                this.preserveWhitespaceStack.push(TagAndWs.of(lowerCaseTag, preserveWhitespace));
            }
        }
    }
}

