/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.lang.reflect.Method;
import java.util.List;

@SoyFunctionSignature(name="strSub", value={@Signature(returnType="string", parameterTypes={"string", "int"}), @Signature(returnType="string", parameterTypes={"string", "int", "int"})})
@SoyMethodSignature(name="substring", baseType="string", value={@Signature(parameterTypes={"int"}, returnType="string"), @Signature(parameterTypes={"int", "int"}, returnType="string")})
@SoyPureFunction
final class StrSubFunction
implements SoyJavaSourceFunction,
SoyJavaScriptSourceFunction,
SoyPythonSourceFunction {
    StrSubFunction() {
    }

    @Override
    public JavaScriptValue applyForJavaScriptSource(JavaScriptValueFactory factory, List<JavaScriptValue> args, JavaScriptPluginContext context) {
        return args.get(0).coerceToString().invokeMethod("substring", args.subList(1, args.size()).toArray(new JavaScriptValue[0]));
    }

    @Override
    public PythonValue applyForPythonSource(PythonValueFactory factory, List<PythonValue> args, PythonPluginContext context) {
        PythonValue str = args.get(0).coerceToString();
        return factory.global("runtime.str_substring").call(str, args.get(1), args.size() == 3 ? args.get(2) : factory.constantNull());
    }

    @Override
    public JavaValue applyForJavaSource(JavaValueFactory factory, List<JavaValue> args, JavaPluginContext context) {
        if (args.size() == 2) {
            return factory.callStaticMethod(Methods.STR_SUB_START, args.get(0), args.get(1).asSoyInt());
        }
        return factory.callStaticMethod(Methods.STR_SUB_START_END, args.get(0), args.get(1).asSoyInt(), args.get(2).asSoyInt());
    }

    private static final class Methods {
        static final Method STR_SUB_START = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "strSub", SoyValue.class, Integer.TYPE);
        static final Method STR_SUB_START_END = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "strSub", SoyValue.class, Integer.TYPE, Integer.TYPE);

        private Methods() {
        }
    }
}

