/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporterImpl;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Map;

public abstract class ErrorReporter {
    private static final LocationBound NO_OP = new LocationBound(){

        @Override
        public void report(SoyErrorKind error, Object ... args) {
        }

        @Override
        public void warn(SoyErrorKind error, Object ... args) {
        }
    };

    public static ErrorReporter create(Map<SourceFilePath, SoyFileSupplier> filePathsToSuppliers) {
        return new ErrorReporterImpl((ImmutableMap<SourceFilePath, SoyFileSupplier>)ImmutableMap.copyOf(filePathsToSuppliers));
    }

    public static ErrorReporter devnull() {
        return new ExplodingErrorReporter(){

            @Override
            public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            }

            @Override
            public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            }
        };
    }

    @VisibleForTesting
    public static ErrorReporter createForTest() {
        return new ErrorReporterImpl((ImmutableMap<SourceFilePath, SoyFileSupplier>)ImmutableMap.of());
    }

    public static ErrorReporter exploding() {
        return ExplodingErrorReporter.EXPLODING;
    }

    public static ErrorReporter explodeOnErrorsAndIgnoreWarnings() {
        return ExplodingErrorReporter.EXPLODING_IGNORE_WARNINGS;
    }

    public static ErrorReporter explodeOnErrorsAndIgnoreDeprecations() {
        return new ExplodingErrorReporter(){

            @Override
            public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
                if (!error.isDeprecation()) {
                    super.warn(sourceLocation, error, args);
                }
            }
        };
    }

    public abstract void report(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public abstract void warn(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public abstract void copyTo(ErrorReporter var1);

    public LocationBound bind(SourceLocation sourceLocation) {
        return new LocationBoundImp(sourceLocation);
    }

    public LocationBound bindIgnoringUnknown(SourceLocation sourceLocation) {
        return sourceLocation.isKnown() ? new LocationBoundImp(sourceLocation) : NO_OP;
    }

    public final Checkpoint checkpoint() {
        return new Checkpoint(this, this.getCurrentNumberOfErrors());
    }

    public final boolean errorsSince(Checkpoint checkpoint) {
        Checkpoint impl = checkpoint;
        if (impl.owner != this) {
            throw new IllegalArgumentException("Can only call errorsSince on a Checkpoint instance that was returned from this same reporter");
        }
        return this.getCurrentNumberOfErrors() > impl.errorsSoFar;
    }

    public final boolean hasErrors() {
        return this.getCurrentNumberOfErrors() != 0;
    }

    public final boolean hasErrorsOrWarnings() {
        return this.getCurrentNumberOfReports() != 0;
    }

    @ForOverride
    abstract int getCurrentNumberOfErrors();

    @ForOverride
    abstract int getCurrentNumberOfReports();

    public abstract ImmutableList<SoyError> getErrors();

    public abstract ImmutableList<SoyError> getWarnings();

    private class LocationBoundImp
    implements LocationBound {
        private final SourceLocation sourceLocation;

        public LocationBoundImp(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public void report(SoyErrorKind error, Object ... args) {
            ErrorReporter.this.report(this.sourceLocation, error, args);
        }

        @Override
        public void warn(SoyErrorKind error, Object ... args) {
            ErrorReporter.this.warn(this.sourceLocation, error, args);
        }
    }

    public static final class Checkpoint {
        private final ErrorReporter owner;
        private final int errorsSoFar;

        private Checkpoint(ErrorReporter owner, int errorsSoFar) {
            this.owner = owner;
            this.errorsSoFar = errorsSoFar;
        }
    }

    public static interface LocationBound {
        public void report(SoyErrorKind var1, Object ... var2);

        public void warn(SoyErrorKind var1, Object ... var2);
    }
}

