/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;

class ExplodingErrorReporter
extends ErrorReporter {
    static final ErrorReporter EXPLODING = new ExplodingErrorReporter();
    static final ErrorReporter EXPLODING_IGNORE_WARNINGS = new ExplodingErrorReporter(){

        @Override
        public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            Preconditions.checkNotNull((Object)sourceLocation);
        }
    };

    ExplodingErrorReporter() {
    }

    protected final void explode(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        throw new AssertionError((Object)String.format("Unexpected error: %s at %s", error.format(args), sourceLocation));
    }

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        Preconditions.checkNotNull((Object)sourceLocation);
        this.explode(sourceLocation, error, args);
    }

    @Override
    public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        Preconditions.checkNotNull((Object)sourceLocation);
        this.explode(sourceLocation, error, args);
    }

    @Override
    final int getCurrentNumberOfErrors() {
        return 0;
    }

    @Override
    final int getCurrentNumberOfReports() {
        return 0;
    }

    @Override
    public final void copyTo(ErrorReporter other) {
    }

    @Override
    public final ImmutableList<SoyError> getErrors() {
        return ImmutableList.of();
    }

    @Override
    public final ImmutableList<SoyError> getWarnings() {
        return ImmutableList.of();
    }
}

