/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.incrementaldomsrc.IncrementalDomTranslateExprNodeVisitor;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.ClassExpression;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private int staticsCounter = 0;
    private String alias = "";
    private boolean hasNonConstantState;
    private String scriptOutputVar;

    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        super(jsSrcOptions, javaScriptValueFactory, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, typeRegistry);
    }

    @Override
    protected JsCodeBuilder createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    @Override
    protected IncrementalDomCodeBuilder createChildJsCodeBuilder() {
        return new IncrementalDomCodeBuilder(this.getJsCodeBuilder());
    }

    @Override
    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forIncrementalDomState(paramType);
    }

    @Override
    protected JsType getJsTypeForParamTypeCheck(SoyType paramType) {
        return JsType.forIncrementalDom(paramType);
    }

    @Override
    protected void visit(SoyNode node) {
        try {
            super.visit(node);
        }
        catch (RuntimeException e) {
            throw new Error("error from : " + (Object)((Object)node.getKind()) + " @ " + node.getSourceLocation(), e);
        }
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (GenIncrementalDomCodeVisitor.isTextContent(node.getContentKind())) {
            return super.getTemplateReturnType(node);
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.staticsCounter = 0;
        SanitizedContentKind kind = node.getContentKind();
        this.getJsCodeBuilder().setContentKind(kind);
        this.alias = node instanceof TemplateDelegateNode ? node.getLocalTemplateSymbol() : this.templateAliases.get(node.getTemplateName());
        if (node instanceof TemplateElementNode) {
            this.hasNonConstantState = this.calcHasNonConstantState((TemplateElementNode)node);
        }
        super.visitTemplateNode(node);
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression type = kind.isHtml() ? IncrementalDomRuntime.SOY_IDOM_TYPE_HTML : IncrementalDomRuntime.SOY_IDOM_TYPE_ATTRIBUTE;
            this.getJsCodeBuilder().append(Statement.assign(Expression.id(this.alias).dotAccess("contentKind"), type));
        }
        if (node instanceof TemplateElementNode) {
            TemplateElementNode element = (TemplateElementNode)node;
            String elementName = this.getSoyElementClassName();
            String elementAccessor = elementName + "Interface";
            this.getJsCodeBuilder().appendLine(new String[0]);
            this.getJsCodeBuilder().append(this.generateAccessorInterface(elementAccessor, element));
            this.getJsCodeBuilder().append(GenIncrementalDomCodeVisitor.generateExportsForSoyElement(elementAccessor));
            this.getJsCodeBuilder().append(this.generateRenderInternal(element));
            this.getJsCodeBuilder().appendNullable(this.generateSyncInternal(element));
            this.getJsCodeBuilder().appendNullable(this.generateInitInternalMethod(element));
            if (element.hasExternalClassDefinition()) {
                this.getJsCodeBuilder().append(this.generateSetFieldsForSoyElement(element));
            } else {
                this.getJsCodeBuilder().append(this.generateClassForSoyElement(elementName, elementAccessor, element));
                this.getJsCodeBuilder().append(GenIncrementalDomCodeVisitor.generateExportsForSoyElement(elementName));
            }
        }
    }

    private Statement generateRenderInternal(TemplateElementNode node) {
        String paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + this.alias + ".Params";
        String soyElementClassName = this.getSoyElementClassName();
        boolean isCustomElement = node.hasExternalClassDefinition();
        JsDoc jsDoc = JsDoc.builder().addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer").addParam("opt_data", paramsType).addAnnotation("public").addAnnotation("override").addParameterizedAnnotation("this", isCustomElement ? soyElementClassName + "Import." + node.jsclass : soyElementClassName).addParameterizedAnnotation("suppress", "checkTypes").build();
        Expression fn = Expression.function(jsDoc, Statement.of(VariableDeclaration.builder("$ijData").setRhs(Expression.THIS.dotAccess("ijData")).build(), Statement.of((Iterable)node.getStateVars().stream().map(stateVar -> VariableDeclaration.builder("$$state$$state_" + stateVar.name()).setRhs(Expression.THIS.dotAccess((isCustomElement ? "" : "state_") + stateVar.name())).build()).collect(ImmutableList.toImmutableList())), this.generateIncrementalDomRenderCalls(node, this.alias, false)));
        return VariableDeclaration.builder(soyElementClassName + "Render").setJsDoc(jsDoc).setRhs(fn).build();
    }

    private Statement generateInitInternal(TemplateElementNode node) {
        ImmutableList.Builder stateVarInitializations = ImmutableList.builder();
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        for (TemplateStateVar stateVar : node.getStateVars()) {
            JsType jsType = JsType.forIncrementalDomState(stateVar.type());
            for (GoogRequire require : jsType.getGoogRequires()) {
                jsCodeBuilder.addGoogRequire(require);
            }
            JsDoc stateVarJsdoc = JsDoc.builder().addParameterizedAnnotation("private", jsType.typeExpr()).build();
            Expression rhsValue = SoyTreeUtils.isConstantExpr(stateVar.defaultValue()) ? this.translateExpr(stateVar.defaultValue()) : Expression.LITERAL_UNDEFINED.castAs("?");
            stateVarInitializations.add((Object)Statement.assign(Expression.THIS.dotAccess((node.hasExternalClassDefinition() ? "" : "state_") + stateVar.name()), rhsValue, stateVarJsdoc));
        }
        return Statement.of((Iterable<Statement>)stateVarInitializations.build());
    }

    private Statement generateInitInternalMethod(TemplateElementNode node) {
        if (!node.hasExternalClassDefinition()) {
            return null;
        }
        String soyElementClassName = this.getSoyElementClassName();
        JsDoc jsDoc = JsDoc.builder().addParameterizedAnnotation("this", soyElementClassName + "Import." + node.jsclass).addParameterizedAnnotation("suppress", "checkTypes").build();
        return VariableDeclaration.builder(soyElementClassName + "Init").setJsDoc(jsDoc).setRhs(Expression.function(jsDoc, Statement.of(VariableDeclaration.builder("$ijData").setRhs(Expression.THIS.dotAccess("ijData")).build(), this.generateInitInternal(node)))).build();
    }

    @Nullable
    private Statement generateSyncInternal(TemplateElementNode node) {
        if (!this.hasNonConstantState && !node.hasExternalClassDefinition()) {
            return null;
        }
        String soyElementClassName = this.getSoyElementClassName();
        String paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + this.alias + ".Params";
        boolean isCustomElement = node.hasExternalClassDefinition();
        JsDoc jsDoc = JsDoc.builder().addParam("opt_data", paramsType).addAnnotation("public").addAnnotation("override").addParameterizedAnnotation("this", isCustomElement ? soyElementClassName + "Import." + node.jsclass : soyElementClassName).addParameterizedAnnotation("suppress", "checkTypes").addParam("syncOnlyData", "boolean=").build();
        return VariableDeclaration.builder(soyElementClassName + "SyncInternal").setJsDoc(jsDoc).setRhs(Expression.function(jsDoc, Statement.of(VariableDeclaration.builder("$ijData").setRhs(Expression.THIS.dotAccess("ijData")).build(), this.genSyncStateCalls(node, this.alias)))).build();
    }

    @Override
    protected JsDoc generatePositionalFunctionJsDoc(TemplateNode node) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        this.addInternalCallerParam(jsDocBuilder);
        this.addIjDataParam(jsDocBuilder, true);
        GenIncrementalDomCodeVisitor.maybeAddRenderer(jsDocBuilder, node);
        for (TemplateParam param : this.paramsInOrder(node)) {
            JsType jsType = this.getJsTypeForParamForDeclaration(param.type());
            jsDocBuilder.addParam(this.genParamAlias(param.name()), jsType.typeExpr() + (param.isRequired() ? "" : "="));
        }
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    @Override
    protected JsDoc generateFunctionJsDoc(TemplateNode node, String alias, boolean isDelegate) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        GenIncrementalDomCodeVisitor.maybeAddRenderer(jsDocBuilder, node);
        boolean noRequiredParams = new ShouldEnsureDataIsDefinedVisitor().exec(node);
        if (this.hasOnlyImplicitParams(node)) {
            jsDocBuilder.addParam("opt_data", noRequiredParams ? "?Object<string, *>=" : "null=");
        } else if (noRequiredParams) {
            jsDocBuilder.addParam("opt_data", "?" + alias + ".Params=");
        } else {
            jsDocBuilder.addParam("opt_data", "!" + alias + ".Params");
        }
        this.addIjDataParam(jsDocBuilder, false);
        this.addReturnTypeAndAnnotations(node, jsDocBuilder);
        if (!isDelegate) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        } else if (this.fileSetMetadata.getTemplate(node).getTemplateType().getActualParameters().stream().anyMatch(TemplateType.Parameter::isImplicit)) {
            jsDocBuilder.addParameterizedAnnotation("suppress", "missingProperties");
        }
        return jsDocBuilder.build();
    }

    private static void maybeAddRenderer(JsDoc.Builder jsDocBuilder, TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            jsDocBuilder.addGoogRequire(IncrementalDomRuntime.INCREMENTAL_DOM_LIB);
            jsDocBuilder.addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer");
        }
    }

    @Override
    protected void addIjDataParam(JsDoc.Builder jsDocBuilder, boolean forPositionalSignature) {
        jsDocBuilder.addGoogRequire(JsRuntime.GOOG_SOY_ALIAS);
        if (forPositionalSignature) {
            jsDocBuilder.addParam("$ijData", "!" + JsRuntime.GOOG_SOY_ALIAS.alias() + ".IjData");
        } else {
            jsDocBuilder.addParam("opt_ijData", "?" + JsRuntime.GOOG_SOY_ALIAS.alias() + ".IjData=");
        }
    }

    @Override
    protected ImmutableList<Expression> getFixedParamsToPositionalCall(TemplateNode node) {
        SanitizedContentKind kind = node.getContentKind();
        ImmutableList.Builder params = ImmutableList.builder();
        params.addAll(super.getFixedParamsToPositionalCall(node));
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            params.add((Object)Expression.id("idomRenderer"));
        }
        return params.build();
    }

    @Override
    protected ImmutableList<Expression> templateArguments(TemplateNode node, boolean isPositionalStyle) {
        ImmutableList<Expression> arguments = super.templateArguments(node, isPositionalStyle);
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            return ImmutableList.builder().add((Object)IncrementalDomRuntime.INCREMENTAL_DOM).addAll(arguments).build();
        }
        return arguments;
    }

    @Override
    protected Statement generateFunctionBody(TemplateNode node, String alias, boolean isPositionalStyle) {
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (!isPositionalStyle) {
            bodyStatements.add((Object)this.redeclareIjData());
        } else {
            bodyStatements.add((Object)JsRuntime.SOY_ARE_YOU_AN_INTERNAL_CALLER.call(Expression.id("$$areYouAnInternalCaller")).asStatement());
        }
        bodyStatements.add((Object)this.generateStubbingTest(node, alias, isPositionalStyle));
        if (!isPositionalStyle && new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            bodyStatements.add((Object)Statement.assign(JsRuntime.OPT_DATA, JsRuntime.OPT_DATA.or(Expression.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        if (isPositionalStyle && node instanceof TemplateElementNode) {
            throw new IllegalStateException("elements cannot be compiled into positional style.");
        }
        bodyStatements.add((Object)(node instanceof TemplateElementNode ? this.generateFunctionBodyForSoyElement((TemplateElementNode)node) : this.generateIncrementalDomRenderCalls(node, alias, isPositionalStyle)));
        return Statement.of((Iterable<Statement>)bodyStatements.build());
    }

    private boolean calcHasNonConstantState(TemplateElementNode node) {
        return node.getStateVars().stream().anyMatch(v -> !SoyTreeUtils.isConstantExpr(v.defaultValue()));
    }

    private Statement genSyncStateCalls(TemplateElementNode node, String alias) {
        Expression originalDataSource = this.dataSource;
        this.dataSource = JsRuntime.OPT_DATA;
        Statement typeChecks = this.genParamTypeChecks(node, alias, false);
        Statement dataAssignments = Statement.of(node.hasExternalClassDefinition() ? (Iterable)node.getParams().stream().map(param -> Statement.assign(Expression.THIS.dotAccess(param.name()), Expression.id(param.name()))).collect(ImmutableList.toImmutableList()) : ImmutableList.of());
        ImmutableList<TemplateStateVar> headerVars = node.getStateVars();
        ImmutableMap isNonConst = (ImmutableMap)headerVars.stream().collect(ImmutableMap.toImmutableMap(v -> v, v -> !SoyTreeUtils.isConstantExpr(v.defaultValue())));
        ImmutableList.Builder stateReassignmentBuilder = ImmutableList.builder();
        TemplateStateVar lastNonConstVar = headerVars.reverse().stream().filter(arg_0 -> ((ImmutableMap)isNonConst).get(arg_0)).findFirst().orElse(null);
        boolean haveVisitedLastNonConstVar = lastNonConstVar == null;
        String prefix = node.hasExternalClassDefinition() ? "" : "state_";
        for (TemplateStateVar headerVar : headerVars) {
            if (((Boolean)isNonConst.get((Object)headerVar)).booleanValue()) {
                stateReassignmentBuilder.add((Object)Statement.assign(Expression.THIS.dotAccess(prefix + headerVar.name()), this.translateExpr(headerVar.defaultValue())));
            }
            if (haveVisitedLastNonConstVar = haveVisitedLastNonConstVar || headerVar.equals(lastNonConstVar)) continue;
            stateReassignmentBuilder.add((Object)VariableDeclaration.builder("$$state$$state_" + headerVar.name()).setRhs(Expression.THIS.dotAccess(prefix + headerVar.name())).build());
        }
        ImmutableList assignments = stateReassignmentBuilder.build();
        Statement stateReassignments = Statement.of((Iterable<Statement>)assignments);
        if (node.hasExternalClassDefinition() && !assignments.isEmpty()) {
            stateReassignments = Statement.ifStatement(Expression.not(Expression.id("syncOnlyData")), stateReassignments).build();
        }
        this.dataSource = originalDataSource;
        return Statement.of(typeChecks, dataAssignments, stateReassignments);
    }

    private Statement generateIncrementalDomRenderCalls(TemplateNode node, String alias, boolean isPositionalStyle) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = GenIncrementalDomCodeVisitor.isTextContent(node.getContentKind());
        Statement typeChecks = this.genParamTypeChecks(node, alias, isPositionalStyle);
        if (isTextTemplate) {
            jsCodeBuilder.pushOutputVar("output").setOutputVarInited();
        }
        Statement body = this.visitChildrenReturningCodeChunk(node);
        if (isTextTemplate) {
            VariableDeclaration declare = VariableDeclaration.builder("output").setMutable().setRhs(Expression.LITERAL_EMPTY_STRING).build();
            jsCodeBuilder.popOutputVar();
            body = Statement.of(declare, body, Statement.returnValue(this.sanitize(declare.ref(), node.getContentKind())));
        }
        return Statement.of(typeChecks, body);
    }

    private Statement generateFunctionBodyForSoyElement(TemplateElementNode node) {
        String soyElementClassName = this.getSoyElementClassName();
        String tplName = node.getHtmlElementMetadata().getFinalCallee().isEmpty() ? node.getTemplateName() : node.getHtmlElementMetadata().getFinalCallee();
        Expression firstElementKey = JsRuntime.XID.call(Expression.stringLiteral(tplName + "-root"));
        boolean isCustomElement = node.hasExternalClassDefinition();
        List<Expression> params = Arrays.asList(IncrementalDomRuntime.INCREMENTAL_DOM, isCustomElement ? GoogRequire.createWithAlias(node.jsnamespace, soyElementClassName + "Import").dotAccess(node.jsclass) : Expression.id(soyElementClassName), firstElementKey, isCustomElement ? Expression.id(soyElementClassName + "Import").dotAccess(node.jsclass) : Expression.stringLiteral(node.getHtmlElementMetadata().getTag()), JsRuntime.OPT_DATA, JsRuntime.IJ_DATA, Expression.id(soyElementClassName + "Render"));
        return Statement.of(VariableDeclaration.builder("soyEl").setRhs(IncrementalDomRuntime.SOY_IDOM.dotAccess("$$handleSoyElement").call(params)).build(), Statement.ifStatement(Expression.id("soyEl"), Statement.of(Expression.id("soyEl").dotAccess("renderInternal").call(IncrementalDomRuntime.INCREMENTAL_DOM, isCustomElement ? Expression.id("soyEl") : JsRuntime.OPT_DATA).asStatement(), new Statement[0])).build());
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private Statement generateSetFieldsForSoyElement(TemplateElementNode node) {
        String soyElementClassName = this.getSoyElementClassName();
        List<Expression> params = Arrays.asList(GoogRequire.createWithAlias(node.jsnamespace, soyElementClassName + "Import").dotAccess(node.jsclass), Expression.id(soyElementClassName + "Render"), Expression.id(soyElementClassName + "SyncInternal"), Expression.id(soyElementClassName + "Init"));
        return IncrementalDomRuntime.SOY_IDOM.dotAccess("$$upgrade").call(params).asStatement();
    }

    private VariableDeclaration generateClassForSoyElement(String soyElementClassName, String soyElementAccessorName, TemplateElementNode node) {
        if (node.hasExternalClassDefinition()) {
            return null;
        }
        String paramsType = this.hasOnlyImplicitParams(node) ? "null" : "!" + this.alias + ".Params";
        ImmutableList.Builder stateMethods = ImmutableList.builder();
        for (TemplateStateVar stateVar : node.getStateVars()) {
            stateMethods.addAll(this.generateStateMethodsForSoyElementClass(soyElementClassName, stateVar));
        }
        ImmutableList.Builder parameterMethods = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            parameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(param, false, false));
        }
        ImmutableList.Builder injectedParameterMethods = ImmutableList.builder();
        for (TemplateParam injectedParam : node.getInjectedParams()) {
            injectedParameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(injectedParam, false, true));
        }
        ImmutableList.Builder stateVarInitializations = ImmutableList.builder();
        stateVarInitializations.add((Object)this.generateInitInternal(node));
        if (this.hasNonConstantState) {
            stateVarInitializations.add((Object)Statement.assign(Expression.THIS.dotAccess("syncStateFromData"), Expression.id(soyElementClassName + "SyncInternal")));
        }
        Statement ctorBody = Statement.of(Expression.id("super").call(new Expression[0]).asStatement(), Statement.of((Iterable<Statement>)stateVarInitializations.build()));
        ClassExpression.MethodDeclaration constructorMethod = ClassExpression.MethodDeclaration.create("constructor", JsDoc.builder().build(), ctorBody);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)constructorMethod);
        ClassExpression soyElementClass = ClassExpression.create(IncrementalDomRuntime.SOY_IDOM.dotAccess("$SoyElement"), (ImmutableList<ClassExpression.MethodDeclaration>)builder.addAll((Iterable)stateMethods.build()).addAll((Iterable)parameterMethods.build()).addAll((Iterable)injectedParameterMethods.build()).build());
        String elementAccessor = soyElementClassName + "Interface";
        return VariableDeclaration.builder(soyElementClassName).setJsDoc(JsDoc.builder().addAnnotation("extends", "{soyIdom.$SoyElement<" + paramsType + ",!" + elementAccessor + ">}").addParameterizedAnnotation("implements", soyElementAccessorName).build()).setRhs(soyElementClass).build();
    }

    private VariableDeclaration generateAccessorInterface(String className, TemplateElementNode node) {
        ImmutableList.Builder parameterMethods = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            if (param.isImplicit()) continue;
            parameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(param, true, false));
        }
        ImmutableList.Builder injectedParameterMethods = ImmutableList.builder();
        for (TemplateParam injectedParam : node.getInjectedParams()) {
            injectedParameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(injectedParam, true, true));
        }
        ClassExpression soyElementClass = ClassExpression.create((ImmutableList<ClassExpression.MethodDeclaration>)ImmutableList.builder().addAll((Iterable)parameterMethods.build()).addAll((Iterable)injectedParameterMethods.build()).build());
        return VariableDeclaration.builder(className).setJsDoc(JsDoc.builder().addAnnotation("interface").build()).setRhs(soyElementClass).build();
    }

    private static Statement generateExportsForSoyElement(String soyElementClassName) {
        return Statement.assign(JsRuntime.EXPORTS.dotAccess(soyElementClassName.substring(1)), Expression.id(soyElementClassName));
    }

    private ImmutableList<ClassExpression.MethodDeclaration> generateStateMethodsForSoyElementClass(String soyElementClassName, TemplateStateVar stateVar) {
        JsType jsType = JsType.forIncrementalDomState(stateVar.type());
        String stateAccessorSuffix = Ascii.toUpperCase((String)stateVar.name().substring(0, 1)) + stateVar.name().substring(1);
        Expression stateValue = Expression.id("this").dotAccess("state_" + stateVar.name());
        ClassExpression.MethodDeclaration getStateMethod = ClassExpression.MethodDeclaration.create("get" + stateAccessorSuffix, JsDoc.builder().addParameterizedAnnotation("return", jsType.typeExpr()).build(), Statement.returnValue(stateValue));
        jsType = JsType.forIncrementalDomState(stateVar.type());
        ImmutableList.Builder setStateMethodStatements = ImmutableList.builder();
        Optional<Expression> typeAssertion = jsType.getSoyParamTypeAssertion(Expression.id(stateVar.name()), stateVar.name(), "@state", this.templateTranslationContext.codeGenerator());
        if (typeAssertion.isPresent()) {
            setStateMethodStatements.add((Object)typeAssertion.get().asStatement());
        }
        setStateMethodStatements.add((Object[])new Statement[]{stateValue.assign(Expression.id(stateVar.name())).asStatement(), Statement.returnValue(Expression.id("this"))});
        ClassExpression.MethodDeclaration setStateMethod = ClassExpression.MethodDeclaration.create("set" + stateAccessorSuffix, JsDoc.builder().addParam(stateVar.name(), jsType.typeExpr()).addParameterizedAnnotation("return", "!" + soyElementClassName).build(), Statement.of((Iterable<Statement>)setStateMethodStatements.build()));
        return ImmutableList.of((Object)getStateMethod, (Object)setStateMethod);
    }

    private ClassExpression.MethodDeclaration generateGetParamMethodForSoyElementClass(TemplateParam param, boolean isAbstract, boolean isInjected) {
        JsType jsType = JsType.forIncrementalDomState(param.type());
        String accessorSuffix = Ascii.toUpperCase((String)param.name().substring(0, 1)) + param.name().substring(1);
        if (isAbstract) {
            return ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("abstract").addParameterizedAnnotation("return", jsType.typeExpr()).build(), Statement.of((Iterable<Statement>)ImmutableList.of()));
        }
        Expression value = Expression.id("this").dotAccess(isInjected ? "ijData" : "data").dotAccess(param.name());
        if (param.hasDefault()) {
            value = this.templateTranslationContext.codeGenerator().declarationBuilder().setMutable().setRhs(value).build().ref();
            value = value.withInitialStatement(this.genParamDefault(param, value, jsType, this.templateTranslationContext.codeGenerator()));
        }
        Optional<Expression> typeAssertion = isInjected ? jsType.getSoyParamTypeAssertion(value, param.name(), "@inject", this.templateTranslationContext.codeGenerator()) : Optional.empty();
        return ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("override").addAnnotation("public").build(), Statement.returnValue(typeAssertion.orElse(value)));
    }

    private String getSoyElementClassName() {
        Preconditions.checkState((boolean)this.alias.startsWith("$"), (Object)"Alias should start with '$', or template class name may be malformed.");
        return "$" + Ascii.toUpperCase((char)this.alias.charAt(1)) + this.alias.substring(2) + "Element";
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        Statement definition;
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind prevContentKind = jsCodeBuilder.getContentKind();
        jsCodeBuilder.setContentKind(node.getContentKind());
        VariableDeclaration.Builder builder = VariableDeclaration.builder(generatedVarName);
        SanitizedContentKind kind = node.getContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression constructor = kind.isHtml() ? IncrementalDomRuntime.SOY_IDOM_MAKE_HTML : IncrementalDomRuntime.SOY_IDOM_MAKE_ATTRIBUTES;
            JsDoc jsdoc = JsDoc.builder().addParam("idomRenderer", "incrementaldomlib.IncrementalDomRenderer").build();
            definition = builder.setRhs(constructor.call(Expression.arrowFunction(jsdoc, this.visitChildrenReturningCodeChunk(node)))).build();
        } else {
            String outputVarName = generatedVarName + "_output";
            jsCodeBuilder.pushOutputVar(outputVarName).setOutputVarInited();
            definition = Statement.of(VariableDeclaration.builder(outputVarName).setMutable().setRhs(Expression.LITERAL_EMPTY_STRING).build(), this.visitChildrenReturningCodeChunk(node), builder.setRhs(kind == SanitizedContentKind.TEXT ? Expression.id(outputVarName) : JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(Expression.id(outputVarName))).build());
            jsCodeBuilder.popOutputVar();
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.append(definition);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVar(), Expression.id(generatedVarName));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        Expression call;
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        Optional<SanitizedContentKind> kind = Metadata.getCallContentKind(this.fileSetMetadata, node);
        GenCallCodeUtils.Callee callee = this.genCallCodeUtils.genCallee(node, this.templateAliases, this.getExprTranslator());
        Supplier<Expression> objToPass = () -> this.genCallCodeUtils.genObjToPass(node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator());
        Optional<Supplier<List<Expression>>> positionalParameters = Optional.empty();
        if (this.genCallCodeUtils.canPerformPositionalCall(node)) {
            positionalParameters = Optional.of(() -> this.genCallCodeUtils.getPositionalParams((CallBasicNode)node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator()));
        }
        boolean shouldPushKey = false;
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                if (!kind.isPresent() || kind.get() != SanitizedContentKind.ATTRIBUTES) {
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_ATTRIBUTES.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                    break;
                }
                call = GenIncrementalDomCodeVisitor.directCall(callee, positionalParameters, objToPass, true);
                break;
            }
            case CSS: {
                call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_CSS.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                break;
            }
            case JS: {
                call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_JS.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                break;
            }
            case URI: 
            case TEXT: 
            case HTML_ATTRIBUTE_NAME: 
            case HTML_NORMAL_ATTR_VALUE: {
                Expression textCall = !kind.isPresent() || kind.get() == SanitizedContentKind.ATTRIBUTES || kind.get().isHtml() ? IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_TEXT.call(callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA) : GenIncrementalDomCodeVisitor.directCall(callee, positionalParameters, objToPass, false);
                this.getJsCodeBuilder().addChunkToOutputVar(GenCallCodeUtils.applyEscapingDirectives(textCall, node));
                return;
            }
            default: {
                if (!kind.isPresent() || !kind.get().isHtml()) {
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_HTML.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee.objectStyle(), objToPass.get(), JsRuntime.IJ_DATA);
                    shouldPushKey = true;
                    break;
                }
                call = GenIncrementalDomCodeVisitor.directCall(callee, positionalParameters, objToPass, true);
                shouldPushKey = true;
            }
        }
        String keyVariable = "_keyVariable" + this.staticsCounter++;
        SoyNode.RenderUnitNode renderUnitNode = node.getNearestAncestor(SoyNode.RenderUnitNode.class);
        boolean delegatesToTemplate = false;
        if (renderUnitNode instanceof TemplateNode) {
            TemplateNode template = (TemplateNode)renderUnitNode;
            boolean bl = delegatesToTemplate = template.getHtmlElementMetadata().getIsHtmlElement() && !template.getHtmlElementMetadata().getFinalCallee().isEmpty();
        }
        if (shouldPushKey) {
            if (node.getKeyExpr() != null) {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_MANUAL_KEY.call(this.translateExpr(node.getKeyExpr())));
            } else if (!delegatesToTemplate && !delegatesToTemplate) {
                this.getJsCodeBuilder().append(VariableDeclaration.builder(keyVariable).setRhs(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_KEY.call(JsRuntime.XID.call(Expression.stringLiteral(node.getTemplateCallKey())))).build());
            }
        }
        if (node.getHtmlContext() == HtmlContext.JS) {
            this.getJsCodeBuilder().addChunkToOutputVar(call);
        } else {
            this.getJsCodeBuilder().append(call);
        }
        if (shouldPushKey) {
            if (node.getKeyExpr() != null) {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_POP_MANUAL_KEY.call(new Expression[0]));
            } else if (!delegatesToTemplate) {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_POP_KEY.call(Expression.id(keyVariable)));
            }
        }
    }

    private static Expression directCall(GenCallCodeUtils.Callee callee, Optional<Supplier<List<Expression>>> positionalParameters, Supplier<Expression> paramObject, boolean isIdomCall) {
        ArrayList<Expression> params = new ArrayList<Expression>();
        if (isIdomCall) {
            params.add(IncrementalDomRuntime.INCREMENTAL_DOM);
        }
        if (positionalParameters.isPresent()) {
            params.add(0, JsRuntime.IJ_DATA);
            params.add(0, JsRuntime.SOY_INTERNAL_CALL_MARKER);
            params.addAll((Collection)positionalParameters.get().get());
            return callee.positionalStyle().get().call(params);
        }
        params.add(paramObject.get());
        params.add(JsRuntime.IJ_DATA);
        return callee.objectStyle().call(params);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind currentContentKind = jsCodeBuilder.getContentKind();
        if (!GenIncrementalDomCodeVisitor.isTextContent(currentContentKind)) {
            super.generateNonExpressionIfNode(node);
        } else {
            super.visitIfNode(node);
        }
    }

    private static boolean isTextContent(SanitizedContentKind contentKind) {
        return !contentKind.isHtml() && contentKind != SanitizedContentKind.ATTRIBUTES;
    }

    @Override
    protected TranslateExprNodeVisitor getExprTranslator() {
        return new IncrementalDomTranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.templateAliases, this.errorReporter, this.dataSource);
    }

    @Override
    protected void visitHtmlCommentNode(HtmlCommentNode node) {
        String id = "html_comment_" + node.getId();
        this.getJsCodeBuilder().append(VariableDeclaration.builder(id).setMutable().setRhs(Expression.LITERAL_EMPTY_STRING).build());
        this.getJsCodeBuilder().pushOutputVar(id).setOutputVarInited();
        SanitizedContentKind prev = this.getJsCodeBuilder().getContentKind();
        this.getJsCodeBuilder().setContentKind(SanitizedContentKind.TEXT);
        for (int i = 0; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_VISIT_HTML_COMMENT.call(IncrementalDomRuntime.INCREMENTAL_DOM, Expression.id(id)));
        this.getJsCodeBuilder().popOutputVar();
        this.getJsCodeBuilder().setContentKind(prev);
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.hasValue()) {
            Preconditions.checkState((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node.getChild(0))));
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(this.genJsExprsVisitor.exec((SoyNode)node.getChild(0)).get(0), CodeChunkUtils.concatChunksForceString(this.getAttributeValues(node))));
        } else {
            this.visitChildren(node);
        }
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.visitChildren(node);
    }

    private List<Expression> getAttributeValues(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return ImmutableList.of((Object)Expression.LITERAL_EMPTY_STRING);
        }
        SoyNode.ParentSoyNode value = (SoyNode.ParentSoyNode)node.getChild(1);
        String outputVar = "html_attribute_" + node.getId();
        boolean needsToBeCoerced = false;
        for (SoyNode n : value.getChildren()) {
            if (!(n instanceof CallNode)) continue;
            Optional<SanitizedContentKind> kind = Metadata.getCallContentKind(this.fileSetMetadata, (CallNode)n);
            needsToBeCoerced = !kind.isPresent() || kind.get().isHtml() || kind.get() == SanitizedContentKind.ATTRIBUTES;
        }
        if (!this.isComputableAsJsExprsVisitor.execOnChildren(value).booleanValue() || needsToBeCoerced) {
            this.getJsCodeBuilder().pushOutputVar(outputVar).setOutputVarInited();
            SanitizedContentKind prev = this.getJsCodeBuilder().getContentKind();
            this.getJsCodeBuilder().setContentKind(SanitizedContentKind.TEXT);
            IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
            jsCodeBuilder.append(VariableDeclaration.builder(outputVar).setMutable().setRhs(Expression.LITERAL_EMPTY_STRING).build());
            this.visit(value);
            this.getJsCodeBuilder().popOutputVar();
            this.getJsCodeBuilder().setContentKind(prev);
            return ImmutableList.of((Object)Expression.id(outputVar));
        }
        return this.genJsExprsVisitor.exec(value);
    }

    private ImmutableMap<String, Expression> getStaticAttributes(HtmlOpenTagNode node) {
        ArrayList<HtmlAttributeNode> nodesToRemove = new ArrayList<HtmlAttributeNode>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 1; i < node.numChildren(); ++i) {
            if (!(node.getChild(i) instanceof HtmlAttributeNode)) continue;
            HtmlAttributeNode attrNode = (HtmlAttributeNode)node.getChild(i);
            String attributeKey = attrNode.getStaticKey();
            Expression value = this.getStaticContent(attrNode);
            if (attributeKey == null || value == null) continue;
            nodesToRemove.add(attrNode);
            builder.put((Object)attributeKey, (Object)value);
        }
        for (HtmlAttributeNode child : nodesToRemove) {
            node.removeChild(child);
        }
        return builder.build();
    }

    private Expression getStaticContent(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return Expression.stringLiteral("");
        }
        if (!(node.getChild(1) instanceof HtmlAttributeValueNode)) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)node.getChild(1);
        if (attrValue.numChildren() == 0) {
            return Expression.stringLiteral("");
        }
        for (int i = 0; i < attrValue.numChildren(); ++i) {
            if (attrValue.getChild(i) instanceof RawTextNode) continue;
            if (attrValue.getChild(i) instanceof PrintNode) {
                PrintNode n = (PrintNode)attrValue.getChild(i);
                if (n.getExpr().getRoot() instanceof FunctionNode) {
                    FunctionNode fnNode = (FunctionNode)n.getExpr().getRoot();
                    if (fnNode.getSoyFunction() == BuiltinFunction.XID || fnNode.getSoyFunction() == BuiltinFunction.CSS) continue;
                    return null;
                }
                return null;
            }
            return null;
        }
        return CodeChunkUtils.concatChunksForceString(this.getAttributeValues(node));
    }

    private Expression getOpenSSRCall(HtmlOpenTagNode node) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.getTagNameCodeChunk(node.getTagName()));
        KeyNode keyNode = node.getKeyNode();
        if (keyNode == null) {
            args.add(JsRuntime.XID.call(Expression.stringLiteral(node.getKeyId())));
        } else {
            args.add(this.translateExpr(node.getKeyNode().getExpr()));
        }
        if (node.isElementRoot()) {
            Expression paramsObject = this.generatePositionalParamsSignature ? Expression.arrayLiteral((Iterable)node.getNearestAncestor(TemplateNode.class).getParams().stream().map(p -> Expression.id(this.genParamAlias(p.name()))).collect(ImmutableList.toImmutableList())) : JsRuntime.OPT_DATA;
            args.add(Expression.ifExpression(JsRuntime.GOOG_DEBUG, paramsObject).setElse(Expression.LITERAL_UNDEFINED).build(this.templateTranslationContext.codeGenerator()));
        }
        return IncrementalDomRuntime.INCREMENTAL_DOM_OPEN_SSR.call(args);
    }

    private Expression getOpenCall(HtmlOpenTagNode node) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.getTagNameCodeChunk(node.getTagName()));
        KeyNode keyNode = node.getKeyNode();
        Expression key = Expression.LITERAL_UNDEFINED;
        if (keyNode == null) {
            key = JsRuntime.XID.call(Expression.stringLiteral(node.getKeyId()));
        }
        args.add(key);
        return IncrementalDomRuntime.INCREMENTAL_DOM_OPEN.call(args);
    }

    private Optional<Expression> getApplyStaticAttributes(HtmlOpenTagNode node) {
        ImmutableMap<String, Expression> staticAttributes = this.getStaticAttributes(node);
        ImmutableList.Builder staticsBuilder = ImmutableList.builder();
        for (Map.Entry entry : staticAttributes.entrySet()) {
            staticsBuilder.add((Object)Expression.stringLiteral((String)entry.getKey()));
            staticsBuilder.add((Object)((Expression)entry.getValue()));
        }
        if (!staticAttributes.isEmpty()) {
            String id = "_statics_" + this.staticsCounter++;
            Expression idExpr = Expression.id(this.alias + id);
            Expression lazyAssignment = idExpr.or(idExpr.assign(Expression.arrayLiteral((Iterable<? extends Expression>)staticsBuilder.build())), null);
            this.staticVarDeclarations.add(VariableDeclaration.builder(this.alias + id).build());
            return Optional.of(IncrementalDomRuntime.INCREMENTAL_DOM_APPLY_STATICS.call(lazyAssignment));
        }
        return Optional.empty();
    }

    private Expression getApplyAttrs(HtmlOpenTagNode node) {
        for (int i = 1; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        return IncrementalDomRuntime.INCREMENTAL_DOM_APPLY_ATTRS.call(new Expression[0]);
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        this.getJsCodeBuilder().appendLine("// " + node.getSourceLocation());
        if (!node.isSkipRoot()) {
            if (node.getKeyNode() != null) {
                Expression key = this.translateExpr(node.getKeyNode().getExpr());
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_MANUAL_KEY.call(key));
            }
            Expression openTagExpr = this.getOpenCall(node);
            jsCodeBuilder.append(openTagExpr.asStatement());
        }
        jsCodeBuilder.append(this.getAttributeAndCloseCalls(node));
        String tagName = node.getTagName().getTagString();
        if (tagName != null && Ascii.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            this.scriptOutputVar = "script_" + this.staticsCounter++;
            jsCodeBuilder.pushOutputVar(this.scriptOutputVar).setOutputVarInited();
            jsCodeBuilder.appendLine("let ", this.scriptOutputVar, " = '';");
            jsCodeBuilder.setContentKind(SanitizedContentKind.JS);
        }
    }

    private Statement getAttributeAndCloseCalls(HtmlOpenTagNode node) {
        Expression close;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        Optional<Expression> maybeApplyStatics = this.getApplyStaticAttributes(node);
        Expression expression = close = node.isElementRoot() ? IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE : IncrementalDomRuntime.INCREMENTAL_DOM_CLOSE;
        if (maybeApplyStatics.isPresent()) {
            statements.add(maybeApplyStatics.get().asStatement());
        }
        statements.add(this.getApplyAttrs(node).asStatement());
        if (node.isSelfClosing() || node.getTagName().isDefinitelyVoid()) {
            statements.add(close.call(new Expression[0]).asStatement());
        }
        return Statement.of(statements);
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        HtmlOpenTagNode openTag;
        this.getJsCodeBuilder().appendLine("// " + node.getSourceLocation());
        String tagName = node.getTagName().getTagString();
        if (tagName != null && Ascii.equalsIgnoreCase((CharSequence)tagName, (CharSequence)"script")) {
            this.getJsCodeBuilder().popOutputVar();
            Expression ordainer = Expression.id("soy").dotAccess("VERY_UNSAFE").dotAccess("ordainSanitizedJs");
            Expression safeScript = ordainer.call(Expression.id(this.scriptOutputVar)).dotAccess("toSafeScript").call(new Expression[0]);
            GoogRequire require = GoogRequire.createWithAlias("goog.html.SafeScript", "SafeScript");
            Expression unwrapped = require.dotAccess("unwrapTrustedScript").call(safeScript);
            Expression currentElement = IncrementalDomRuntime.INCREMENTAL_DOM.dotAccess("currentElement").call(new Expression[0]);
            this.getJsCodeBuilder().append(currentElement.dotAccess("textContent").assign(unwrapped));
            this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM.dotAccess("skipNode").call(new Expression[0]));
            this.getJsCodeBuilder().setContentKind(SanitizedContentKind.HTML);
        }
        if (node.getTaggedPairs().size() == 1 && (openTag = (HtmlOpenTagNode)node.getTaggedPairs().get(0)).getKeyNode() != null && !(openTag.getParent() instanceof SkipNode)) {
            this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_POP_MANUAL_KEY.call(new Expression[0]));
        }
        Expression close = IncrementalDomRuntime.INCREMENTAL_DOM_CLOSE;
        if (node.getTaggedPairs().size() == 1 && ((HtmlOpenTagNode)node.getTaggedPairs().get(0)).isElementRoot()) {
            close = IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE;
        }
        if (!node.getTagName().isDefinitelyVoid()) {
            this.getJsCodeBuilder().append(close.call(new Expression[0]).asStatement());
        }
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        Expression textArg = Expression.stringLiteral(node.getRawText());
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        switch (node.getHtmlContext()) {
            case CSS: 
            case HTML_RCDATA: 
            case HTML_PCDATA: {
                jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(textArg));
                break;
            }
            case HTML_TAG: {
                jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(textArg, Expression.stringLiteral("")));
                break;
            }
            default: {
                jsCodeBuilder.addChunkToOutputVar(textArg);
            }
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        List<Expression> chunks = this.genJsExprsVisitor.exec(node);
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT_DYNAMIC_ATTR.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks)));
                break;
            }
            case JS: {
                this.getJsCodeBuilder().addChunkToOutputVar(CodeChunkUtils.concatChunks(chunks));
                break;
            }
            case CSS: 
            case HTML_PCDATA: {
                if (node.numChildren() > 0 && ((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective() instanceof SanitizedContentOperator && ((SanitizedContentOperator)((Object)((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective())).getContentKind() == SanitizedContent.ContentKind.HTML) {
                    this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks), Expression.LITERAL_TRUE));
                    break;
                }
                this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks)));
                break;
            }
            case HTML_RCDATA: {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expression.id("String").call(CodeChunkUtils.concatChunks(chunks))));
                break;
            }
            default: {
                super.visitPrintNode(node);
            }
        }
    }

    @Override
    protected void visitSkipNode(SkipNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        HtmlOpenTagNode openTag = (HtmlOpenTagNode)node.getChild(0);
        Expression openTagExpr = this.getOpenSSRCall(openTag);
        Statement childStatements = this.visitChildrenReturningCodeChunk(node);
        jsCodeBuilder.append(Statement.ifStatement(openTagExpr, Statement.of(childStatements, new Statement[0])).build());
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        VeLogStateHolder state = this.openVeLogNode(node);
        this.getJsCodeBuilder().append(state.enterStatement);
        this.visitChildren(node);
        this.getJsCodeBuilder().append(this.exitVeLogNode(node, state.logOnlyConditional));
    }

    VeLogStateHolder openVeLogNode(VeLogNode node) {
        Expression isLogOnly = Expression.LITERAL_FALSE;
        VariableDeclaration isLogOnlyVar = null;
        Expression isLogOnlyReference = null;
        ArrayList<Statement> stmts = new ArrayList<Statement>();
        if (node.getLogonlyExpression() != null) {
            String idName = "velog_" + this.staticsCounter++;
            isLogOnlyReference = Expression.id(idName);
            isLogOnly = (Expression)this.getExprTranslator().exec(node.getLogonlyExpression());
            isLogOnlyVar = VariableDeclaration.builder(idName).setRhs(isLogOnly).build();
            stmts.add(isLogOnlyVar);
            stmts.add(Statement.ifStatement(IncrementalDomRuntime.INCREMENTAL_DOM_VERIFY_LOGONLY.call(isLogOnlyVar.ref()), Statement.assign(IncrementalDomRuntime.INCREMENTAL_DOM, IncrementalDomRuntime.INCREMENTAL_DOM_TONULL.call(new Expression[0]))).build());
        }
        Expression veData = (Expression)this.getExprTranslator().exec(node.getVeDataExpression());
        stmts.add(IncrementalDomRuntime.INCREMENTAL_DOM_ENTER.call(veData, isLogOnly).asStatement());
        return new VeLogStateHolder(isLogOnlyReference, Statement.of(stmts));
    }

    Statement exitVeLogNode(VeLogNode node, @Nullable Expression isLogOnly) {
        Statement exit = IncrementalDomRuntime.INCREMENTAL_DOM_EXIT.call(new Expression[0]).asStatement();
        if (isLogOnly != null) {
            return Statement.of(exit, Statement.ifStatement(isLogOnly, Statement.assign(IncrementalDomRuntime.INCREMENTAL_DOM, IncrementalDomRuntime.INCREMENTAL_DOM_TODEFAULT.call(new Expression[0]))).build());
        }
        return exit;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                String id = "_msg_" + this.alias + "_" + this.staticsCounter++;
                VariableDeclaration staticDecl = VariableDeclaration.builder(id).setRhs(Expression.objectLiteral((Map<String, Expression>)ImmutableMap.of())).build();
                this.staticVarDeclarations.add(staticDecl);
                CodeChunk chunk = new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter, id).generateMsgGroupCode(node);
                this.getJsCodeBuilder().append(chunk);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                Expression msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(msgExpression));
                break;
            }
            case HTML_RCDATA: {
                Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expression.id("String").call(msgExpression)));
                break;
            }
            default: {
                Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(msgExpression);
            }
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    private Expression getTagNameCodeChunk(TagName tagName) {
        return this.genJsExprsVisitor.exec(tagName.getNode()).get(0);
    }

    @Override
    protected boolean isIncrementalDom() {
        return true;
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
            super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
        }

        @Override
        protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
            Expression toEscape = super.genGoogMsgPlaceholder(msgPhNode);
            return JsRuntime.SOY_ESCAPE_HTML.call(toEscape);
        }
    }

    static class VeLogStateHolder {
        Expression logOnlyConditional;
        Statement enterStatement;

        public VeLogStateHolder(Expression logOnlyConditional, Statement enterStatement) {
            this.logOnlyConditional = logOnlyConditional;
            this.enterStatement = enterStatement;
        }
    }
}

