/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.TemplateContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.TemplateType;

public class IncrementalDomTranslateExprNodeVisitor
extends TranslateExprNodeVisitor {
    private static final ImmutableSet<SoyType.Kind> FUNCTION_TYPES = Sets.immutableEnumSet((Enum)SoyType.Kind.HTML, (Enum[])new SoyType.Kind[]{SoyType.Kind.ELEMENT, SoyType.Kind.ATTRIBUTES, SoyType.Kind.UNKNOWN, SoyType.Kind.ANY});

    public IncrementalDomTranslateExprNodeVisitor(JavaScriptValueFactoryImpl javaScriptValueFactory, TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter, Expression dataSource) {
        super(javaScriptValueFactory, translationContext, templateAliases, errorReporter, dataSource);
    }

    @Override
    protected Expression genCodeForStateAccess(String paramName, TemplateStateVar stateVar) {
        return Expression.id("$$state$$state_" + paramName);
    }

    @Override
    protected Expression sanitizedContentToProtoConverterFunction(Descriptors.Descriptor messageType) {
        return (Expression)IncrementalDomRuntime.IDOM_JS_TO_PROTO_PACK_FN.get((Object)messageType.getFullName());
    }

    @Override
    protected Expression visitFunctionNode(FunctionNode node) {
        if (node.getSoyFunction() instanceof LoggingFunction) {
            LoggingFunction loggingNode = (LoggingFunction)node.getSoyFunction();
            return IncrementalDomRuntime.INCREMENTAL_DOM_EVAL_LOG_FN.call(JsRuntime.XID.call(Expression.stringLiteral(node.getStaticFunctionName())), Expression.arrayLiteral(this.visitChildren(node)), Expression.stringLiteral(loggingNode.getPlaceholder()));
        }
        return super.visitFunctionNode(node);
    }

    @Override
    protected Expression genCodeForBind(Expression template, Expression paramRecord, SoyType templateType) {
        SanitizedContentKind kind = ((TemplateContentKind)Iterables.getOnlyElement((Iterable)((Iterable)SoyTypes.expandUnions(templateType).stream().map(type -> ((TemplateType)type).getContentKind()).collect(ImmutableSet.toImmutableSet())))).getSanitizedContentKind();
        if (kind.isHtml() || kind == SanitizedContentKind.ATTRIBUTES) {
            return JsRuntime.BIND_TEMPLATE_PARAMS_FOR_IDOM.call(template, paramRecord);
        }
        return super.genCodeForBind(template, paramRecord, templateType);
    }

    @Override
    protected Expression visitProtoEnumValueNode(ProtoEnumValueNode node) {
        JsType type = JsType.forJsSrcStrict(SoyTypes.removeNull(node.getType()));
        return Expression.number(node.getValue()).castAs(type.typeExpr(), type.getGoogRequires());
    }

    @Override
    protected Expression maybeCoerceToBoolean(SoyType type, Expression chunk, boolean force) {
        if (SoyTypes.containsKinds(type, FUNCTION_TYPES)) {
            return IncrementalDomRuntime.SOY_IDOM_IS_TRUTHY.call(chunk);
        }
        return super.maybeCoerceToBoolean(type, chunk, force);
    }

    @Override
    protected JsType jsTypeFor(SoyType type) {
        return JsType.forIncrementalDomState(type);
    }
}

