/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_DetachState_ReattachState;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.objectweb.asm.Label;

final class DetachState
implements ExpressionDetacher.Factory {
    private final TemplateVariableManager variables;
    private final List<ReattachState> reattaches = new ArrayList<ReattachState>();
    private final Supplier<RenderContextExpression> renderContextExpression;
    int disabledCount;

    DetachState(TemplateVariableManager variables, Supplier<RenderContextExpression> renderContextExpression) {
        this.variables = variables;
        this.renderContextExpression = renderContextExpression;
    }

    NoNewDetaches expectNoNewDetaches() {
        ++this.disabledCount;
        return () -> {
            --this.disabledCount;
            if (this.disabledCount < 0) {
                throw new AssertionError();
            }
        };
    }

    private void checkDetachesAllowed() {
        if (this.disabledCount > 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public ExpressionDetacher createExpressionDetacher(Label reattachPoint) {
        return new ExpressionDetacher.BasicDetacher(() -> this.addState(reattachPoint));
    }

    Statement detachLimited(AppendableExpression appendable) {
        this.checkDetachesAllowed();
        this.variables.assertSaveRestoreStateIsEmpty();
        if (!appendable.supportsSoftLimiting()) {
            return appendable.toStatement();
        }
        final Expression isSoftLimited = appendable.softLimitReached();
        final Statement returnLimited = Statement.returnExpression(MethodRef.RENDER_RESULT_LIMITED.invoke(new Expression[0]));
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                Label continueLabel = new Label();
                isSoftLimited.gen(adapter);
                adapter.ifZCmp(153, continueLabel);
                returnLimited.gen(adapter);
                adapter.mark(continueLabel);
            }
        };
    }

    Statement assertFullyRenderered(Expression render) {
        return render.invokeVoid(MethodRef.RENDER_RESULT_ASSERT_DONE, new Expression[0]);
    }

    Statement detachForRender(final Expression render) {
        this.checkDetachesAllowed();
        Preconditions.checkArgument((boolean)render.resultType().equals((Object)BytecodeUtils.RENDER_RESULT_TYPE));
        final Label reattachPoint = new Label();
        final Statement saveState = this.addState(reattachPoint);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                adapter.mark(reattachPoint);
                render.gen(adapter);
                adapter.dup();
                MethodRef.RENDER_RESULT_IS_DONE.invokeUnchecked(adapter);
                Label end = new Label();
                adapter.ifZCmp(154, end);
                saveState.gen(adapter);
                adapter.returnValue();
                adapter.mark(end);
                adapter.pop();
            }
        };
    }

    Statement generateReattachTable() {
        if (this.reattaches.isEmpty()) {
            return Statement.NULL_STATEMENT;
        }
        final LocalVariable stackFrameVar = this.variables.getStackFrameVar();
        Statement initStackFrame = stackFrameVar.store(this.renderContextExpression.get().popFrame()).labelStart(stackFrameVar.start());
        final Expression readStateNumber = FieldRef.STACK_FRAME_STATE_NUMBER.accessor(stackFrameVar);
        final Label unexpectedState = new Label();
        Label end = new Label();
        final ArrayList<Label> caseLabels = new ArrayList<Label>();
        ArrayList<Statement> casesToGen = new ArrayList<Statement>();
        caseLabels.add(end);
        for (final ReattachState reattachState : this.reattaches) {
            if (reattachState.restoreStatement().isPresent()) {
                final Label caseLabel = new Label();
                casesToGen.add(new Statement(){

                    @Override
                    protected void doGen(CodeBuilder cb) {
                        cb.mark(caseLabel);
                        reattachState.restoreStatement().get().gen(cb);
                        cb.goTo(reattachState.reattachPoint());
                    }
                });
                caseLabels.add(caseLabel);
                continue;
            }
            caseLabels.add(reattachState.reattachPoint());
        }
        casesToGen.add(Statement.throwExpression(MethodRef.RUNTIME_UNEXPECTED_STATE_ERROR.invoke(stackFrameVar)).labelStart(unexpectedState));
        return Statement.concat(initStackFrame, new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                readStateNumber.gen(adapter);
                adapter.mark(stackFrameVar.end());
                adapter.visitTableSwitchInsn(0, DetachState.this.reattaches.size(), unexpectedState, caseLabels.toArray(new Label[0]));
            }
        }, Statement.concat(casesToGen)).labelEnd(end);
    }

    private Statement addState(Label reattachPoint) {
        this.checkDetachesAllowed();
        int stateNumber = this.reattaches.size() + 1;
        TemplateVariableManager.SaveRestoreState saveRestoreState = this.variables.saveRestoreState(this.renderContextExpression.get(), stateNumber);
        ReattachState create = ReattachState.create(reattachPoint, saveRestoreState.restore());
        this.reattaches.add(create);
        return saveRestoreState.save();
    }

    int getNumberOfDetaches() {
        return this.reattaches.size();
    }

    @AutoValue
    static abstract class ReattachState {
        ReattachState() {
        }

        static ReattachState create(Label reattachPoint, Optional<Statement> restore) {
            return new AutoValue_DetachState_ReattachState(reattachPoint, restore);
        }

        abstract Label reattachPoint();

        abstract Optional<Statement> restoreStatement();
    }

    static interface NoNewDetaches
    extends AutoCloseable {
        @Override
        public void close();
    }
}

