/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;
import com.google.template.soy.jbcsrc.AutoValue_SoyFileCompiler_TypeWriter;
import com.google.template.soy.jbcsrc.ConstantsCompiler;
import com.google.template.soy.jbcsrc.ExternCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JavaSourceFunctionCompiler;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SoyFileCompiler {
    private final SoyFileNode fileNode;
    private final JavaSourceFunctionCompiler javaSourceFunctionCompiler;
    private final PartialFileSetMetadata fileSetMetadata;

    SoyFileCompiler(SoyFileNode fileNode, JavaSourceFunctionCompiler javaSourceFunctionCompiler, PartialFileSetMetadata fileSetMetadata) {
        this.fileNode = fileNode;
        this.javaSourceFunctionCompiler = javaSourceFunctionCompiler;
        this.fileSetMetadata = fileSetMetadata;
    }

    ImmutableList<ClassData> compile() {
        if (this.fileNode.isEmpty()) {
            return ImmutableList.of();
        }
        if (NamespaceExemptions.isKnownDuplicateNamespace(this.fileNode.getNamespace())) {
            return this.compileToManyClasses();
        }
        return this.compileToSingleClass();
    }

    private ImmutableList<ClassData> compileToManyClasses() {
        Preconditions.checkArgument((boolean)this.fileNode.getConstants().isEmpty());
        Preconditions.checkArgument((boolean)this.fileNode.getExterns().isEmpty());
        List writers = this.fileNode.getTemplates().stream().map(templateNode -> {
            TypeWriter typeWriter = TypeWriter.create(templateNode);
            new TemplateCompiler((TemplateNode)templateNode, typeWriter.writer(), typeWriter.fields(), typeWriter.innerClasses(), this.javaSourceFunctionCompiler, this.fileSetMetadata).compile();
            return typeWriter;
        }).collect(Collectors.toList());
        return (ImmutableList)writers.stream().flatMap(TypeWriter::close).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ClassData> compileToSingleClass() {
        TypeWriter typeWriter = TypeWriter.create(this.fileNode);
        this.fileNode.getChildren().forEach(c -> {
            if (c instanceof ConstNode) {
                new ConstantsCompiler((ConstNode)c, typeWriter.writer(), this.javaSourceFunctionCompiler, this.fileSetMetadata).compile();
            } else if (c instanceof ExternNode) {
                new ExternCompiler((ExternNode)c, typeWriter.writer()).compile();
            } else if (c instanceof TemplateNode) {
                new TemplateCompiler((TemplateNode)c, typeWriter.writer(), typeWriter.fields(), typeWriter.innerClasses(), this.javaSourceFunctionCompiler, this.fileSetMetadata).compile();
            }
        });
        return (ImmutableList)typeWriter.close().collect(ImmutableList.toImmutableList());
    }

    @AutoValue
    static abstract class TypeWriter {
        TypeWriter() {
        }

        static TypeWriter create(SoyFileNode node) {
            TypeInfo fileType = TypeInfo.createClass(Names.javaClassNameFromSoyNamespace(node.getNamespace()));
            return TypeWriter.create(fileType, node);
        }

        static TypeWriter create(TemplateNode node) {
            TypeInfo fileType = TypeInfo.createClass(Names.javaClassNameFromSoyTemplateName(node.getTemplateName()));
            return TypeWriter.create(fileType, node.getParent());
        }

        static TypeWriter create(TypeInfo type, SoyFileNode node) {
            FieldManager fields = new FieldManager(type);
            InnerClasses innerClasses = new InnerClasses(type);
            SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(49).sourceFileName(node.getFileName()).build();
            return new AutoValue_SoyFileCompiler_TypeWriter(writer, fields, innerClasses);
        }

        abstract SoyClassWriter writer();

        abstract FieldManager fields();

        abstract InnerClasses innerClasses();

        Stream<ClassData> close() {
            this.innerClasses().registerAllInnerClasses(this.writer());
            this.fields().defineFields(this.writer());
            this.fields().defineStaticInitializer(this.writer());
            this.writer().visitEnd();
            return Stream.concat(Stream.of(this.writer().toClassData()), this.innerClasses().getInnerClassData().stream());
        }
    }
}

