/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class TemplateAnalysisImpl
implements TemplateAnalysis {
    private final AccessGraph templateGraph;
    private final ImmutableSet<ExprNode> resolvedExpressions;

    static TemplateAnalysisImpl analyze(TemplateNode node) {
        AccessGraph templateGraph = new PseudoEvaluatorVisitor().evaluate(node);
        return new TemplateAnalysisImpl(templateGraph);
    }

    private TemplateAnalysisImpl(AccessGraph templateGraph) {
        this.templateGraph = templateGraph;
        this.resolvedExpressions = templateGraph != null ? ImmutableSet.copyOf(templateGraph.getResolvedExpressions()) : ImmutableSet.of();
    }

    @VisibleForTesting
    String dumpGraph() {
        return this.templateGraph.toString();
    }

    @Override
    public boolean isResolved(VarRefNode ref) {
        return this.resolvedExpressions.contains((Object)ref);
    }

    @Override
    public boolean isResolved(DataAccessNode ref) {
        return this.resolvedExpressions.contains((Object)ref);
    }

    private static StaticAnalysisResult isListExpressionEmpty(ForNode node) {
        Optional<RangeArgs> rangeArgs = RangeArgs.createFromNode(node);
        if (rangeArgs.isPresent()) {
            return TemplateAnalysisImpl.isRangeExpressionEmpty(rangeArgs.get());
        }
        ExprNode expr = node.getExpr().getRoot();
        if (expr instanceof ListLiteralNode) {
            return ((ListLiteralNode)expr).numChildren() > 0 ? StaticAnalysisResult.FALSE : StaticAnalysisResult.TRUE;
        }
        return StaticAnalysisResult.UNKNOWN;
    }

    private static StaticAnalysisResult isRangeExpressionEmpty(RangeArgs range) {
        long limitAsLong;
        int start = 0;
        if (range.start().isPresent()) {
            if (range.start().get() instanceof IntegerNode) {
                long startAsLong = ((IntegerNode)range.start().get()).getValue();
                if (startAsLong != (long)((int)startAsLong)) {
                    return StaticAnalysisResult.UNKNOWN;
                }
                start = (int)startAsLong;
            } else {
                return StaticAnalysisResult.UNKNOWN;
            }
        }
        if (range.limit() instanceof IntegerNode) {
            limitAsLong = ((IntegerNode)range.limit()).getValue();
            if (limitAsLong != (long)((int)limitAsLong)) {
                return StaticAnalysisResult.UNKNOWN;
            }
        } else {
            return StaticAnalysisResult.UNKNOWN;
        }
        int limit = (int)limitAsLong;
        int step = 1;
        if (range.increment().isPresent()) {
            if (range.increment().get() instanceof IntegerNode) {
                long stepAsLong = ((IntegerNode)range.increment().get()).getValue();
                if (stepAsLong != (long)((int)stepAsLong)) {
                    return StaticAnalysisResult.UNKNOWN;
                }
                step = (int)stepAsLong;
            } else {
                return StaticAnalysisResult.UNKNOWN;
            }
        }
        return JbcSrcRuntime.rangeLoopLength(start, limit, step) > 0 ? StaticAnalysisResult.FALSE : StaticAnalysisResult.TRUE;
    }

    private static void addPredecessors(Block start) {
        TemplateAnalysisImpl.dfsPreOrder(start, current -> {
            for (Block successor : current.successors) {
                successor.predecessors.add((Block)current);
            }
        });
    }

    private static void eliminateUnconditionalBranches(Block start, Block end) {
        TemplateAnalysisImpl.dfsPreOrder(start, current -> {
            if (current == end) {
                return;
            }
            if (current.predecessors.size() == 1) {
                Block predecessor = (Block)Iterables.getOnlyElement(current.predecessors);
                if (predecessor.successors.size() == 1) {
                    predecessor.exprs.addAll(current.exprs);
                    predecessor.successors.clear();
                    predecessor.successors.addAll(current.successors);
                    for (Block successor : current.successors) {
                        successor.predecessors.remove(current);
                        successor.predecessors.add(predecessor);
                    }
                }
            }
        });
    }

    private static void eliminateEmptyNodes(Block start, Block end) {
        TemplateAnalysisImpl.dfsPreOrder(start, current -> {
            if (current == end || current == start) {
                return;
            }
            if (current.exprs.isEmpty()) {
                for (Block pred : current.predecessors) {
                    pred.successors.remove(current);
                    pred.successors.addAll(current.successors);
                }
                for (Block succ : current.successors) {
                    succ.predecessors.remove(current);
                    succ.predecessors.addAll(current.predecessors);
                }
            }
        });
    }

    private static void dfsPreOrder(Block node, Consumer<Block> fn) {
        Set visited = Sets.newIdentityHashSet();
        ArrayDeque<Block> stack = new ArrayDeque<Block>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Block current = (Block)stack.pop();
            if (!visited.add(current)) continue;
            for (Block successor : current.successors) {
                stack.push(successor);
            }
            fn.accept(current);
        }
    }

    private static final class Block {
        final List<ExprNode> exprs = new ArrayList<ExprNode>();
        final Set<Block> successors = new LinkedHashSet<Block>();
        final Set<Block> predecessors = new LinkedHashSet<Block>();

        private Block() {
        }

        static Block merge(Block ... preds) {
            return Block.merge(Arrays.asList(preds));
        }

        static Block merge(List<Block> preds) {
            Block end = new Block();
            for (Block pred : preds) {
                pred.successors.add(end);
            }
            return end;
        }

        void add(VarRefNode var) {
            this.exprs.add(var);
        }

        void add(DataAccessNode dataAccess) {
            this.exprs.add(dataAccess);
        }

        void add(NullSafeAccessNode dataAccess) {
            this.exprs.add(dataAccess);
        }

        Block addBranch() {
            Block branch = new Block();
            this.successors.add(branch);
            return branch;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ImmutableMap.of((Object)"id", (Object)this.hashCode(), (Object)"exprs", this.exprs, (Object)"in_edges", (Object)this.predecessors.stream().map(p -> String.valueOf(p.hashCode())).collect(Collectors.joining(", ")), (Object)"out_edges", (Object)this.successors.stream().map(p -> String.valueOf(p.hashCode())).collect(Collectors.joining(", ")));
        }
    }

    private static final class AccessGraph {
        final Block start;
        final Block end;
        final ExprEquivalence exprEquivalence;

        static AccessGraph create(Block start, Block end, ExprEquivalence exprEquivalence) {
            TemplateAnalysisImpl.addPredecessors(start);
            Preconditions.checkState((boolean)start.predecessors.isEmpty());
            Preconditions.checkState((boolean)end.successors.isEmpty());
            TemplateAnalysisImpl.eliminateEmptyNodes(start, end);
            TemplateAnalysisImpl.eliminateUnconditionalBranches(start, end);
            Preconditions.checkState((boolean)start.predecessors.isEmpty());
            Preconditions.checkState((boolean)end.successors.isEmpty());
            return new AccessGraph(start, end, exprEquivalence);
        }

        AccessGraph(Block start, Block end, ExprEquivalence exprEquivalence) {
            this.start = start;
            this.end = end;
            this.exprEquivalence = exprEquivalence;
        }

        AccessGraph copy() {
            IdentityHashMap<Block, Block> originalToCopy = new IdentityHashMap<Block, Block>();
            Block newStart = AccessGraph.deepCopyBlock(this.start, originalToCopy);
            Block newEnd = originalToCopy.get(this.end);
            return new AccessGraph(newStart, newEnd, this.exprEquivalence);
        }

        Set<ExprNode> getResolvedExpressions() {
            Set resolvedExprs = Sets.newIdentityHashSet();
            IdentityHashMap blockToAccessedExprs = new IdentityHashMap();
            for (Block current : this.getTopologicalOrdering()) {
                Set currentBlockSet = AccessGraph.mergePredecessors(blockToAccessedExprs, current);
                for (ExprNode expr : current.exprs) {
                    ExprEquivalence.Wrapper wrapped = this.exprEquivalence.wrap(expr);
                    if (currentBlockSet.add(wrapped)) continue;
                    resolvedExprs.add(expr);
                }
                if (current.successors.isEmpty()) continue;
                blockToAccessedExprs.put(current, currentBlockSet);
            }
            return resolvedExprs;
        }

        static <T> Set<T> mergePredecessors(Map<Block, Set<T>> blockToAccessedExprs, Block current) {
            HashSet<Object> currentBlockSet = null;
            for (Block predecessor : current.predecessors) {
                Set<T> predecessorBlockSet = blockToAccessedExprs.get(predecessor);
                if (currentBlockSet == null) {
                    currentBlockSet = new HashSet<T>(predecessorBlockSet);
                    continue;
                }
                currentBlockSet.retainAll(predecessorBlockSet);
            }
            if (currentBlockSet == null) {
                currentBlockSet = new HashSet();
            }
            return currentBlockSet;
        }

        private Collection<Block> getTopologicalOrdering() {
            LinkedHashSet<Block> ordering = new LinkedHashSet<Block>();
            LinkedHashSet<Block> discoveredButNotVisited = new LinkedHashSet<Block>();
            discoveredButNotVisited.add(this.start);
            while (!discoveredButNotVisited.isEmpty()) {
                Optional<Block> firstVisitedAllPredecessors = discoveredButNotVisited.stream().filter(block -> ordering.containsAll(block.predecessors)).findFirst();
                if (firstVisitedAllPredecessors.isPresent()) {
                    Block notVisited = firstVisitedAllPredecessors.get();
                    discoveredButNotVisited.remove(notVisited);
                    discoveredButNotVisited.addAll(notVisited.successors);
                    ordering.add(notVisited);
                    continue;
                }
                throw new AssertionError((Object)"failed to make progress");
            }
            return ordering;
        }

        private static Block deepCopyBlock(Block original, IdentityHashMap<Block, Block> originalToCopy) {
            if (originalToCopy.containsKey(original)) {
                return originalToCopy.get(original);
            }
            Block copy = new Block();
            for (ExprNode expr : original.exprs) {
                copy.exprs.add(expr.copy(new CopyState()));
            }
            originalToCopy.put(original, copy);
            for (Block successor : original.successors) {
                copy.successors.add(AccessGraph.deepCopyBlock(successor, originalToCopy));
            }
            for (Block predecessor : original.predecessors) {
                copy.predecessors.add(AccessGraph.deepCopyBlock(predecessor, originalToCopy));
            }
            return copy;
        }

        public String toString() {
            Block current;
            SetMultimap adjacencyMatrix = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
            ArrayDeque<Block> toVisit = new ArrayDeque<Block>();
            LinkedHashSet<Block> visited = new LinkedHashSet<Block>();
            toVisit.add(this.start);
            while ((current = (Block)toVisit.poll()) != null) {
                if (!visited.add(current)) continue;
                adjacencyMatrix.putAll((Object)current, current.successors);
                toVisit.addAll(current.successors);
            }
            StringBuilder graph = new StringBuilder().append("digraph AccessGraph {");
            int id = 0;
            IdentityHashMap<Block, Integer> nodeIds = new IdentityHashMap<Block, Integer>();
            for (Block node : visited) {
                graph.append("\n ").append(id).append(" [label=\"");
                if (node == this.start) {
                    graph.append("START ");
                }
                if (node == this.end) {
                    graph.append("END ");
                }
                graph.append(node.exprs.stream().map(e -> e.toSourceString() + "@" + e.getSourceLocation().getBeginLine() + ":" + e.getSourceLocation().getBeginColumn()).collect(Collectors.joining(" ,", "[", "]"))).append("\"];");
                nodeIds.put(node, id);
                ++id;
            }
            for (Map.Entry entry : adjacencyMatrix.entries()) {
                graph.append("\n  ").append(nodeIds.get(entry.getKey())).append(" -> ").append(nodeIds.get(entry.getValue())).append(";");
            }
            return graph.append("\n}").toString();
        }
    }

    private static final class PseudoEvaluatorExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        final Map<VarDefn, AccessGraph> letNodes;
        Block current;

        PseudoEvaluatorExprVisitor(Map<VarDefn, AccessGraph> letNodes) {
            this.letNodes = letNodes;
        }

        Block eval(Block block, ExprNode expr) {
            Block orig = this.current;
            this.current = block;
            this.visit(expr);
            Block rVal = this.current;
            this.current = orig;
            return rVal;
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNullSafeAccessNode(NullSafeAccessNode node) {
            this.visit(node.getBase());
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitListComprehensionNode(ListComprehensionNode node) {
        }

        @Override
        protected void visitAssertNonNullOpNode(OperatorNodes.AssertNonNullOpNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitVeLiteralNode(VeLiteralNode node) {
        }

        @Override
        protected void visitTemplateLiteralNode(TemplateLiteralNode node) {
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visit(node.getRoot());
        }

        @Override
        protected void visitVarRefNode(VarRefNode node) {
            AccessGraph letContent = this.letNodes.get(node.getDefnDecl());
            if (letContent != null) {
                AccessGraph copy = letContent.copy();
                this.current.successors.add(copy.start);
                this.current = copy.end.addBranch();
            }
            this.current.add(node);
        }

        @Override
        protected void visitDataAccessNode(DataAccessNode node) {
            this.visitChildren(node);
            this.current.add(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.getSoyFunction() instanceof BuiltinFunction) {
                BuiltinFunction builtinFunction = (BuiltinFunction)node.getSoyFunction();
                switch (builtinFunction) {
                    case IS_PRIMARY_MSG_IN_USE: {
                        return;
                    }
                    case CHECK_NOT_NULL: 
                    case CSS: 
                    case DEBUG_SOY_TEMPLATE_INFO: 
                    case PROTO_INIT: 
                    case SOY_SERVER_KEY: 
                    case TO_FLOAT: 
                    case VE_DATA: 
                    case XID: 
                    case IS_PARAM_SET: {
                        break;
                    }
                    case UNKNOWN_JS_GLOBAL: {
                        throw new UnsupportedOperationException("the " + builtinFunction.getName() + " function can't be used in templates compiled to Java");
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected builtin function: " + builtinFunction.getName()));
                    }
                }
            }
            this.visitChildren(node);
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitRecordLiteralNode(RecordLiteralNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitOperatorNode(ExprNode.OperatorNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getLeftChild());
            this.executeInBranch(node.getRightChild());
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.visit(node.getChild(0));
            this.executeInBranch(node.getChild(1));
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            this.executeInBranch(node.getChild(1));
        }

        private void executeInBranch(ExprNode expr) {
            Block prev = this.current;
            Block branch = prev.addBranch();
            branch = this.eval(branch, expr);
            this.current = Block.merge(prev, branch);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            this.current = Block.merge(this.eval(this.current.addBranch(), node.getChild(1)), this.eval(this.current.addBranch(), node.getChild(2)));
        }
    }

    private static enum StaticAnalysisResult {
        TRUE,
        FALSE,
        UNKNOWN;

    }

    private static final class PseudoEvaluatorVisitor
    extends AbstractSoyNodeVisitor<Void> {
        final Map<VarDefn, AccessGraph> letNodes = new HashMap<VarDefn, AccessGraph>();
        final PseudoEvaluatorExprVisitor exprVisitor = new PseudoEvaluatorExprVisitor(this.letNodes);
        final ExprEquivalence exprEquivalence = new ExprEquivalence();
        Block current;

        private PseudoEvaluatorVisitor() {
        }

        AccessGraph evaluate(TemplateNode node) {
            Block start = new Block();
            Block end = this.exec(start, node);
            return AccessGraph.create(start, end, this.exprEquivalence);
        }

        Block exec(Block block, SoyNode node) {
            Block original = this.current;
            this.current = block;
            this.visit(node);
            Block rVal = this.current;
            this.current = original;
            return rVal;
        }

        @Override
        protected void visitPrintNode(PrintNode node) {
            this.evalInline(node.getExpr());
            for (PrintDirectiveNode directive : node.getChildren()) {
                for (ExprRootNode arg : directive.getArgs()) {
                    this.evalInline(arg);
                }
            }
        }

        @Override
        protected void visitKeyNode(KeyNode node) {
        }

        @Override
        protected void visitVeLogNode(VeLogNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitRawTextNode(RawTextNode node) {
        }

        @Override
        protected void visitLogNode(LogNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitDebuggerNode(DebuggerNode node) {
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitForNode(ForNode node) {
            this.evalInline(node.getExpr());
            Block loopBegin = this.current;
            Block loopBody = loopBegin.addBranch();
            Block loopEnd = this.exec(loopBody, (SoyNode)node.getChild(0));
            StaticAnalysisResult isLoopEmpty = TemplateAnalysisImpl.isListExpressionEmpty(node);
            if (node.numChildren() == 2) {
                Block ifEmptyBlock = loopBegin.addBranch();
                Block ifEmptyEnd = this.exec(ifEmptyBlock, (SoyNode)node.getChild(1));
                switch (isLoopEmpty) {
                    case FALSE: {
                        this.current = loopEnd.addBranch();
                        break;
                    }
                    case TRUE: {
                        this.current = ifEmptyEnd.addBranch();
                        break;
                    }
                    case UNKNOWN: {
                        this.current = Block.merge(loopEnd, ifEmptyEnd);
                    }
                }
            } else {
                switch (isLoopEmpty) {
                    case FALSE: {
                        this.current = loopEnd.addBranch();
                        break;
                    }
                    case TRUE: {
                        this.current = loopBegin.addBranch();
                        break;
                    }
                    case UNKNOWN: {
                        this.current = Block.merge(loopEnd, loopBegin);
                    }
                }
            }
        }

        @Override
        protected void visitForIfemptyNode(ForIfemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            Block startBlock;
            Block block = startBlock = new Block();
            for (SoyNode.StandaloneNode child : node.getChildren()) {
                block = this.exec(block, child);
            }
            AccessGraph letStatement = AccessGraph.create(startBlock, block, this.exprEquivalence);
            this.letNodes.put(node.getVar(), letStatement);
            this.current.successors.add(letStatement.start);
            this.current = this.current.addBranch();
        }

        @Override
        protected void visitLetValueNode(LetValueNode node) {
            Block start = new Block();
            Block end = this.exprVisitor.eval(start, node.getExpr());
            AccessGraph letStatement = AccessGraph.create(start, end, this.exprEquivalence);
            this.letNodes.put(node.getVar(), letStatement);
            this.current.successors.add(letStatement.start);
            this.current = this.current.addBranch();
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            List children = node.getChildren();
            if (children.isEmpty()) {
                return;
            }
            if (children.size() == 1 && children.get(0) instanceof SwitchDefaultNode) {
                this.visitChildren((SoyNode.ParentSoyNode)children.get(0));
                return;
            }
            this.evalInline(node.getExpr());
            Block conditions = null;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            boolean hasDefault = false;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof SwitchCaseNode) {
                    SwitchCaseNode scn = (SwitchCaseNode)child;
                    Block caseBlockStart = new Block();
                    Block caseBlockEnd = this.exec(caseBlockStart, scn);
                    branchEnds.add(caseBlockEnd);
                    for (ExprRootNode expr : scn.getExprList()) {
                        if (conditions == null) {
                            this.evalInline(expr);
                            conditions = this.current;
                        } else {
                            Block condition = conditions.addBranch();
                            conditions = this.exprVisitor.eval(condition, expr);
                        }
                        conditions.successors.add(caseBlockStart);
                    }
                    continue;
                }
                SwitchDefaultNode ien = (SwitchDefaultNode)child;
                Block defaultBlockStart = conditions.addBranch();
                Block defaultBlockEnd = this.exec(defaultBlockStart, ien);
                branchEnds.add(defaultBlockEnd);
                hasDefault = true;
            }
            if (!hasDefault) {
                branchEnds.add(conditions);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitSwitchCaseNode(SwitchCaseNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitIfNode(IfNode node) {
            Block conditionFork = null;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            boolean hasElse = false;
            for (SoyNode child : node.getChildren()) {
                if (child instanceof IfCondNode) {
                    IfCondNode icn = (IfCondNode)child;
                    ExprRootNode conditionExpression = icn.getExpr();
                    if (conditionFork == null) {
                        this.evalInline(conditionExpression);
                        conditionFork = this.current;
                    } else {
                        conditionFork = this.exprVisitor.eval(conditionFork.addBranch(), conditionExpression);
                    }
                    Block branch = conditionFork.addBranch();
                    branch = this.exec(branch, icn);
                    branchEnds.add(branch);
                    continue;
                }
                IfElseNode ien = (IfElseNode)child;
                Block branch = conditionFork.addBranch();
                branch = this.exec(branch, ien);
                branchEnds.add(branch);
                hasElse = true;
            }
            if (!hasElse) {
                branchEnds.add(conditionFork);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitIfCondNode(IfCondNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitIfElseNode(IfElseNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode node) {
            ExprRootNode dataExpr = node.getDataExpr();
            if (dataExpr != null) {
                this.evalInline(dataExpr);
            }
            Block begin = this.current;
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            branchEnds.add(begin);
            for (CallParamNode param : node.getChildren()) {
                Block paramBranch = begin.addBranch();
                Block paramBranchEnd = this.exec(paramBranch, param);
                branchEnds.add(paramBranchEnd);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitCallParamValueNode(CallParamValueNode node) {
            this.evalInline(node.getExpr());
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            if (node.numChildren() == 1) {
                this.visit((SoyNode)node.getChild(0));
            } else {
                Block normalBranch = this.current.addBranch();
                Block fallbackBranch = this.current.addBranch();
                normalBranch = this.exec(normalBranch, (SoyNode)node.getChild(0));
                fallbackBranch = this.exec(fallbackBranch, (SoyNode)node.getChild(1));
                this.current = Block.merge(normalBranch, fallbackBranch);
            }
        }

        @Override
        protected void visitMsgNode(MsgNode node) {
            this.evaluateMsgParts(node, MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat((MsgNode)node).parts);
        }

        private void evaluateMsgParts(MsgNode msgNode, ImmutableList<? extends SoyMsgPart> parts) {
            LinkedHashMap<SoyNode, Block> placeholderBlocks = new LinkedHashMap<SoyNode, Block>();
            Block placeholderBranch = this.current.addBranch();
            this.current = this.current.addBranch();
            this.evaluateMsgParts(msgNode, parts, placeholderBlocks);
            placeholderBranch.successors.addAll(placeholderBlocks.values());
        }

        private void evaluateMsgParts(MsgNode msgNode, ImmutableList<? extends SoyMsgPart> parts, Map<SoyNode, Block> placeholderBlocks) {
            for (SoyMsgPart part : parts) {
                if (part instanceof SoyMsgRawTextPart || part instanceof SoyMsgPluralRemainderPart) continue;
                if (part instanceof SoyMsgPluralPart) {
                    Preconditions.checkState((parts.size() == 1 ? 1 : 0) != 0);
                    SoyMsgPluralPart plural = (SoyMsgPluralPart)part;
                    this.evalInline(msgNode.getRepPluralNode(plural.getPluralVarName()).getExpr());
                    this.evalPlrSelCases(msgNode, plural.getCases(), placeholderBlocks);
                    continue;
                }
                if (part instanceof SoyMsgSelectPart) {
                    Preconditions.checkState((parts.size() == 1 ? 1 : 0) != 0);
                    SoyMsgSelectPart select = (SoyMsgSelectPart)part;
                    this.evalInline(msgNode.getRepSelectNode(select.getSelectVarName()).getExpr());
                    this.evalPlrSelCases(msgNode, select.getCases(), placeholderBlocks);
                    continue;
                }
                if (part instanceof SoyMsgPlaceholderPart) {
                    SoyMsgPlaceholderPart placeholder = (SoyMsgPlaceholderPart)part;
                    MsgPlaceholderNode placeholderNode = msgNode.getRepPlaceholderNode(placeholder.getPlaceholderName());
                    placeholderBlocks.computeIfAbsent(placeholderNode, node -> {
                        Block placeholderBlock = new Block();
                        this.exec(placeholderBlock, (SoyNode)node);
                        return placeholderBlock;
                    });
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + part));
            }
        }

        private void evalPlrSelCases(MsgNode msgNode, ImmutableList<? extends SoyMsgPart.Case<?>> cases, Map<SoyNode, Block> placeholderBlocks) {
            ArrayList<Block> branchEnds = new ArrayList<Block>();
            Block previous = this.current;
            for (SoyMsgPart.Case caseOrDefault : cases) {
                Block caseBlockStart;
                this.current = caseBlockStart = previous.addBranch();
                this.evaluateMsgParts(msgNode, caseOrDefault.parts(), placeholderBlocks);
                branchEnds.add(this.current);
            }
            this.current = Block.merge(branchEnds);
        }

        @Override
        protected void visitMsgPlaceholderNode(MsgPlaceholderNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            throw new UnsupportedOperationException("unsupported node type: " + (Object)((Object)node.getKind()));
        }

        @Override
        protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
            super.visitChildren(node);
        }

        void evalInline(ExprNode expr) {
            this.current = this.evalInBlock(this.current, expr);
        }

        Block evalInBlock(Block begin, ExprNode expr) {
            return this.exprVisitor.eval(begin, expr);
        }
    }
}

