/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyValueUnconverter;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.LazyProtoToSoyValueList;
import com.google.template.soy.data.internal.LazyProtoToSoyValueMap;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.internal.SoyRecordImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.restricted.AutoValue_MethodRef;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.BufferedSoyValueProvider;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
public abstract class MethodRef {
    public static final Type[] NO_METHOD_ARGS = new Type[0];
    public static final MethodRef ADVISING_STRING_BUILDER_GET_AND_CLEAR = MethodRef.create(LoggingAdvisingAppendable.BufferingAppendable.class, "getAndClearBuffer", new Class[0]).asNonNullable();
    public static final MethodRef ARRAY_LIST_ADD = MethodRef.create(ArrayList.class, "add", Object.class);
    public static final MethodRef BOOLEAN_DATA_FOR_VALUE = MethodRef.create(BooleanData.class, "forValue", Boolean.TYPE).asNonNullable();
    public static final MethodRef BOOLEAN_VALUE = MethodRef.create(Boolean.class, "booleanValue", new Class[0]).asCheap();
    public static final MethodRef BOOLEAN_TO_STRING = MethodRef.create(Boolean.class, "toString", Boolean.TYPE).asCheap().asNonNullable();
    public static final MethodRef COMPILED_TEMPLATE_RENDER = MethodRef.create(CompiledTemplate.class, "render", SoyRecord.class, SoyRecord.class, LoggingAdvisingAppendable.class, RenderContext.class).asNonNullable();
    public static final MethodRef DICT_IMPL_FOR_PROVIDER_MAP = MethodRef.create(DictImpl.class, "forProviderMap", Map.class, RuntimeMapTypeTracker.Type.class).asNonNullable();
    public static final MethodRef MAP_IMPL_FOR_PROVIDER_MAP = MethodRef.create(SoyMapImpl.class, "forProviderMap", Map.class).asNonNullable();
    public static final MethodRef RECORD_IMPL_FOR_PROVIDER_MAP = MethodRef.create(SoyRecordImpl.class, "forProviderMap", Map.class).asNonNullable();
    public static final MethodRef DOUBLE_TO_STRING = MethodRef.create(FloatData.class, "toString", Double.TYPE).asNonNullable();
    public static final MethodRef EQUALS = MethodRef.create(Object.class, "equals", Object.class);
    public static final MethodRef STRING_COMPARE_TO = MethodRef.create(String.class, "compareTo", String.class);
    public static final MethodRef FLOAT_DATA_FOR_VALUE = MethodRef.create(FloatData.class, "forValue", Double.TYPE).asNonNullable();
    public static final MethodRef RENDER_RESULT_ASSERT_DONE = MethodRef.create(RenderResult.class, "assertDone", new Class[0]);
    public static final MethodRef IMMUTABLE_LIST_COPY_OF_COLLECTION = MethodRef.create(ImmutableList.class, "copyOf", Collection.class);
    public static final ImmutableList<MethodRef> IMMUTABLE_LIST_OF;
    public static final MethodRef IMMUTABLE_LIST_OF_ARRAY;
    public static final MethodRef INTEGER_DATA_FOR_VALUE;
    public static final MethodRef INTS_CHECKED_CAST;
    public static final MethodRef MAP_PUT;
    public static final MethodRef LIST_GET;
    public static final MethodRef LIST_SIZE;
    public static final MethodRef MAP_SIZE;
    public static final MethodRef MAP_ENTRY_SET;
    public static final MethodRef GET_ITERATOR;
    public static final MethodRef ITERATOR_NEXT;
    public static final MethodRef ITERATOR_HAS_NEXT;
    public static final MethodRef MAP_GET_KEY;
    public static final MethodRef MAP_GET_VALUE;
    public static final MethodRef LIST_IMPL_FOR_PROVIDER_LIST;
    public static final MethodRef LONG_PARSE_LONG;
    public static final MethodRef UNSIGNED_LONGS_PARSE_UNSIGNED_LONG;
    public static final MethodRef UNSIGNED_LONGS_TO_STRING;
    public static final MethodRef UNSIGNED_INTS_SATURATED_CAST;
    public static final MethodRef UNSIGNED_INTS_TO_LONG;
    public static final MethodRef LONG_TO_STRING;
    public static final MethodRef NUMBER_DOUBLE_VALUE;
    public static final MethodRef NUMBER_LONG_VALUE;
    public static final MethodRef NUMBER_INT_VALUE;
    public static final MethodRef OBJECT_TO_STRING;
    public static final MethodRef OBJECTS_EQUALS;
    public static final MethodRef ORDAIN_AS_SAFE;
    public static final MethodRef ORDAIN_AS_SAFE_DIR;
    public static final MethodRef LIST_UNBOX_INTS;
    public static final MethodRef LIST_UNBOX_FLOATS;
    public static final MethodRef LIST_UNBOX_BOOLS;
    public static final MethodRef LIST_UNBOX_STRINGS;
    public static final MethodRef LIST_UNBOX_PROTOS;
    public static final MethodRef LIST_UNBOX_ENUMS;
    public static final MethodRef LIST_BOX_VALUES;
    public static final MethodRef UNBOX_MAP;
    public static final MethodRef UNBOX_RECORD;
    public static final MethodRef SOY_VALUE_TO_BOXED_INTEGER;
    public static final MethodRef SOY_VALUE_TO_BOXED_DOUBLE;
    public static final MethodRef SOY_VALUE_TO_BOXED_FLOAT;
    public static final MethodRef SOY_VALUE_TO_ENUM;
    public static final MethodRef SOY_VALUE_TO_BOXED_BOOLEAN;
    public static final MethodRef SOY_VALUE_TO_BOXED_LONG;
    public static final MethodRef PARAM_STORE_SET_FIELD;
    public static final MethodRef PRINT_STREAM_PRINTLN;
    public static final MethodRef SOY_PROTO_VALUE_CREATE;
    public static final MethodRef RENDER_RESULT_DONE;
    public static final MethodRef RENDER_RESULT_IS_DONE;
    public static final MethodRef RENDER_RESULT_LIMITED;
    public static final MethodRef RUNTIME_APPLY_ESCAPERS;
    public static final MethodRef RUNTIME_CHECK_RESOLVED_LIST;
    public static final MethodRef RUNTIME_CHECK_RESOLVED_MAP;
    public static final MethodRef SOY_SERVER_KEY;
    public static final MethodRef RUNTIME_RANGE_LOOP_LENGTH;
    public static final MethodRef RUNTIME_APPLY_PRINT_DIRECTIVE;
    public static final MethodRef RUNTIME_BIND_TEMPLATE_PARAMS;
    public static final MethodRef RUNTIME_CALL_LEGACY_FUNCTION;
    public static final MethodRef RUNTIME_COERCE_DOUBLE_TO_BOOLEAN;
    public static final MethodRef RUNTIME_COERCE_TO_STRING;
    public static final MethodRef RUNTIME_COERCE_TO_BOOLEAN;
    public static final MethodRef RUNTIME_COERCE_STRING_TO_BOOLEAN;
    public static final MethodRef RUNTIME_EQUAL;
    public static final MethodRef RUNTIME_COMPARE_STRING;
    public static final MethodRef RUNTIME_COMPARE_NULLABLE_STRING;
    public static final MethodRef RUNTIME_HAS_FIELD;
    public static final MethodRef RUNTIME_GET_FIELD;
    public static final MethodRef RUNTIME_GET_FIELD_PROVIDER;
    public static final MethodRef RUNTIME_PARAM_OR_DEFAULT;
    public static final MethodRef RUNTIME_PARAM;
    public static final MethodRef RUNTIME_GET_FIELD_PROVIDER_DEFAULT;
    public static final MethodRef IS_PARAM_SET;
    public static final MethodRef RUNTIME_GET_LIST_ITEM;
    public static final MethodRef RUNTIME_GET_LIST_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_GET_LIST_STATUS;
    public static final MethodRef RUNTIME_GET_MAP_STATUS;
    public static final MethodRef RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM;
    public static final MethodRef RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_GET_MAP_ITEM;
    public static final MethodRef RUNTIME_GET_MAP_ITEM_PROVIDER;
    public static final MethodRef RUNTIME_LESS_THAN;
    public static final MethodRef RUNTIME_LESS_THAN_OR_EQUAL;
    public static final MethodRef RUNTIME_LOGGER;
    public static final MethodRef RUNTIME_DEBUGGER;
    public static final MethodRef RUNTIME_MINUS;
    public static final MethodRef RUNTIME_NEGATIVE;
    public static final MethodRef RUNTIME_PLUS;
    public static final MethodRef RUNTIME_MOD;
    public static final MethodRef CONSTRUCT_MAP_FROM_LIST;
    public static final MethodRef MSG_RENDERER_SET_PLACEHOLDER;
    public static final MethodRef HANDLE_BASIC_TRANSLATION;
    public static final MethodRef HANDLE_BASIC_TRANSLATION_AND_ESCAPE_HTML;
    public static final MethodRef MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING;
    public static final MethodRef RUNTIME_STRING_EQUALS_AS_NUMBER;
    public static final MethodRef RUNTIME_TIMES;
    public static final MethodRef RUNTIME_UNEXPECTED_STATE_ERROR;
    public static final MethodRef NO_EXTERN_JAVA_IMPL;
    public static final MethodRef SOY_LIST_AS_JAVA_LIST;
    public static final MethodRef SOY_DICT_IMPL_AS_JAVA_MAP;
    public static final MethodRef SOY_MAP_IMPL_AS_JAVA_MAP;
    public static final MethodRef SOY_PROTO_VALUE_GET_PROTO;
    public static final MethodRef SOY_VALUE_COERCE_TO_BOOLEAN;
    public static final MethodRef SOY_VALUE_BOOLEAN_VALUE;
    public static final MethodRef SOY_VALUE_FLOAT_VALUE;
    public static final MethodRef SOY_VALUE_LONG_VALUE;
    public static final MethodRef SOY_VALUE_INTEGER_VALUE;
    public static final MethodRef SOY_VALUE_NUMBER_VALUE;
    public static final MethodRef SOY_VALUE_JAVA_NUMBER_VALUE;
    public static final MethodRef SOY_VALUE_STRING_VALUE;
    public static final MethodRef COMPILED_TEMPLATE_GET_TEMPLATE;
    public static final MethodRef SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE;
    public static final MethodRef CONVERT_FUTURE_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_SAFE_URL_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_SAFE_URL_PROTO_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_TRUSTED_RESOURCE_URL_PROTO_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_SAFE_HTML_PROTO_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_SAFE_HTML_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef CONVERT_TRUSTED_RESOURCE_URL_TO_SOY_VALUE_PROVIDER;
    public static final MethodRef SOY_VALUE_PROVIDER_RESOLVE;
    public static final MethodRef SOY_VALUE_PROVIDER_OR_NULL;
    public static final MethodRef LONG_TO_INT;
    public static final MethodRef SOY_VALUE_PROVIDER_STATUS;
    public static final MethodRef STRING_CONCAT;
    public static final MethodRef STRING_IS_EMPTY;
    public static final MethodRef STRING_VALUE_OF;
    public static final MethodRef BOX_INTEGER;
    public static final MethodRef BOX_LONG;
    public static final MethodRef BOX_DOUBLE;
    public static final MethodRef BOX_FLOAT;
    public static final MethodRef BOX_BOOLEAN;
    public static final MethodRef UNBOX_INTEGER;
    public static final MethodRef UNBOX_LONG;
    public static final MethodRef UNBOX_DOUBLE;
    public static final MethodRef UNBOX_FLOAT;
    public static final MethodRef UNBOX_BOOLEAN;
    public static final MethodRef UNBOX_OBJECT;
    public static final MethodRef UNBOX_SAFE_URL;
    public static final MethodRef UNBOX_SAFE_HTML_PROTO;
    public static final MethodRef UNBOX_SAFE_URL_PROTO;
    public static final MethodRef UNBOX_TRUSTED_RESOURCE_URL_PROTO;
    public static final MethodRef UNBOX_SAFE_HTML;
    public static final MethodRef UNBOX_TRUSTED_RESOURCE_URL;
    public static final MethodRef STRING_DATA_FOR_VALUE;
    public static final MethodRef LOGGING_ADVISING_APPENDABLE_BUFFERING;
    public static final MethodRef BUFFERED_SOY_VALUE_PROVIDER_CREATE;
    public static final MethodRef CREATE_LOG_STATEMENT;
    public static final MethodRef CLOSEABLE_CLOSE;
    public static final MethodRef LEGACY_ADAPTER_COMPUTE;
    public static final MethodRef PROTOCOL_ENUM_GET_NUMBER;
    public static final MethodRef SOY_VISUAL_ELEMENT_CREATE;
    public static final MethodRef SOY_VISUAL_ELEMENT_DATA_CREATE;
    public static final MethodRef FLUSH_LOGS_AND_RENDER;
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_MAP;
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_RECORD;
    public static final MethodRef BOX_JAVA_MAP_AS_SOY_LEGACY_OBJECT_MAP;
    public static final MethodRef LAZY_PROTO_TO_SOY_VALUE_LIST_FOR_LIST;
    public static final MethodRef LAZY_PROTO_TO_SOY_VALUE_MAP_FOR_MAP;
    public static final MethodRef GET_EXTENSION_LIST;
    public static final MethodRef SOY_RECORD_GET_FIELD_PROVIDER;

    public static MethodRef create(Class<?> clazz, String methodName, Class<?> ... params) {
        java.lang.reflect.Method m;
        try {
            m = clazz.getMethod(methodName, params);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't find the expected method among: " + Arrays.toString(clazz.getMethods()), e);
        }
        return MethodRef.create(m);
    }

    public static MethodRef create(java.lang.reflect.Method method) {
        Class<?> clazz = method.getDeclaringClass();
        TypeInfo ownerType = TypeInfo.create(method.getDeclaringClass());
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        ImmutableList argTypes = isStatic ? ImmutableList.copyOf((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)) : ImmutableList.builder().add((Object)ownerType.type()).add((Object[])Type.getArgumentTypes((java.lang.reflect.Method)method)).build();
        return new AutoValue_MethodRef(clazz.isInterface() ? 185 : (isStatic ? 184 : 182), ownerType, Method.getMethod((java.lang.reflect.Method)method), Type.getType(method.getReturnType()), (ImmutableList<Type>)argTypes, Expression.Features.of());
    }

    public static MethodRef createInterfaceMethod(TypeInfo owner, Method method) {
        Preconditions.checkArgument((boolean)owner.isInterface());
        return new AutoValue_MethodRef(185, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    public static MethodRef createInstanceMethod(TypeInfo owner, Method method) {
        Preconditions.checkArgument((!owner.isInterface() ? 1 : 0) != 0);
        return new AutoValue_MethodRef(182, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object)owner.type()).add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    public static MethodRef createStaticMethod(TypeInfo owner, Method method) {
        return new AutoValue_MethodRef(184, owner, method, method.getReturnType(), (ImmutableList<Type>)ImmutableList.builder().add((Object[])method.getArgumentTypes()).build(), Expression.Features.of());
    }

    abstract int opcode();

    public abstract TypeInfo owner();

    public abstract Method method();

    public abstract Type returnType();

    abstract ImmutableList<Type> argTypes();

    public abstract Expression.Features features();

    public Handle asHandle() {
        int tag;
        switch (this.opcode()) {
            case 184: {
                tag = 6;
                break;
            }
            case 185: {
                tag = 9;
                break;
            }
            case 182: {
                tag = 5;
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported opcode: " + this.opcode()));
            }
        }
        return new Handle(tag, this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.owner().isInterface());
    }

    public Statement invokeVoid(Expression ... args) {
        return this.invokeVoid(Arrays.asList(args));
    }

    public Statement invokeVoid(final Iterable<? extends Expression> args) {
        Preconditions.checkState((boolean)Type.VOID_TYPE.equals((Object)this.returnType()), (Object)"Method return type is not void.");
        Expression.checkTypes(this.argTypes(), args);
        return new Statement(){

            @Override
            protected void doGen(CodeBuilder adapter) {
                MethodRef.this.doInvoke(adapter, args);
            }
        };
    }

    public Expression invoke(Expression ... args) {
        return this.invoke(Arrays.asList(args));
    }

    public Expression invoke(final Iterable<? extends Expression> args) {
        Preconditions.checkState((!Type.VOID_TYPE.equals((Object)this.returnType()) ? 1 : 0) != 0, (Object)"Cannot produce an expression from a void method.");
        Expression.checkTypes(this.argTypes(), args);
        Expression.Features features = this.features();
        if (!Expression.areAllCheap(args)) {
            features = features.minus(Expression.Feature.CHEAP);
        }
        return new Expression(this.returnType(), features){

            @Override
            protected void doGen(CodeBuilder mv) {
                MethodRef.this.doInvoke(mv, args);
            }
        };
    }

    public MethodRef asCheap() {
        return this.withFeature(Expression.Feature.CHEAP);
    }

    public MethodRef asNonNullable() {
        return this.withFeature(Expression.Feature.NON_NULLABLE);
    }

    private MethodRef withFeature(Expression.Feature feature) {
        if (this.features().has(feature)) {
            return this;
        }
        return new AutoValue_MethodRef(this.opcode(), this.owner(), this.method(), this.returnType(), this.argTypes(), this.features().plus(feature));
    }

    public void invokeUnchecked(CodeBuilder cb) {
        cb.visitMethodInsn(this.opcode(), this.owner().internalName(), this.method().getName(), this.method().getDescriptor(), this.owner().isInterface());
    }

    private void doInvoke(CodeBuilder mv, Iterable<? extends Expression> args) {
        for (Expression expression : args) {
            expression.gen(mv);
        }
        this.invokeUnchecked(mv);
    }

    static {
        Object[] immutableListOfMethods = new MethodRef[12];
        MethodRef immutableListOfArray = null;
        for (java.lang.reflect.Method m : ImmutableList.class.getMethods()) {
            if (!m.getName().equals("of")) continue;
            Class<?>[] params = m.getParameterTypes();
            MethodRef ref = MethodRef.create(m).asNonNullable();
            if (params.length > 0 && params[params.length - 1].isArray()) {
                immutableListOfArray = ref;
                continue;
            }
            int arity = params.length;
            if (arity == 0) {
                ref = ref.asCheap();
            }
            immutableListOfMethods[arity] = ref;
        }
        IMMUTABLE_LIST_OF_ARRAY = immutableListOfArray;
        IMMUTABLE_LIST_OF = ImmutableList.copyOf((Object[])immutableListOfMethods);
        INTEGER_DATA_FOR_VALUE = MethodRef.create(IntegerData.class, "forValue", Long.TYPE).asNonNullable();
        INTS_CHECKED_CAST = MethodRef.create(Ints.class, "checkedCast", Long.TYPE).asCheap();
        MAP_PUT = MethodRef.create(Map.class, "put", Object.class, Object.class);
        LIST_GET = MethodRef.create(List.class, "get", Integer.TYPE).asCheap();
        LIST_SIZE = MethodRef.create(List.class, "size", new Class[0]).asCheap();
        MAP_SIZE = MethodRef.create(Map.class, "size", new Class[0]).asCheap();
        MAP_ENTRY_SET = MethodRef.create(Map.class, "entrySet", new Class[0]);
        GET_ITERATOR = MethodRef.create(Iterable.class, "iterator", new Class[0]);
        ITERATOR_NEXT = MethodRef.create(Iterator.class, "next", new Class[0]);
        ITERATOR_HAS_NEXT = MethodRef.create(Iterator.class, "hasNext", new Class[0]);
        MAP_GET_KEY = MethodRef.create(Map.Entry.class, "getKey", new Class[0]);
        MAP_GET_VALUE = MethodRef.create(Map.Entry.class, "getValue", new Class[0]);
        LIST_IMPL_FOR_PROVIDER_LIST = MethodRef.create(ListImpl.class, "forProviderList", List.class);
        LONG_PARSE_LONG = MethodRef.create(Long.class, "parseLong", String.class).asCheap().asNonNullable();
        UNSIGNED_LONGS_PARSE_UNSIGNED_LONG = MethodRef.create(UnsignedLongs.class, "parseUnsignedLong", String.class).asCheap();
        UNSIGNED_LONGS_TO_STRING = MethodRef.create(UnsignedLongs.class, "toString", Long.TYPE).asCheap().asNonNullable();
        UNSIGNED_INTS_SATURATED_CAST = MethodRef.create(UnsignedInts.class, "saturatedCast", Long.TYPE).asCheap();
        UNSIGNED_INTS_TO_LONG = MethodRef.create(UnsignedInts.class, "toLong", Integer.TYPE).asCheap();
        LONG_TO_STRING = MethodRef.create(Long.class, "toString", Long.TYPE);
        NUMBER_DOUBLE_VALUE = MethodRef.create(Number.class, "doubleValue", new Class[0]).asCheap();
        NUMBER_LONG_VALUE = MethodRef.create(Number.class, "longValue", new Class[0]).asCheap();
        NUMBER_INT_VALUE = MethodRef.create(Number.class, "intValue", new Class[0]).asCheap();
        OBJECT_TO_STRING = MethodRef.create(Object.class, "toString", new Class[0]);
        OBJECTS_EQUALS = MethodRef.create(Objects.class, "equals", Object.class, Object.class);
        ORDAIN_AS_SAFE = MethodRef.create(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class);
        ORDAIN_AS_SAFE_DIR = MethodRef.create(UnsafeSanitizedContentOrdainer.class, "ordainAsSafe", String.class, SanitizedContent.ContentKind.class, Dir.class);
        LIST_UNBOX_INTS = MethodRef.create(JbcSrcRuntime.class, "listUnboxInts", List.class);
        LIST_UNBOX_FLOATS = MethodRef.create(JbcSrcRuntime.class, "listUnboxFloats", List.class);
        LIST_UNBOX_BOOLS = MethodRef.create(JbcSrcRuntime.class, "listUnboxBools", List.class);
        LIST_UNBOX_STRINGS = MethodRef.create(JbcSrcRuntime.class, "listUnboxStrings", List.class);
        LIST_UNBOX_PROTOS = MethodRef.create(JbcSrcRuntime.class, "listUnboxProtos", List.class);
        LIST_UNBOX_ENUMS = MethodRef.create(JbcSrcRuntime.class, "listUnboxEnums", List.class, Class.class);
        LIST_BOX_VALUES = MethodRef.create(JbcSrcRuntime.class, "listBoxValues", List.class);
        UNBOX_MAP = MethodRef.create(JbcSrcRuntime.class, "unboxMap", SoyMap.class, Class.class, Class.class);
        UNBOX_RECORD = MethodRef.create(JbcSrcRuntime.class, "unboxRecord", SoyRecord.class);
        SOY_VALUE_TO_BOXED_INTEGER = MethodRef.create(JbcSrcRuntime.class, "toBoxedInteger", SoyValue.class);
        SOY_VALUE_TO_BOXED_DOUBLE = MethodRef.create(JbcSrcRuntime.class, "toBoxedDouble", SoyValue.class);
        SOY_VALUE_TO_BOXED_FLOAT = MethodRef.create(JbcSrcRuntime.class, "toBoxedFloat", SoyValue.class);
        SOY_VALUE_TO_ENUM = MethodRef.create(JbcSrcRuntime.class, "toEnum", SoyValue.class, Class.class);
        SOY_VALUE_TO_BOXED_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "toBoxedBoolean", SoyValue.class);
        SOY_VALUE_TO_BOXED_LONG = MethodRef.create(JbcSrcRuntime.class, "toBoxedLong", SoyValue.class);
        PARAM_STORE_SET_FIELD = MethodRef.create(JbcSrcRuntime.class, "setField", ParamStore.class, String.class, SoyValueProvider.class);
        PRINT_STREAM_PRINTLN = MethodRef.create(PrintStream.class, "println", new Class[0]);
        SOY_PROTO_VALUE_CREATE = MethodRef.create(SoyProtoValue.class, "create", Message.class).asNonNullable();
        RENDER_RESULT_DONE = MethodRef.create(RenderResult.class, "done", new Class[0]).asCheap().asNonNullable();
        RENDER_RESULT_IS_DONE = MethodRef.create(RenderResult.class, "isDone", new Class[0]).asCheap();
        RENDER_RESULT_LIMITED = MethodRef.create(RenderResult.class, "limited", new Class[0]).asCheap().asNonNullable();
        RUNTIME_APPLY_ESCAPERS = MethodRef.create(JbcSrcRuntime.class, "applyEscapers", CompiledTemplate.class, ImmutableList.class);
        RUNTIME_CHECK_RESOLVED_LIST = MethodRef.create(JbcSrcRuntime.class, "checkResolved", List.class);
        RUNTIME_CHECK_RESOLVED_MAP = MethodRef.create(JbcSrcRuntime.class, "checkResolved", Map.class);
        SOY_SERVER_KEY = MethodRef.create(SharedRuntime.class, "soyServerKey", SoyValue.class).asCheap();
        RUNTIME_RANGE_LOOP_LENGTH = MethodRef.create(JbcSrcRuntime.class, "rangeLoopLength", Integer.TYPE, Integer.TYPE, Integer.TYPE).asCheap();
        RUNTIME_APPLY_PRINT_DIRECTIVE = MethodRef.create(JbcSrcRuntime.class, "applyPrintDirective", SoyJavaPrintDirective.class, SoyValue.class, List.class);
        RUNTIME_BIND_TEMPLATE_PARAMS = MethodRef.create(JbcSrcRuntime.class, "bindTemplateParams", CompiledTemplate.TemplateValue.class, SoyRecord.class);
        RUNTIME_CALL_LEGACY_FUNCTION = MethodRef.create(JbcSrcRuntime.class, "callLegacySoyFunction", LegacyFunctionAdapter.class, List.class);
        RUNTIME_COERCE_DOUBLE_TO_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "coerceToBoolean", Double.TYPE);
        RUNTIME_COERCE_TO_STRING = MethodRef.create(JbcSrcRuntime.class, "coerceToString", SoyValue.class).asNonNullable();
        RUNTIME_COERCE_TO_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "coerceToBoolean", SoyValue.class);
        RUNTIME_COERCE_STRING_TO_BOOLEAN = MethodRef.create(JbcSrcRuntime.class, "coerceToBoolean", String.class);
        RUNTIME_EQUAL = MethodRef.create(SharedRuntime.class, "equal", SoyValue.class, SoyValue.class);
        RUNTIME_COMPARE_STRING = MethodRef.create(SharedRuntime.class, "compareString", String.class, SoyValue.class);
        RUNTIME_COMPARE_NULLABLE_STRING = MethodRef.create(JbcSrcRuntime.class, "compareNullableString", String.class, SoyValue.class);
        RUNTIME_HAS_FIELD = MethodRef.create(JbcSrcRuntime.class, "hasField", SoyRecord.class, String.class);
        RUNTIME_GET_FIELD = MethodRef.create(JbcSrcRuntime.class, "getField", SoyRecord.class, String.class);
        RUNTIME_GET_FIELD_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getFieldProvider", SoyRecord.class, String.class).asNonNullable();
        RUNTIME_PARAM_OR_DEFAULT = MethodRef.create(JbcSrcRuntime.class, "paramOrDefault", SoyValueProvider.class, SoyValue.class).asNonNullable().asCheap();
        RUNTIME_PARAM = MethodRef.create(JbcSrcRuntime.class, "param", SoyValueProvider.class).asNonNullable().asCheap();
        RUNTIME_GET_FIELD_PROVIDER_DEFAULT = MethodRef.create(JbcSrcRuntime.class, "getFieldProvider", SoyRecord.class, String.class, SoyValue.class).asNonNullable();
        IS_PARAM_SET = MethodRef.create(JbcSrcRuntime.class, "isParamSet", SoyValueProvider.class).asCheap();
        RUNTIME_GET_LIST_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyListItem", List.class, Long.TYPE);
        RUNTIME_GET_LIST_ITEM_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getSoyListItemProvider", List.class, Long.TYPE);
        RUNTIME_GET_LIST_STATUS = MethodRef.create(JbcSrcRuntime.class, "getListStatus", List.class);
        RUNTIME_GET_MAP_STATUS = MethodRef.create(JbcSrcRuntime.class, "getMapStatus", Map.class);
        RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyLegacyObjectMapItem", SoyLegacyObjectMap.class, SoyValue.class);
        RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getSoyLegacyObjectMapItemProvider", SoyLegacyObjectMap.class, SoyValue.class);
        RUNTIME_GET_MAP_ITEM = MethodRef.create(JbcSrcRuntime.class, "getSoyMapItem", SoyMap.class, SoyValue.class);
        RUNTIME_GET_MAP_ITEM_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "getSoyMapItemProvider", SoyMap.class, SoyValue.class);
        RUNTIME_LESS_THAN = MethodRef.create(SharedRuntime.class, "lessThan", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_LESS_THAN_OR_EQUAL = MethodRef.create(SharedRuntime.class, "lessThanOrEqual", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_LOGGER = MethodRef.create(JbcSrcRuntime.class, "logger", new Class[0]).asCheap().asNonNullable();
        RUNTIME_DEBUGGER = MethodRef.create(JbcSrcRuntime.class, "debugger", String.class, Integer.TYPE);
        RUNTIME_MINUS = MethodRef.create(SharedRuntime.class, "minus", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_NEGATIVE = MethodRef.create(SharedRuntime.class, "negative", SoyValue.class).asNonNullable();
        RUNTIME_PLUS = MethodRef.create(SharedRuntime.class, "plus", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_MOD = MethodRef.create(SharedRuntime.class, "mod", SoyValue.class, SoyValue.class).asNonNullable();
        CONSTRUCT_MAP_FROM_LIST = MethodRef.create(SharedRuntime.class, "constructMapFromList", List.class).asNonNullable();
        MSG_RENDERER_SET_PLACEHOLDER = MethodRef.create(JbcSrcRuntime.MsgRenderer.class, "setPlaceholder", String.class, SoyValueProvider.class);
        HANDLE_BASIC_TRANSLATION = MethodRef.create(JbcSrcRuntime.class, "handleBasicTranslation", List.class).asNonNullable();
        HANDLE_BASIC_TRANSLATION_AND_ESCAPE_HTML = MethodRef.create(JbcSrcRuntime.class, "handleBasicTranslationAndEscapeHtml", List.class).asNonNullable();
        MSG_RENDERER_SET_PLACEHOLDER_AND_ORDERING = MethodRef.create(JbcSrcRuntime.MsgRenderer.class, "setPlaceholderAndOrdering", String.class, SoyValueProvider.class, String.class);
        RUNTIME_STRING_EQUALS_AS_NUMBER = MethodRef.create(JbcSrcRuntime.class, "stringEqualsAsNumber", String.class, Double.TYPE).asNonNullable();
        RUNTIME_TIMES = MethodRef.create(SharedRuntime.class, "times", SoyValue.class, SoyValue.class).asNonNullable();
        RUNTIME_UNEXPECTED_STATE_ERROR = MethodRef.create(JbcSrcRuntime.class, "unexpectedStateError", StackFrame.class).asNonNullable();
        NO_EXTERN_JAVA_IMPL = MethodRef.create(JbcSrcRuntime.class, "noExternJavaImpl", new Class[0]).asNonNullable();
        SOY_LIST_AS_JAVA_LIST = MethodRef.create(SoyList.class, "asJavaList", new Class[0]).asNonNullable();
        SOY_DICT_IMPL_AS_JAVA_MAP = MethodRef.create(DictImpl.class, "asJavaMap", new Class[0]).asNonNullable();
        SOY_MAP_IMPL_AS_JAVA_MAP = MethodRef.create(SoyMap.class, "asJavaMap", new Class[0]).asNonNullable();
        SOY_PROTO_VALUE_GET_PROTO = MethodRef.create(SoyProtoValue.class, "getProto", new Class[0]).asCheap().asNonNullable();
        SOY_VALUE_COERCE_TO_BOOLEAN = MethodRef.create(SoyValue.class, "coerceToBoolean", new Class[0]).asCheap();
        SOY_VALUE_BOOLEAN_VALUE = MethodRef.create(SoyValue.class, "booleanValue", new Class[0]).asCheap();
        SOY_VALUE_FLOAT_VALUE = MethodRef.create(SoyValue.class, "floatValue", new Class[0]).asCheap();
        SOY_VALUE_LONG_VALUE = MethodRef.create(SoyValue.class, "longValue", new Class[0]).asCheap();
        SOY_VALUE_INTEGER_VALUE = MethodRef.create(SoyValue.class, "integerValue", new Class[0]).asCheap();
        SOY_VALUE_NUMBER_VALUE = MethodRef.create(SoyValue.class, "numberValue", new Class[0]).asNonNullable();
        SOY_VALUE_JAVA_NUMBER_VALUE = MethodRef.create(NumberData.class, "javaNumberValue", new Class[0]).asNonNullable();
        SOY_VALUE_STRING_VALUE = MethodRef.create(SoyValue.class, "stringValue", new Class[0]).asCheap().asNonNullable();
        COMPILED_TEMPLATE_GET_TEMPLATE = MethodRef.create(CompiledTemplate.TemplateValue.class, "getTemplate", new Class[0]).asNonNullable();
        SOY_VALUE_PROVIDER_RENDER_AND_RESOLVE = MethodRef.create(SoyValueProvider.class, "renderAndResolve", LoggingAdvisingAppendable.class, Boolean.TYPE).asNonNullable();
        CONVERT_FUTURE_TO_SOY_VALUE_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "convertFutureToSoyValueProvider", Future.class);
        CONVERT_OBJECT_TO_SOY_VALUE_PROVIDER = MethodRef.create(JbcSrcRuntime.class, "convertObjectToSoyValueProvider", Object.class);
        CONVERT_SAFE_URL_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromSafeUrl", SafeUrl.class);
        CONVERT_SAFE_URL_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromSafeUrlProto", SafeUrlProto.class);
        CONVERT_TRUSTED_RESOURCE_URL_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromTrustedResourceUrlProto", TrustedResourceUrlProto.class);
        CONVERT_SAFE_HTML_PROTO_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromSafeHtmlProto", SafeHtmlProto.class);
        CONVERT_SAFE_HTML_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromSafeHtml", SafeHtml.class);
        CONVERT_TRUSTED_RESOURCE_URL_TO_SOY_VALUE_PROVIDER = MethodRef.create(SanitizedContents.class, "fromTrustedResourceUrl", TrustedResourceUrl.class);
        SOY_VALUE_PROVIDER_RESOLVE = MethodRef.create(JbcSrcRuntime.class, "resolveSoyValueProvider", SoyValueProvider.class);
        SOY_VALUE_PROVIDER_OR_NULL = MethodRef.create(JbcSrcRuntime.class, "soyValueProviderOrNull", SoyValueProvider.class);
        LONG_TO_INT = MethodRef.create(JbcSrcRuntime.class, "longToInt", Long.TYPE);
        SOY_VALUE_PROVIDER_STATUS = MethodRef.create(SoyValueProvider.class, "status", new Class[0]).asNonNullable();
        STRING_CONCAT = MethodRef.create(String.class, "concat", String.class).asNonNullable();
        STRING_IS_EMPTY = MethodRef.create(String.class, "isEmpty", new Class[0]);
        STRING_VALUE_OF = MethodRef.create(String.class, "valueOf", Object.class).asNonNullable();
        BOX_INTEGER = MethodRef.create(Integer.class, "valueOf", Integer.TYPE).asNonNullable();
        BOX_LONG = MethodRef.create(Long.class, "valueOf", Long.TYPE).asNonNullable();
        BOX_DOUBLE = MethodRef.create(Double.class, "valueOf", Double.TYPE).asNonNullable();
        BOX_FLOAT = MethodRef.create(Float.class, "valueOf", Float.TYPE).asNonNullable();
        BOX_BOOLEAN = MethodRef.create(Boolean.class, "valueOf", Boolean.TYPE).asNonNullable();
        UNBOX_INTEGER = MethodRef.create(Integer.class, "longValue", new Class[0]).asNonNullable();
        UNBOX_LONG = MethodRef.create(Long.class, "longValue", new Class[0]).asNonNullable();
        UNBOX_DOUBLE = MethodRef.create(Double.class, "doubleValue", new Class[0]).asNonNullable();
        UNBOX_FLOAT = MethodRef.create(Float.class, "doubleValue", new Class[0]).asNonNullable();
        UNBOX_BOOLEAN = MethodRef.create(Boolean.class, "booleanValue", new Class[0]).asNonNullable();
        UNBOX_OBJECT = MethodRef.create(SoyValueUnconverter.class, "unconvert", SoyValueProvider.class);
        UNBOX_SAFE_URL = MethodRef.create(JbcSrcRuntime.class, "unboxSafeUrl", SoyValueProvider.class);
        UNBOX_SAFE_HTML_PROTO = MethodRef.create(JbcSrcRuntime.class, "unboxSafeHtmlProto", SoyValueProvider.class);
        UNBOX_SAFE_URL_PROTO = MethodRef.create(JbcSrcRuntime.class, "unboxSafeUrlProto", SoyValueProvider.class);
        UNBOX_TRUSTED_RESOURCE_URL_PROTO = MethodRef.create(JbcSrcRuntime.class, "unboxTrustedResourceUrlProto", SoyValueProvider.class);
        UNBOX_SAFE_HTML = MethodRef.create(JbcSrcRuntime.class, "unboxSafeHtml", SoyValueProvider.class);
        UNBOX_TRUSTED_RESOURCE_URL = MethodRef.create(JbcSrcRuntime.class, "unboxTrustedResourceUrl", SoyValueProvider.class);
        STRING_DATA_FOR_VALUE = MethodRef.create(StringData.class, "forValue", String.class).asCheap().asNonNullable();
        LOGGING_ADVISING_APPENDABLE_BUFFERING = MethodRef.create(LoggingAdvisingAppendable.class, "buffering", new Class[0]).asNonNullable();
        BUFFERED_SOY_VALUE_PROVIDER_CREATE = MethodRef.create(BufferedSoyValueProvider.class, "create", LoggingAdvisingAppendable.BufferingAppendable.class).asNonNullable();
        CREATE_LOG_STATEMENT = MethodRef.create(JbcSrcRuntime.class, "createLogStatement", Boolean.TYPE, SoyVisualElementData.class);
        CLOSEABLE_CLOSE = MethodRef.create(Closeable.class, "close", new Class[0]);
        LEGACY_ADAPTER_COMPUTE = MethodRef.create(LegacyFunctionAdapter.METHOD);
        PROTOCOL_ENUM_GET_NUMBER = MethodRef.create(ProtocolMessageEnum.class, "getNumber", new Class[0]).asCheap();
        SOY_VISUAL_ELEMENT_CREATE = MethodRef.create(SoyVisualElement.class, "create", Long.TYPE, String.class);
        SOY_VISUAL_ELEMENT_DATA_CREATE = MethodRef.create(SoyVisualElementData.class, "create", SoyVisualElement.class, Message.class);
        FLUSH_LOGS_AND_RENDER = MethodRef.create(JbcSrcRuntime.class, "flushLogsAndRender", SoyValueProvider.class, SoyLogger.class);
        BOX_JAVA_MAP_AS_SOY_MAP = MethodRef.create(JbcSrcRuntime.class, "boxJavaMapAsSoyMap", Map.class);
        BOX_JAVA_MAP_AS_SOY_RECORD = MethodRef.create(JbcSrcRuntime.class, "boxJavaMapAsSoyRecord", Map.class);
        BOX_JAVA_MAP_AS_SOY_LEGACY_OBJECT_MAP = MethodRef.create(JbcSrcRuntime.class, "boxJavaMapAsSoyLegacyObjectMap", Map.class);
        LAZY_PROTO_TO_SOY_VALUE_LIST_FOR_LIST = MethodRef.create(LazyProtoToSoyValueList.class, "forList", List.class, ProtoFieldInterpreter.class).asNonNullable();
        LAZY_PROTO_TO_SOY_VALUE_MAP_FOR_MAP = MethodRef.create(LazyProtoToSoyValueMap.class, "forMap", Map.class, ProtoFieldInterpreter.class, ProtoFieldInterpreter.class, Class.class).asNonNullable();
        GET_EXTENSION_LIST = MethodRef.create(JbcSrcRuntime.class, "getExtensionList", GeneratedMessage.ExtendableMessage.class, ExtensionLite.class, ProtoFieldInterpreter.class).asNonNullable();
        SOY_RECORD_GET_FIELD_PROVIDER = MethodRef.create(SoyRecord.class, "getFieldProvider", String.class);
    }
}

