/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElement;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.jbcsrc.shared.SaveStateMetaFactory;
import com.google.template.soy.jbcsrc.shared.StackFrame;
import com.google.template.soy.logging.LoggableElementMetadata;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

public final class ClassLoaderFallbackCallFactory {
    private static final MethodType SLOWPATH_RENDER_TYPE = MethodType.methodType(RenderResult.class, String.class, SoyRecord.class, SoyRecord.class, LoggingAdvisingAppendable.class, RenderContext.class);
    private static final MethodType POSITIONAL_TO_RECORD_TYPE = MethodType.methodType(SoyRecord.class, String[].class, SoyValueProvider[].class);
    private static final MethodType SLOWPATH_TEMPLATE_TYPE = MethodType.methodType(CompiledTemplate.class, String.class, RenderContext.class);
    private static final MethodType SLOWPATH_TEMPLATE_VALUE_TYPE = MethodType.methodType(CompiledTemplate.TemplateValue.class, String.class, RenderContext.class);
    private static final MethodType RENDER_TYPE = MethodType.methodType(RenderResult.class, SoyRecord.class, SoyRecord.class, LoggingAdvisingAppendable.class, RenderContext.class);
    private static final MethodType VE_METADATA_SLOW_PATH_TYPE = MethodType.methodType(LoggableElementMetadata.class, String.class, RenderContext.class, Long.TYPE);
    private static final MethodType CREATE_VE_TYPE = MethodType.methodType(SoyVisualElement.class, Long.TYPE, String.class, LoggableElementMetadata.class);
    private static final MethodType TEMPLATE_ACCESSOR_TYPE = MethodType.methodType(CompiledTemplate.class);

    private ClassLoaderFallbackCallFactory() {
    }

    public static CallSite bootstrapTemplateLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) throws NoSuchMethodException, IllegalAccessException {
        Optional<Class<?>> templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName);
        if (templateClass.isPresent()) {
            CompiledTemplate template = ClassLoaderFallbackCallFactory.getTemplate(lookup, templateClass.get(), templateName);
            MethodHandle getter = MethodHandles.constant(CompiledTemplate.class, template);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            return new ConstantCallSite(getter);
        }
        MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "slowpathTemplate", SLOWPATH_TEMPLATE_TYPE);
        handle = MethodHandles.insertArguments(handle, 0, templateName);
        return new ConstantCallSite(handle);
    }

    public static CallSite bootstrapTemplateValueLookup(MethodHandles.Lookup lookup, String name, MethodType type, String templateName) throws NoSuchMethodException, IllegalAccessException {
        Optional<Class<?>> templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName);
        if (templateClass.isPresent()) {
            CompiledTemplate template = ClassLoaderFallbackCallFactory.getTemplate(lookup, templateClass.get(), templateName);
            CompiledTemplate.TemplateValue value = CompiledTemplate.TemplateValue.create(templateName, template);
            MethodHandle getter = MethodHandles.constant(CompiledTemplate.TemplateValue.class, value);
            getter = MethodHandles.dropArguments(getter, 0, new Class[]{RenderContext.class});
            return new ConstantCallSite(getter);
        }
        MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "slowPathTemplateValue", SLOWPATH_TEMPLATE_VALUE_TYPE);
        handle = MethodHandles.insertArguments(handle, 0, templateName);
        return new ConstantCallSite(handle);
    }

    private static CompiledTemplate getTemplate(MethodHandles.Lookup lookup, Class<?> templateClass, String templateName) throws NoSuchMethodException, IllegalAccessException {
        String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
        MethodHandle templateAccessor = lookup.findStatic(templateClass, methodName, TEMPLATE_ACCESSOR_TYPE);
        try {
            return templateAccessor.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public static CallSite bootstrapCall(MethodHandles.Lookup lookup, String name, MethodType type, String templateName, String ... paramNames) throws IllegalAccessException, NoSuchMethodException {
        Optional<Class<?>> templateClass = ClassLoaderFallbackCallFactory.findTemplateClass(lookup, templateName);
        String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
        if (templateClass.isPresent()) {
            return new ConstantCallSite(lookup.findStatic(templateClass.get(), methodName, type));
        }
        MethodHandle slowPathRenderHandle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "slowPathRender", SLOWPATH_RENDER_TYPE);
        slowPathRenderHandle = MethodHandles.insertArguments(slowPathRenderHandle, 0, templateName);
        if (!type.equals((Object)RENDER_TYPE)) {
            MethodHandle positionalToRecordHandle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "positionalToRecord", POSITIONAL_TO_RECORD_TYPE);
            positionalToRecordHandle = MethodHandles.insertArguments(positionalToRecordHandle, 0, new Object[]{paramNames});
            positionalToRecordHandle = positionalToRecordHandle.asCollector(SoyValueProvider[].class, paramNames.length);
            slowPathRenderHandle = MethodHandles.collectArguments(slowPathRenderHandle, 0, positionalToRecordHandle);
        }
        return new ConstantCallSite(slowPathRenderHandle);
    }

    public static CallSite bootstrapVeWithMetadata(MethodHandles.Lookup lookup, String name, MethodType type, String metadataClassName) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle metadataGetter = ClassLoaderFallbackCallFactory.getMetadataGetter(lookup, metadataClassName);
        MethodHandle createVe = lookup.findStatic(SoyVisualElement.class, "create", CREATE_VE_TYPE);
        MethodHandle handle = MethodHandles.collectArguments(createVe, 2, metadataGetter);
        return new ConstantCallSite(handle);
    }

    private static MethodHandle getMetadataGetter(MethodHandles.Lookup lookup, String metadataClassName) throws NoSuchMethodException, IllegalAccessException {
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        try {
            Class<?> metadataClass = callerClassLoader.loadClass(metadataClassName);
            MethodHandle handle = lookup.findStatic(metadataClass, "getMetadata", MethodType.methodType(LoggableElementMetadata.class, Long.TYPE));
            return MethodHandles.dropArguments(handle, 0, new Class[]{RenderContext.class});
        }
        catch (ClassNotFoundException metadataClass) {
            MethodHandle handle = lookup.findStatic(ClassLoaderFallbackCallFactory.class, "veMetadataSlowPath", VE_METADATA_SLOW_PATH_TYPE);
            return MethodHandles.insertArguments(handle, 0, metadataClassName);
        }
    }

    private static Optional<Class<?>> findTemplateClass(MethodHandles.Lookup lookup, String templateName) throws NoSuchMethodException {
        Method method;
        Class<?> clazz;
        ClassLoader callerClassLoader = lookup.lookupClass().getClassLoader();
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        try {
            clazz = callerClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
        if (clazz.getClassLoader() instanceof AlwaysSlowPath && Modifier.isPublic((method = clazz.getDeclaredMethod(Names.renderMethodNameFromSoyTemplateName(templateName), new Class[0])).getModifiers())) {
            return Optional.empty();
        }
        return Optional.of(clazz);
    }

    public static CompiledTemplate slowPathTemplate(String templateName, RenderContext context) {
        return context.getTemplate(templateName);
    }

    public static CompiledTemplate.TemplateValue slowPathTemplateValue(String templateName, RenderContext context) {
        return CompiledTemplate.TemplateValue.create(templateName, context.getTemplate(templateName));
    }

    public static SoyRecord positionalToRecord(String[] names, SoyValueProvider[] values) {
        ParamStore paramStore = new ParamStore(names.length);
        for (int i = 0; i < names.length; ++i) {
            if (values[i] == null) continue;
            paramStore.setField(names[i], values[i]);
        }
        return paramStore;
    }

    public static RenderResult slowPathRender(String templateName, SoyRecord params, SoyRecord ij, LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
        CompiledTemplate template;
        StackFrame frame = context.popFrame();
        switch (frame.stateNumber) {
            case 0: {
                template = context.getTemplate(templateName);
                break;
            }
            case 1: {
                try {
                    template = SaveRestoreState.restoreTemplateHandle.invokeExact(frame);
                    break;
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)t);
                }
            }
            default: {
                throw new AssertionError((Object)("unexpected state: " + frame));
            }
        }
        RenderResult result = template.render(params, ij, appendable, context);
        if (!result.isDone()) {
            try {
                SaveRestoreState.saveStateMethodHandle.invokeExact(context, template);
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
        return result;
    }

    public static LoggableElementMetadata veMetadataSlowPath(String metadataClassName, RenderContext renderContext, long veId) {
        return renderContext.getVeMetadata(metadataClassName, veId);
    }

    private static class SaveRestoreState {
        static final MethodHandle saveStateMethodHandle;
        static final MethodHandle restoreTemplateHandle;

        private SaveRestoreState() {
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType saveMethodType = MethodType.methodType(Void.TYPE, RenderContext.class, CompiledTemplate.class);
            saveStateMethodHandle = SaveStateMetaFactory.bootstrapSaveState(lookup, "saveState", saveMethodType, 1).getTarget();
            restoreTemplateHandle = SaveStateMetaFactory.bootstrapRestoreState(lookup, "restoreLocal", MethodType.methodType(CompiledTemplate.class, StackFrame.class), saveMethodType, 0).getTarget();
        }
    }

    @VisibleForTesting
    public static interface AlwaysSlowPath {
    }
}

