/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.internal.exemptions.NamespaceExemptions;

public final class Names {
    public static final String META_INF_DELTEMPLATE_PATH = "META-INF/services/com.google.template.soy.deltemplates";
    public static final String META_INF_PLUGIN_PATH = "META-INF/services/com.google.template.soy.plugins";
    public static final String CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.";
    public static final String INTERNAL_CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.".replace('.', '/');

    private Names() {
    }

    public static String javaClassNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        Preconditions.checkArgument((lastDot != -1 ? 1 : 0) != 0, (String)"%s should contain a dot", (Object)soyTemplate);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        return NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace) ? CLASS_PREFIX + soyTemplate : CLASS_PREFIX + soyNamespace;
    }

    public static String javaClassNameFromSoyNamespace(String soyTemplateNamespace) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplateNamespace), (String)"%s is not a valid template namespace.", (Object)soyTemplateNamespace);
        Preconditions.checkArgument((!NamespaceExemptions.isKnownDuplicateNamespace(soyTemplateNamespace) ? 1 : 0) != 0);
        return CLASS_PREFIX + soyTemplateNamespace;
    }

    public static String renderMethodNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        if (NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace)) {
            return "render";
        }
        return soyTemplate.substring(lastDot + 1);
    }

    public static String templateMethodNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyTemplate), (String)"%s is not a valid template name.", (Object)soyTemplate);
        int lastDot = soyTemplate.lastIndexOf(46);
        String soyNamespace = soyTemplate.substring(0, lastDot);
        if (NamespaceExemptions.isKnownDuplicateNamespace(soyNamespace)) {
            return "template";
        }
        return "template$" + soyTemplate.substring(lastDot + 1);
    }

    public static String javaFileName(String soyNamespace, String fileName) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(soyNamespace), (String)"%s is not a valid soy namspace name.", (Object)soyNamespace);
        String javaClassName = Names.javaClassNameFromSoyTemplateName(soyNamespace + ".foo");
        String javaPackageName = javaClassName.substring(0, javaClassName.lastIndexOf(46));
        return javaPackageName.replace('.', '/') + '/' + fileName;
    }

    public static void rewriteStackTrace(Throwable throwable) {
        StackTraceElement[] stack = throwable.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement curr = stack[i];
            if (!curr.getClassName().startsWith(CLASS_PREFIX)) continue;
            stack[i] = new StackTraceElement(curr.getClassName().substring(CLASS_PREFIX.length()), curr.getMethodName(), curr.getFileName(), curr.getLineNumber());
        }
        throwable.setStackTrace(stack);
    }
}

