/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_ObjectLiteral;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

@Immutable
@AutoValue
abstract class ObjectLiteral
extends Expression {
    ObjectLiteral() {
    }

    abstract ImmutableMap<Expression, Expression> values();

    static ObjectLiteral create(Map<String, Expression> object) {
        return ObjectLiteral.create(object, Expression::id);
    }

    private static ObjectLiteral create(Map<String, Expression> object, Function<String, Expression> createKeyFn) {
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<String, Expression> entry : object.entrySet()) {
            initialStatements.addAll(entry.getValue().initialStatements());
            values.put((Object)createKeyFn.apply(entry.getKey()), (Object)entry.getValue());
        }
        return new AutoValue_ObjectLiteral((ImmutableList<Statement>)initialStatements.build(), (ImmutableMap<Expression, Expression>)values.build());
    }

    static ObjectLiteral createWithQuotedKeys(Map<String, Expression> object) {
        return ObjectLiteral.create(object, Expression::stringLiteral);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append('{');
        boolean first = true;
        for (Map.Entry entry : this.values().entrySet()) {
            if (!first) {
                ctx.append(", ");
            }
            first = false;
            ctx.appendOutputExpression((Expression)entry.getKey()).append(": ").appendOutputExpression((Expression)entry.getValue());
        }
        ctx.append('}');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (Expression value : this.values().values()) {
            ctx.appendInitialStatements(value);
        }
    }

    @Override
    public void collectRequires(Consumer<GoogRequire> collector) {
        for (Expression value : this.values().values()) {
            value.collectRequires(collector);
        }
    }

    @Override
    boolean initialExpressionIsObjectLiteral() {
        return true;
    }
}

