/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.internal.AutoValue_GenCallCodeUtils_Callee;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.TemplateType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GenCallCodeUtils {
    private final DelTemplateNamer delTemplateNamer;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    static boolean hasPositionalSignature(TemplateMetadata metadata) {
        return GenCallCodeUtils.hasPositionalSignature(metadata.getTemplateType());
    }

    static boolean hasPositionalSignature(TemplateType type) {
        return type.getDataAllCallSituations().isEmpty() && !type.getActualParameters().isEmpty() && type.getTemplateKind() == TemplateType.TemplateKind.BASIC;
    }

    protected GenCallCodeUtils(DelTemplateNamer delTemplateNamer, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.delTemplateNamer = delTemplateNamer;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
    }

    public Expression gen(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Expression call;
        Callee callee = this.genCallee(callNode, templateAliases, exprTranslator);
        if (this.canPerformPositionalCall(callNode)) {
            ArrayList<Expression> params = new ArrayList<Expression>();
            params.add(JsRuntime.SOY_INTERNAL_CALL_MARKER);
            params.add(JsRuntime.IJ_DATA);
            params.addAll(this.getPositionalParams((CallBasicNode)callNode, templateAliases, translationContext, errorReporter, exprTranslator));
            call = callee.positionalStyle().get().call(params);
        } else {
            Expression objToPass = this.genObjToPass(callNode, templateAliases, translationContext, errorReporter, exprTranslator);
            call = callee.objectStyle().call(objToPass, JsRuntime.IJ_DATA);
        }
        if (callNode.getEscapingDirectives().isEmpty()) {
            return call;
        }
        return GenCallCodeUtils.applyEscapingDirectives(call, callNode);
    }

    public List<Expression> getPositionalParams(CallBasicNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Map<String, Expression> explicitParams = this.getExplicitParams(callNode, templateAliases, translationContext, errorReporter, exprTranslator);
        List<Expression> params = new ArrayList<Expression>();
        int numTrailingUndefineds = 0;
        for (TemplateType.Parameter calleeParam : callNode.getStaticType().getActualParameters()) {
            Expression explicitParam = explicitParams.remove(calleeParam.getName());
            if (explicitParam == null) {
                ++numTrailingUndefineds;
                params.add(Expression.LITERAL_UNDEFINED);
                continue;
            }
            numTrailingUndefineds = 0;
            params.add(explicitParam);
        }
        Preconditions.checkState((boolean)explicitParams.isEmpty(), (String)"Expected all params to be consumed, %s remain", explicitParams);
        if (numTrailingUndefineds > 0) {
            params = params.subList(0, params.size() - numTrailingUndefineds);
        }
        return params;
    }

    public boolean canPerformPositionalCall(CallNode callNode) {
        if (callNode.isPassingData() || !(callNode instanceof CallBasicNode) || !((CallBasicNode)callNode).isStaticCall()) {
            return false;
        }
        return GenCallCodeUtils.hasPositionalSignature(((CallBasicNode)callNode).getStaticType());
    }

    public static Expression applyEscapingDirectives(Expression call, CallNode callNode) {
        JsExpr callResult = call.singleExprOrName();
        ImmutableSet.Builder requiresBuilder = ImmutableSet.builder();
        call.collectRequires(arg_0 -> ((ImmutableSet.Builder)requiresBuilder).add(arg_0));
        for (SoyPrintDirective directive : callNode.getEscapingDirectives()) {
            Preconditions.checkState((boolean)(directive instanceof SoyJsSrcPrintDirective), (String)"Contextual autoescaping produced a bogus directive: %s", (Object)directive.getName());
            callResult = ((SoyJsSrcPrintDirective)directive).applyForJsSrc(callResult, (List<JsExpr>)ImmutableList.of());
            if (!(directive instanceof SoyLibraryAssistedJsSrcPrintDirective)) continue;
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                requiresBuilder.add((Object)GoogRequire.create(name));
            }
        }
        return Expression.fromExpr(callResult, (Iterable<GoogRequire>)requiresBuilder.build()).withInitialStatements((Iterable<? extends Statement>)call.initialStatements());
    }

    public Callee genCallee(CallNode callNode, TemplateAliases templateAliases, TranslateExprNodeVisitor exprTranslator) {
        Expression callee;
        if (callNode instanceof CallBasicNode) {
            CallBasicNode callBasicNode = (CallBasicNode)callNode;
            if (callBasicNode.isStaticCall()) {
                callee = Expression.dottedIdNoRequire(templateAliases.get(callBasicNode.getCalleeName()));
            } else {
                Expression calleeExpression = (Expression)exprTranslator.exec(callBasicNode.getCalleeExpr());
                callee = JsRuntime.ASSERT_TEMPLATE.call(calleeExpression);
            }
        } else {
            CallDelegateNode callDelegateNode = (CallDelegateNode)callNode;
            Expression calleeId = JsRuntime.SOY_GET_DELTEMPLATE_ID.call(Expression.stringLiteral(this.delTemplateNamer.getDelegateName(callDelegateNode)));
            ExprRootNode variantSoyExpr = callDelegateNode.getDelCalleeVariantExpr();
            Expression variant = variantSoyExpr == null ? Expression.LITERAL_EMPTY_STRING : (Expression)exprTranslator.exec(variantSoyExpr);
            callee = JsRuntime.SOY_GET_DELEGATE_FN.call(calleeId, variant, callDelegateNode.allowEmptyDefault() ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE);
        }
        Optional<Expression> positional = Optional.empty();
        if (this.canPerformPositionalCall(callNode)) {
            positional = Optional.of(Expression.dottedIdNoRequire(templateAliases.get(((TemplateLiteralNode)((CallBasicNode)callNode).getCalleeExpr().getRoot()).getResolvedName()) + "$"));
        }
        return new AutoValue_GenCallCodeUtils_Callee(positional, callee);
    }

    public Expression genObjToPass(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        Optional<Object> dataToPass = Optional.empty();
        if (callNode.isPassingAllData()) {
            dataToPass = Optional.of(JsRuntime.OPT_DATA);
        } else if (callNode.isPassingData()) {
            dataToPass = Optional.of((Expression)exprTranslator.exec(callNode.getDataExpr()));
        }
        Map<String, Expression> params = this.getExplicitParams(callNode, templateAliases, translationContext, errorReporter, exprTranslator);
        if (callNode.isPassingAllData()) {
            LinkedHashMap<String, Expression> mergedParams = new LinkedHashMap<String, Expression>();
            mergedParams.putAll(this.getDefaultParams(callNode, translationContext));
            mergedParams.putAll(params);
            params = mergedParams;
        }
        if (dataToPass.isPresent()) {
            if (params.isEmpty()) {
                return ((Expression)dataToPass.get()).castAs("?");
            }
            return JsRuntime.SOY_ASSIGN_DEFAULTS.call(Expression.objectLiteral(params), (Expression)dataToPass.get());
        }
        if (params.isEmpty()) {
            return Expression.LITERAL_NULL;
        }
        return Expression.objectLiteral(params).castAs("?");
    }

    private Map<String, Expression> getExplicitParams(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter, TranslateExprNodeVisitor exprTranslator) {
        LinkedHashMap<String, Expression> params = new LinkedHashMap<String, Expression>();
        for (CallParamNode child : callNode.getChildren()) {
            Expression value;
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                value = (Expression)exprTranslator.exec(cpvn.getExpr());
            } else {
                CallParamContentNode cpcn = (CallParamContentNode)child;
                if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                    List<Expression> chunks = this.genJsExprsVisitorFactory.create(translationContext, templateAliases, errorReporter, exprTranslator.getDataSource()).exec(cpcn);
                    value = CodeChunkUtils.concatChunksForceString(chunks);
                } else {
                    value = Expression.id("param" + cpcn.getId());
                }
                value = this.maybeWrapContent(translationContext.codeGenerator(), cpcn, value);
            }
            params.put(child.getKey().identifier(), value);
        }
        return params;
    }

    private Map<String, Expression> getDefaultParams(CallNode node, TranslationContext translationContext) {
        LinkedHashMap<String, Expression> defaultParams = new LinkedHashMap<String, Expression>();
        for (TemplateParam param : node.getNearestAncestor(TemplateNode.class).getParams()) {
            if (!param.hasDefault()) continue;
            defaultParams.put(param.name(), translationContext.soyToJsVariableMappings().get(param.refName()));
        }
        return defaultParams;
    }

    protected Expression maybeWrapContent(CodeChunk.Generator generator, CallParamContentNode node, Expression content) {
        if (node.getContentKind() == SanitizedContentKind.TEXT) {
            return content;
        }
        return JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(content);
    }

    @AutoValue
    public static abstract class Callee {
        Callee() {
        }

        public abstract Optional<Expression> positionalStyle();

        public abstract Expression objectStyle();
    }
}

