/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.TaggedTemplateLiteral;
import com.google.template.soy.jssrc.dsl.TemplateLiteral;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.IsComputableAsLitTemplateVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.LitRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.List;

public class GenLitExprVisitor
extends AbstractSoyNodeVisitor<Expression> {
    private static final SoyErrorKind UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE = SoyErrorKind.of("Unknown SoyJsSrcPrintDirective ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
    protected final IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor;
    protected final TranslationContext translationContext;
    protected final ErrorReporter errorReporter;
    protected Expression generatedExpression;
    protected List<Statement> initialStatements = new ArrayList<Statement>();
    protected final TemplateAliases templateAliases;
    protected List<String> textParts = new ArrayList<String>();
    protected List<Expression> interpolatedParts = new ArrayList<Expression>();

    protected GenLitExprVisitor(JavaScriptValueFactoryImpl javaScriptValueFactory, IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor, TranslationContext translationContext, ErrorReporter errorReporter, TemplateAliases templateAliases) {
        this.javaScriptValueFactory = javaScriptValueFactory;
        this.isComputableAsLitTemplateVisitor = isComputableAsLitTemplateVisitor;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
        this.templateAliases = templateAliases;
    }

    @Override
    public Expression exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsLitTemplateVisitor.exec(node)));
        this.visit(node);
        return this.generatedExpression;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        Preconditions.checkState((this.generatedExpression == null ? 1 : 0) != 0);
        Preconditions.checkState((node.getContentKind() == SanitizedContentKind.TEXT || node.getContentKind() == SanitizedContentKind.HTML ? 1 : 0) != 0);
        this.visitChildren(node);
        if (this.textParts.size() == this.interpolatedParts.size()) {
            this.textParts.add("");
        }
        TemplateLiteral literal = TemplateLiteral.create((ImmutableList<String>)ImmutableList.copyOf(this.textParts), (ImmutableList<Expression>)ImmutableList.copyOf(this.interpolatedParts));
        this.generatedExpression = node.getContentKind() == SanitizedContentKind.TEXT ? literal : TaggedTemplateLiteral.create(LitRuntime.HTML, literal);
        this.generatedExpression = this.generatedExpression.withInitialStatements(this.initialStatements);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.textParts.add(node.getRawText());
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        Expression expr = this.translateExpr(node.getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyPrintDirective directive = directiveNode.getPrintDirective();
            if (!(directive instanceof SoyJsSrcPrintDirective)) {
                this.errorReporter.report(node.getSourceLocation(), UNKNOWN_SOY_JS_SRC_PRINT_DIRECTIVE, directiveNode.getName());
                return;
            }
            ImmutableList<ExprRootNode> argNodes = directiveNode.getArgs();
            ArrayList<Expression> argChunks = new ArrayList<Expression>(argNodes.size());
            for (ExprRootNode argNode : argNodes) {
                argChunks.add(this.translateExpr(argNode));
            }
            expr = SoyJsPluginUtils.applyDirective(expr, (SoyJsSrcPrintDirective)directive, argChunks, node.getSourceLocation(), this.errorReporter);
        }
        if (this.textParts.size() == this.interpolatedParts.size()) {
            this.textParts.add("");
        }
        this.interpolatedParts.add(expr);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        Expression value = this.translateExpr(node.getExpr());
        this.initialStatements.add(VariableDeclaration.builder(generatedVarName).setRhs(value).build());
        this.translationContext.soyToJsVariableMappings().put(node.getVar(), Expression.id(generatedVarName));
    }

    protected TranslateExprNodeVisitor getExprTranslator() {
        return new TranslateExprNodeVisitor(this.javaScriptValueFactory, this.translationContext, this.templateAliases, this.errorReporter, LitRuntime.DATA);
    }

    private Expression translateExpr(ExprRootNode argNode) {
        return (Expression)this.getExprTranslator().exec(argNode);
    }

    public static class GenLitExprVisitorFactory {
        protected final JavaScriptValueFactoryImpl javaScriptValueFactory;
        protected final IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor;

        protected GenLitExprVisitorFactory(JavaScriptValueFactoryImpl javaScriptValueFactory, IsComputableAsLitTemplateVisitor isComputableAsLitTemplateVisitor) {
            this.javaScriptValueFactory = javaScriptValueFactory;
            this.isComputableAsLitTemplateVisitor = isComputableAsLitTemplateVisitor;
        }

        public GenLitExprVisitor create(TranslationContext translationContext, TemplateAliases templateAliases, ErrorReporter errorReporter) {
            return new GenLitExprVisitor(this.javaScriptValueFactory, this.isComputableAsLitTemplateVisitor, translationContext, errorReporter, templateAliases);
        }
    }
}

