/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_RawTextContextUpdater_Processor_Result;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.JsLexerTokenManager;
import com.google.template.soy.parsepasses.contextautoesc.LexerError;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.RawTextNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class RawTextContextUpdater {
    private Context context;
    private static final Transition TRANSITION_TO_SELF = new Transition(){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior;
        }
    };
    private static final Transition URI_PART_TRANSITION = new Transition(Pattern.compile("([:./&?=#])|\\z")){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return prior.uriType() != Context.UriType.TRUSTED_RESOURCE;
        }

        @Override
        Context computeNextContext(RawTextNode node, int offset, Context prior, Matcher matcher) {
            String match;
            Context.UriPart uriPart = prior.uriPart();
            if (uriPart == Context.UriPart.START) {
                uriPart = Context.UriPart.MAYBE_SCHEME;
            }
            if ((match = matcher.group(1)) != null) {
                Preconditions.checkState((match.length() == 1 ? 1 : 0) != 0);
                uriPart = RawTextContextUpdater.getNextUriPart(node, offset, uriPart, match.charAt(0));
            }
            return prior.derive(uriPart);
        }
    };
    private static final Transition URI_START_TRANSITION = new Transition(Pattern.compile("(?i)^(javascript|data|blob|filesystem):")){

        @Override
        boolean isApplicableTo(Context prior, Matcher matcher) {
            return prior.uriPart() == Context.UriPart.START && prior.uriType() != Context.UriType.TRUSTED_RESOURCE;
        }

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(Context.UriPart.DANGEROUS_SCHEME);
        }
    };
    private static final ImmutableMap<HtmlContext, Processor> TRANSITIONS = ImmutableMap.builder().put((Object)HtmlContext.HTML_PCDATA, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_COMMENT, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_NORMAL_ATTR_VALUE, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_META_REFRESH_CONTENT, (Object)TransitionSetProcessor.of(new Transition(Pattern.compile("[,;] *(URL *=? *)?['\"]?", 2)){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.toBuilder().withState(HtmlContext.URI).withUriType(Context.UriType.REFRESH).withUriPart(Context.UriPart.START).build();
        }
    }, TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_HTML_ATTR_VALUE, (Object)TransitionSetProcessor.of(new Transition(){

        @Override
        Context computeNextContext(Context prior, Matcher matcher) {
            return prior.derive(Context.HtmlHtmlAttributePosition.NOT_START);
        }
    }, TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("/*", HtmlContext.CSS_COMMENT), RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS_DQ_STRING), RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS_SQ_STRING), RawTextContextUpdater.makeCssUriTransition(Pattern.compile("(?i)(?:[^a-z0-9-]|^)\\s*(?:background|background-image|border-image|content|cursor|list-style|list-style-image)\\s*:\\s*url\\s*\\(\\s*(['\"]?)"), Context.UriType.MEDIA), RawTextContextUpdater.makeCssUriTransition(Pattern.compile("@import\\b(?:\\s+url\\s*\\()?\\s*(['\"]?)"), Context.UriType.TRUSTED_RESOURCE), RawTextContextUpdater.makeCssUriTransition(Pattern.compile("(?i)\\burl\\s*\\(\\s*(['\"]?)"), Context.UriType.NORMAL), TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_COMMENT, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("*/", HtmlContext.CSS), TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_DQ_STRING, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS), RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f\"])")), RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literals."), TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_SQ_STRING, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS), RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f'])")), RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literals."), TRANSITION_TO_SELF)).put((Object)HtmlContext.CSS_URI, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToState(Pattern.compile("[\\)\\s]"), HtmlContext.CSS), URI_PART_TRANSITION, URI_START_TRANSITION, new TrustedResourceUriPartTransition(Pattern.compile("[^);\n\r\f]+")), RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\"']"), "Quotes not permitted in CSS URIs."))).put((Object)HtmlContext.CSS_SQ_URI, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("'", HtmlContext.CSS), URI_PART_TRANSITION, URI_START_TRANSITION, new TrustedResourceUriPartTransition(Pattern.compile("[^'\n\r\f]+")), RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f'])")), RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literal."))).put((Object)HtmlContext.CSS_DQ_URI, (Object)TransitionSetProcessor.of(RawTextContextUpdater.makeTransitionToStateLiteral("\"", HtmlContext.CSS), URI_PART_TRANSITION, URI_START_TRANSITION, new TrustedResourceUriPartTransition(Pattern.compile("[^\n\r\f\"]+")), RawTextContextUpdater.makeTransitionToSelf(Pattern.compile("\\\\(?:\r\n?|[\n\f\"])")), RawTextContextUpdater.makeTransitionToError(Pattern.compile("[\n\r\f]"), "Newlines not permitted in string literal."))).put((Object)HtmlContext.JS, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_BLOCK_COMMENT, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_LINE_COMMENT, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_DQ_STRING, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_SQ_STRING, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_TEMPLATE_LITERAL, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.JS_REGEX, (Object)JsLexerProcessor.INSTANCE).put((Object)HtmlContext.URI, (Object)TransitionSetProcessor.of(URI_PART_TRANSITION, URI_START_TRANSITION, new TrustedResourceUriPartTransition())).put((Object)HtmlContext.HTML_RCDATA, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).put((Object)HtmlContext.HTML_SCRIPT_PHRASING_DATA, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).put((Object)HtmlContext.TEXT, (Object)TransitionSetProcessor.of(TRANSITION_TO_SELF)).build();

    public static Context processRawText(RawTextNode rawTextNode, Context context) {
        String rawText = rawTextNode.getRawText();
        if (context.delimType() != Context.AttributeEndDelimiter.NONE) {
            rawText = UnescapeUtils.unescapeHtml(rawText);
        }
        int length = rawText.length();
        RawTextContextUpdater cu = new RawTextContextUpdater(context);
        for (int offset = 0; offset < length; offset += cu.processNextToken(rawTextNode, offset, rawText.substring(offset))) {
        }
        return cu.context;
    }

    private RawTextContextUpdater(Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
    }

    private int processNextToken(RawTextNode node, int offset, String text) {
        Processor processor = (Processor)TRANSITIONS.get((Object)this.context.state());
        if (processor == null) {
            throw new NullPointerException("no transitions for state: " + (Object)((Object)this.context.state()) + " @" + node.substringLocation(offset, offset + 1));
        }
        Processor.Result result = processor.processText(this.context, node, offset, text);
        this.context = result.nextContext();
        return result.numCharactersConsumed();
    }

    private static Transition makeTransitionToStateLiteral(String literal, final HtmlContext state) {
        return new Transition(literal){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.transitionToState(state);
            }
        };
    }

    private static Transition makeTransitionToState(Pattern regex, final HtmlContext state) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior.transitionToState(state);
            }
        };
    }

    private static Transition makeTransitionToError(Pattern regex, final String message) {
        return new Transition(regex){

            @Override
            Context computeNextContext(RawTextNode node, int offset, Context prior, Matcher matcher) {
                throw SoyAutoescapeException.createWithNode(message, node.substring(Integer.MAX_VALUE, offset));
            }
        };
    }

    private static Transition makeTransitionToSelf(Pattern regex) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                return prior;
            }
        };
    }

    private static Context.UriPart getNextUriPart(RawTextNode node, int offset, Context.UriPart uriPart, char matchChar) {
        switch (uriPart) {
            case MAYBE_SCHEME: 
            case MAYBE_VARIABLE_SCHEME: {
                if (matchChar == ':') {
                    if (uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                        throw SoyAutoescapeException.createWithNode("Soy can't safely process a URI that might start with a variable scheme. For example, {$x}:{$y} could have an XSS if $x is 'javascript' and $y is attacker-controlled. Either use a hard-coded scheme, or introduce disambiguating characters (e.g. http://{$x}:{$y}, ./{$x}:{$y}, or {$x}?foo=:{$y})", node.substring(Integer.MAX_VALUE, offset));
                    }
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if (matchChar == '/') {
                    return Context.UriPart.AUTHORITY_OR_PATH;
                }
                if ((matchChar == '=' || matchChar == '&') && uriPart == Context.UriPart.MAYBE_VARIABLE_SCHEME) {
                    return Context.UriPart.QUERY;
                }
            }
            case AUTHORITY_OR_PATH: 
            case UNKNOWN_PRE_FRAGMENT: {
                if (matchChar == '?') {
                    return Context.UriPart.QUERY;
                }
            }
            case QUERY: 
            case UNKNOWN: {
                if (matchChar == '#') {
                    return Context.UriPart.FRAGMENT;
                }
            }
            case FRAGMENT: {
                return uriPart;
            }
            case DANGEROUS_SCHEME: {
                return Context.UriPart.DANGEROUS_SCHEME;
            }
            case TRUSTED_RESOURCE_URI_END: {
                throw new AssertionError((Object)"impossible");
            }
        }
        throw new AssertionError((Object)("Unanticipated URI part: " + (Object)((Object)uriPart)));
    }

    private static Transition makeCssUriTransition(Pattern regex, final Context.UriType uriType) {
        return new Transition(regex){

            @Override
            Context computeNextContext(Context prior, Matcher matcher) {
                String delim = matcher.group(1);
                HtmlContext state = "\"".equals(delim) ? HtmlContext.CSS_DQ_URI : ("'".equals(delim) ? HtmlContext.CSS_SQ_URI : HtmlContext.CSS_URI);
                return prior.toBuilder().withState(state).withUriType(uriType).withUriPart(Context.UriPart.START).build();
            }
        };
    }

    private static final class JsLexerProcessor
    implements Processor {
        static final JsLexerProcessor INSTANCE = new JsLexerProcessor();

        private JsLexerProcessor() {
        }

        @Override
        public Processor.Result processText(Context context, RawTextNode node, int offset, String text) {
            try {
                Context next = JsLexerTokenManager.calculateTransitions(context, text, offset);
                return Processor.Result.create(next, text.length() - offset);
            }
            catch (LexerError le) {
                throw SoyAutoescapeException.createWithNode(le.getReason(), node.substring(Integer.MAX_VALUE, offset + le.getOffset()));
            }
        }
    }

    private static class TrustedResourceUriPartTransition
    extends Transition {
        private static final Pattern BASE_URL_PATTERN = Pattern.compile("^((https:)?//[0-9a-z.:\\[\\]-]+/|/[^/\\\\]|[^:/\\\\]+/|[^:/\\\\]*[?#]|about:blank#)", 2);

        TrustedResourceUriPartTransition(Pattern pattern) {
            super(pattern);
        }

        TrustedResourceUriPartTransition() {
        }

        @Override
        boolean isApplicableTo(Context prior, @Nullable Matcher matcher) {
            return prior.uriType() == Context.UriType.TRUSTED_RESOURCE;
        }

        @Override
        Context computeNextContext(RawTextNode node, int offset, Context context, @Nullable Matcher matcher) {
            String match = matcher == null ? node.getRawText().substring(offset) : matcher.group();
            switch (context.uriPart()) {
                case START: {
                    if (!BASE_URL_PATTERN.matcher(match).find()) {
                        context = context.derive(Context.UriPart.TRUSTED_RESOURCE_URI_END);
                        break;
                    }
                    context = context.derive(Context.UriPart.AUTHORITY_OR_PATH);
                }
                case AUTHORITY_OR_PATH: {
                    int queryIndex = match.indexOf(63);
                    if (queryIndex == -1) {
                        queryIndex = match.indexOf(38);
                    }
                    if (queryIndex != -1) {
                        context = context.derive(Context.UriPart.QUERY);
                    }
                }
                case QUERY: {
                    if (match.indexOf(35) == -1) {
                        return context;
                    }
                    context = context.derive(Context.UriPart.FRAGMENT);
                    break;
                }
                case FRAGMENT: {
                    return context;
                }
                case TRUSTED_RESOURCE_URI_END: {
                    return context;
                }
                case MAYBE_SCHEME: 
                case MAYBE_VARIABLE_SCHEME: 
                case UNKNOWN_PRE_FRAGMENT: 
                case UNKNOWN: 
                case DANGEROUS_SCHEME: {
                    throw SoyAutoescapeException.createWithNode("Cannot safely process this TrustedResourceUri at compile time. TrustedResourceUris must have a statically identifiable scheme and host. Either use a hard-coded scheme, or move the calculation of this URL outside of the template and use an ordaining API.", node.substring(Integer.MAX_VALUE, offset));
                }
                case NONE: {
                    throw new AssertionError((Object)"impossible");
                }
            }
            return context;
        }
    }

    private static abstract class Transition {
        @Nullable
        final Pattern pattern;
        @Nullable
        final String literal;

        Transition(Pattern pattern) {
            this.pattern = pattern;
            this.literal = null;
        }

        Transition(String literal) {
            this.pattern = null;
            this.literal = literal;
        }

        Transition() {
            this.pattern = null;
            this.literal = null;
        }

        boolean isApplicableTo(Context prior, @Nullable Matcher matcher) {
            return true;
        }

        Context computeNextContext(RawTextNode originalNode, int offset, Context prior, @Nullable Matcher matcher) {
            return this.computeNextContext(prior, matcher);
        }

        Context computeNextContext(Context prior, @Nullable Matcher matcher) {
            throw new AbstractMethodError();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).add("literal", (Object)this.literal).omitNullValues().toString();
        }
    }

    private static final class TransitionSetProcessor
    implements Processor {
        final ImmutableList<Transition> transitions;

        static TransitionSetProcessor of(Transition ... transitions) {
            return new TransitionSetProcessor((ImmutableList<Transition>)ImmutableList.copyOf((Object[])transitions));
        }

        TransitionSetProcessor(ImmutableList<Transition> transitions) {
            this.transitions = transitions;
        }

        @Override
        public Processor.Result processText(Context context, RawTextNode node, int offset, String text) {
            int transitionOffset;
            int earliestStart = Integer.MAX_VALUE;
            int earliestEnd = -1;
            Transition earliestTransition = null;
            Matcher earliestMatcher = null;
            block2: for (Transition transition : this.transitions) {
                if (transition.pattern != null) {
                    Matcher matcher = transition.pattern.matcher(text);
                    try {
                        while (matcher.find() && matcher.start() < earliestStart) {
                            int start = matcher.start();
                            int end = matcher.end();
                            if (!transition.isApplicableTo(context, matcher)) continue;
                            earliestStart = start;
                            earliestEnd = end;
                            earliestTransition = transition;
                            earliestMatcher = matcher;
                            continue block2;
                        }
                        continue;
                    }
                    catch (StackOverflowError soe) {
                        throw new RuntimeException(String.format("StackOverflow while trying to match: '%s' in context %s starting @ %s", transition.pattern, context, node.substringLocation(offset, offset + 1)), soe);
                    }
                }
                if (transition.literal != null) {
                    String needle;
                    String range = earliestStart != Integer.MAX_VALUE ? text.substring(0, Math.min(earliestStart + needle.length() - 1, text.length())) : text;
                    int index = range.indexOf(needle = transition.literal);
                    if (index == -1 || !transition.isApplicableTo(context, null)) continue;
                    Preconditions.checkState((index < earliestStart ? 1 : 0) != 0);
                    earliestStart = index;
                    earliestEnd = index + needle.length();
                    earliestTransition = transition;
                    earliestMatcher = null;
                    continue;
                }
                if (text.length() >= earliestStart || !transition.isApplicableTo(context, null)) continue;
                earliestStart = text.length();
                earliestEnd = text.length();
                earliestTransition = transition;
                earliestMatcher = null;
            }
            if (earliestTransition != null) {
                transitionOffset = offset;
                if (earliestStart < text.length()) {
                    transitionOffset += earliestStart;
                }
            } else {
                throw SoyAutoescapeException.createWithNode("Error determining next state when encountering \"" + text + "\" in " + context, node.substring(Integer.MAX_VALUE, offset));
            }
            Context next = earliestTransition.computeNextContext(node, transitionOffset, context, earliestMatcher);
            int numCharsConsumed = earliestEnd;
            if (numCharsConsumed == 0 && next.state() == context.state()) {
                throw new IllegalStateException("Infinite loop at `" + text + "` / " + context);
            }
            return Processor.Result.create(next, numCharsConsumed);
        }
    }

    static interface Processor {
        public Result processText(Context var1, RawTextNode var2, int var3, String var4);

        @AutoValue
        public static abstract class Result {
            static Result create(Context next, int numCharactersConsumed) {
                return new AutoValue_RawTextContextUpdater_Processor_Result(next, numCharactersConsumed);
            }

            abstract Context nextContext();

            abstract int numCharactersConsumed();
        }
    }
}

