/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

final class SoyAutoescapeException
extends RuntimeException {
    private final SourceLocation srcLoc;
    @Nullable
    private final String templateName;

    static SoyAutoescapeException createWithNode(String message, SoyNode node) {
        return new SoyAutoescapeException(message, null, node);
    }

    static SoyAutoescapeException createCausedWithNode(String message, Throwable cause, SoyNode node) {
        return new SoyAutoescapeException(message, cause, node);
    }

    private SoyAutoescapeException(String message, Throwable cause, SoyNode node) {
        super(message, cause);
        this.srcLoc = node.getSourceLocation();
        TemplateNode template = node.getNearestAncestor(TemplateNode.class);
        this.templateName = template != null ? template.getTemplateNameForUserMsgs() : null;
    }

    SourceLocation getSourceLocation() {
        return this.srcLoc;
    }

    String getOriginalMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        boolean templateKnown = this.templateName != null;
        String message = super.getMessage();
        if (templateKnown) {
            return "In file " + this.srcLoc + ", template " + this.templateName + ": " + message;
        }
        return "In file " + this.srcLoc + ": " + message;
    }
}

