/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

public class NullSafeAccessPass
implements CompilerFilePass {
    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        ImmutableList<DataAccessNode> accesses = SoyTreeUtils.getAllNodesOfType(file, DataAccessNode.class);
        for (DataAccessNode access : accesses.reverse()) {
            if (!access.isNullSafe() || access.getParent() == null) continue;
            ExprNode.AccessChainComponentNode accessChainRoot = NullSafeAccessPass.findRoot(access);
            NullSafeAccessNode.createAndInsert(access, accessChainRoot);
        }
    }

    private static ExprNode.AccessChainComponentNode findRoot(DataAccessNode access) {
        ExprNode.AccessChainComponentNode node;
        for (node = access; node.getParent() instanceof DataAccessNode && ((DataAccessNode)node.getParent()).getBaseExprChild() == node || node.getParent().getKind() == ExprNode.Kind.ASSERT_NON_NULL_OP_NODE; node = (ExprNode.AccessChainComponentNode)node.getParent()) {
        }
        return node;
    }
}

