/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.exprtree.CallableExprBuilder;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.LocalVariablesNodeVisitor;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.RunBefore;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.types.SoyType;
import java.util.Optional;

@RunBefore(value={SoyConformancePass.class})
final class ResolvePluginsPass
implements CompilerFilePass {
    private final PluginResolver resolver;

    ResolvePluginsPass(PluginResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        new LocalVariablesNodeVisitor(new Visitor()).exec(file);
    }

    static void setSoyFunctionForNameExpr(FunctionNode function) {
        Object fct = ResolvePluginsPass.getSoyFunctionForExpr(function.getNameExpr());
        if (fct != null) {
            function.setSoyFunction(BuiltinFunction.PROTO_INIT);
        }
    }

    private static Object getSoyFunctionForExpr(ExprNode expr) {
        if (expr.getKind() == ExprNode.Kind.VAR_REF_NODE && ((VarRefNode)expr).hasType() && expr.getType().getKind() == SoyType.Kind.PROTO_TYPE) {
            return BuiltinFunction.PROTO_INIT;
        }
        return null;
    }

    private class Visitor
    extends LocalVariablesNodeVisitor.NodeVisitor {
        private final LocalVariablesNodeVisitor.ExprVisitor exprVisitor = new LocalVariablesNodeVisitor.ExprVisitor(){

            @Override
            protected void visitFunctionNode(FunctionNode node) {
                boolean varDefnIsTemplate;
                this.visitChildren(node);
                if (node.isResolved()) {
                    return;
                }
                if (!node.hasStaticName()) {
                    ResolvePluginsPass.setSoyFunctionForNameExpr(node);
                    return;
                }
                VarDefn varDefn = this.getLocalVariables().lookup(node.getStaticFunctionName());
                boolean bl = varDefnIsTemplate = varDefn != null && varDefn.kind() == VarDefn.Kind.TEMPLATE;
                if (varDefnIsTemplate && this.trySetFunction(node)) {
                    return;
                }
                if (varDefn != null) {
                    VarRefNode functionRef = new VarRefNode(node.getStaticFunctionName(), node.getIdentifier().location(), varDefn);
                    FunctionNode newFunct = CallableExprBuilder.builder(node).setIdentifier(null).setFunctionExpr(functionRef).buildFunction();
                    ResolvePluginsPass.setSoyFunctionForNameExpr(newFunct);
                    node.getParent().replaceChild(node, newFunct);
                    return;
                }
                this.trySetFunction(node);
            }

            private boolean trySetFunction(FunctionNode node) {
                Object impl = ResolvePluginsPass.this.resolver.lookupSoyFunction(node.getStaticFunctionName(), node.numChildren(), node.getSourceLocation());
                if (impl != null) {
                    node.setSoyFunction(impl);
                    return true;
                }
                return false;
            }
        };

        private Visitor() {
        }

        @Override
        protected LocalVariablesNodeVisitor.ExprVisitor getExprVisitor() {
            return this.exprVisitor;
        }

        @Override
        protected void visitPrintDirectiveNode(PrintDirectiveNode directiveNode) {
            super.visitPrintDirectiveNode(directiveNode);
            String name = directiveNode.getName();
            Optional<SoySourceFunction> aliasedFunction = ResolvePluginsPass.this.resolver.getFunctionCallableAsPrintDirective(name, directiveNode.getSourceLocation());
            if (aliasedFunction.isPresent()) {
                directiveNode.setPrintDirectiveFunction(aliasedFunction.get());
            } else {
                directiveNode.setPrintDirective(ResolvePluginsPass.this.resolver.lookupPrintDirective(name, directiveNode.getExprList().size(), directiveNode.getSourceLocation()));
            }
        }
    }
}

