/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.plugin.java.ReadMethodData;
import java.util.List;

public interface MethodChecker {
    public Response findMethod(String var1, String var2, String var3, List<String> var4);

    public static class Response {
        private final Code code;
        private final ReadMethodData method;
        private final ImmutableCollection<String> suggestions;

        public static Response error(Code code) {
            return new Response(code, null, (ImmutableCollection<String>)ImmutableList.of());
        }

        public static Response error(Code code, ImmutableCollection<String> suggestions) {
            return new Response(code, null, suggestions);
        }

        public static Response success(ReadMethodData data) {
            return new Response(Code.EXISTS, data, (ImmutableCollection<String>)ImmutableList.of());
        }

        private Response(Code code, ReadMethodData method, ImmutableCollection<String> suggestions) {
            this.code = code;
            this.method = method;
            this.suggestions = suggestions;
        }

        public Code getCode() {
            return this.code;
        }

        public ReadMethodData getMethod() {
            return this.method;
        }

        public ImmutableCollection<String> getSuggesions() {
            return this.suggestions;
        }
    }

    public static enum Code {
        EXISTS,
        NO_SUCH_CLASS,
        NO_SUCH_METHOD_NAME,
        NO_SUCH_METHOD_SIG,
        NO_SUCH_RETURN_TYPE,
        NOT_PUBLIC;

    }
}

