/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.restricted;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.google.template.soy.plugin.java.restricted.AutoValue_MethodSignature;

@AutoValue
public abstract class MethodSignature {
    private static final ImmutableMap<String, Class<?>> PRIMITIVE_TYPE_INDEX = (ImmutableMap)Primitives.allPrimitiveTypes().stream().collect(ImmutableMap.toImmutableMap(Class::getName, c -> c));

    public abstract String fullyQualifiedClassName();

    public abstract String methodName();

    public abstract Class<?> returnType();

    public abstract ImmutableList<Class<?>> arguments();

    public abstract boolean inInterface();

    MethodSignature() {
    }

    public static MethodSignature create(String classFqn, String method, Class<?> returnType, Class<?> ... args) {
        return new AutoValue_MethodSignature(classFqn, method, returnType, ImmutableList.copyOf((Object[])args), false);
    }

    public static MethodSignature create(String classFqn, String method, String returnTypeName, String ... argTypeNames) throws ClassNotFoundException {
        Class<?> returnType = MethodSignature.forName(returnTypeName);
        Class[] args = new Class[argTypeNames.length];
        for (int i = 0; i < argTypeNames.length; ++i) {
            args[i] = MethodSignature.forName(argTypeNames[i]);
        }
        return MethodSignature.create(classFqn, method, returnType, args);
    }

    public static MethodSignature createInterfaceMethod(String classFqn, String method, Class<?> returnType, Class<?> ... args) {
        return new AutoValue_MethodSignature(classFqn, method, returnType, ImmutableList.copyOf((Object[])args), true);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> primitive = (Class<?>)PRIMITIVE_TYPE_INDEX.get((Object)className);
        return primitive != null ? primitive : Class.forName(className);
    }
}

