/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.template.soy.basicdirectives.BasicDirectives;
import com.google.template.soy.basicfunctions.BasicFunctions;
import com.google.template.soy.bididirectives.BidiDirectives;
import com.google.template.soy.bidifunctions.BidiFunctions;
import com.google.template.soy.coredirectives.CoreDirectives;
import com.google.template.soy.i18ndirectives.I18nFunctions;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;

public final class InternalPlugins {
    private InternalPlugins() {
    }

    public static ImmutableList<SoyFunction> internalLegacyFunctions() {
        return ImmutableList.copyOf((Object[])BuiltinFunction.values());
    }

    public static ImmutableList<SoySourceFunction> internalFunctions() {
        return (ImmutableList)Streams.concat((Stream[])new Stream[]{BasicFunctions.functions().stream(), BidiFunctions.functions().stream(), I18nFunctions.functions().stream()}).filter(f -> f.getClass().isAnnotationPresent(SoyFunctionSignature.class)).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableMap<String, SoySourceFunction> internalAliasedDirectivesMap() {
        return (ImmutableMap)InternalPlugins.internalFunctions().stream().filter(e -> e.getClass().getAnnotation(SoyFunctionSignature.class).callableAsDeprecatedPrintDirective()).collect(ImmutableMap.toImmutableMap(e -> "|" + e.getClass().getAnnotation(SoyFunctionSignature.class).name(), Function.identity()));
    }

    public static ImmutableList<SoyPrintDirective> internalDirectives(SoyScopedData soyScopedData) {
        Supplier bidiProvider = soyScopedData::getBidiGlobalDir;
        return ImmutableList.copyOf((Iterable)Iterables.concat(CoreDirectives.directives(), BasicDirectives.directives(), BidiDirectives.directives((Supplier<BidiGlobalDir>)bidiProvider)));
    }

    public static ImmutableList<SoySourceFunction> internalMethods() {
        return (ImmutableList)Streams.concat((Stream[])new Stream[]{BasicFunctions.functions().stream(), BidiFunctions.functions().stream(), I18nFunctions.functions().stream()}).filter(f -> f.getClass().isAnnotationPresent(SoyMethodSignature.class)).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<SoyPrintDirective> filterDuplicateDirectives(Iterable<? extends SoyPrintDirective> directives) {
        return InternalPlugins.filterDuplicates(directives, SoyPrintDirective::getName);
    }

    public static ImmutableList<SoyFunction> filterDuplicateFunctions(Iterable<? extends SoyFunction> functions) {
        return InternalPlugins.filterDuplicates(functions, SoyFunction::getName);
    }

    static <T> ImmutableList<T> filterDuplicates(Iterable<? extends T> items, Function<T, String> nameFn) {
        HashMap<String, T> indexed = new HashMap<String, T>();
        ImmutableList.Builder output = ImmutableList.builder();
        for (T item : items) {
            T old = indexed.put(nameFn.apply(item), item);
            if (old != null && old.getClass().getName().equals(item.getClass().getName())) continue;
            output.add(item);
        }
        return output.build();
    }
}

