/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.ExternImplNode;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class JsImplNode
extends ExternImplNode {
    private static final SoyErrorKind INVALID_IMPL_ATTRIBUTE = SoyErrorKind.of("''{0}'' is not a valid attribute.", new SoyErrorKind.StyleAllowance[0]);
    private static final String NAMESPACE = "namespace";
    private static final String FUNCTION = "function";
    public static final String FIELDS = String.format("%s,%s", "namespace", "function");
    private static final SoyErrorKind UNEXPECTED_ARGS = SoyErrorKind.of("JS implementations require attributes" + FIELDS + " .", new SoyErrorKind.StyleAllowance[0]);
    private final ImmutableList<CommandTagAttribute> attributes;
    private CommandTagAttribute module;
    private CommandTagAttribute function;

    public JsImplNode(int id, SourceLocation sourceLocation, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, sourceLocation, "jsimpl");
        if (attributes.size() != 2) {
            errorReporter.report(sourceLocation, UNEXPECTED_ARGS, new Object[0]);
        }
        attributes.stream().filter(attr -> !attr.hasName(NAMESPACE) && !attr.hasName(FUNCTION)).findAny().ifPresent(invalidAttr -> errorReporter.report(invalidAttr.getSourceLocation(), INVALID_IMPL_ATTRIBUTE, invalidAttr.getName()));
        this.attributes = ImmutableList.copyOf(attributes);
        this.initAttributes();
    }

    private JsImplNode(JsImplNode orig, CopyState copyState) {
        super(orig, copyState);
        this.attributes = (ImmutableList)orig.attributes.stream().map(origAttr -> origAttr.copy(copyState)).collect(ImmutableList.toImmutableList());
        this.initAttributes();
    }

    private final void initAttributes() {
        for (CommandTagAttribute attr : this.attributes) {
            if (attr.hasName(NAMESPACE)) {
                this.module = attr;
                continue;
            }
            if (!attr.hasName(FUNCTION)) continue;
            this.function = attr;
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.JS_IMPL_NODE;
    }

    @Override
    public JsImplNode copy(CopyState copyState) {
        return new JsImplNode(this, copyState);
    }

    public String module() {
        return this.module.getValue();
    }

    public String function() {
        return this.function.getValue();
    }

    @Override
    public SourceLocation getOpenTagLocation() {
        return this.getSourceLocation();
    }

    public ImmutableList<CommandTagAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public ExternNode getParent() {
        return (ExternNode)super.getParent();
    }
}

