/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.AutoValue_Metadata_CompilationUnitAndKind;
import com.google.template.soy.soytree.AutoValue_Metadata_ConstantImpl;
import com.google.template.soy.soytree.AutoValue_Metadata_DepsFileMetadata;
import com.google.template.soy.soytree.AutoValue_Metadata_DepsFileSetMetadata;
import com.google.template.soy.soytree.AutoValue_Metadata_ExternImpl;
import com.google.template.soy.soytree.AutoValue_Metadata_ParseContext;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.ConstNode;
import com.google.template.soy.soytree.ConstantP;
import com.google.template.soy.soytree.ExternNode;
import com.google.template.soy.soytree.ExternP;
import com.google.template.soy.soytree.FileMetadata;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.PartialFileMetadata;
import com.google.template.soy.soytree.PartialFileSetMetadata;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileP;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateMetadataSerializer;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.FunctionType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.TemplateType;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class Metadata {
    public static final FileSetMetadata EMPTY_FILESET = new AutoValue_Metadata_DepsFileSetMetadata((ImmutableList<CompilationUnitAndKind>)ImmutableList.of(), ParseContext.of(ErrorReporter.exploding(), null));
    private static final SoyErrorKind DUPLICATE_TEMPLATES = SoyErrorKind.of("Template/element ''{0}'' already defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DEFAULT_DELEGATE_TEMPLATES = SoyErrorKind.of("Delegate template ''{0}'' already has a default defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE = SoyErrorKind.of("Delegate template ''{0}'' already defined in delpackage {1}: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME = SoyErrorKind.of("Found deltemplate {0} with the same name as a template/element at {1}.", new SoyErrorKind.StyleAllowance[0]);

    private Metadata() {
    }

    public static PartialFileSetMetadata partialMetadataForAst(PartialFileSetMetadata deps, ImmutableList<SoyFileNode> ast) {
        return new AstPartialFileSetMetadata(deps, (List<SoyFileNode>)ast);
    }

    public static FileSetMetadata metadataForDeps(List<CompilationUnitAndKind> compilationUnits, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
        return new AutoValue_Metadata_DepsFileSetMetadata((ImmutableList<CompilationUnitAndKind>)ImmutableList.copyOf(compilationUnits), ParseContext.of(errorReporter, typeRegistry));
    }

    public static FileSetMetadata metadataForAst(FileSetMetadata deps, List<SoyFileNode> ast, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
        return new AstFileSetMetadata(deps, ast, ParseContext.of(errorReporter, typeRegistry));
    }

    public static ImmutableList<TemplateType> getTemplates(FileSetMetadata fileSetMetadata, CallNode node) {
        if (node instanceof CallBasicNode) {
            SoyType calleeType = ((CallBasicNode)node).getCalleeExpr().getType();
            if (calleeType == null) {
                return ImmutableList.of();
            }
            if (calleeType.getKind() == SoyType.Kind.TEMPLATE) {
                return ImmutableList.of((Object)((TemplateType)calleeType));
            }
            if (calleeType.getKind() == SoyType.Kind.UNION) {
                ImmutableList.Builder signatures = ImmutableList.builder();
                for (SoyType member : ((UnionType)calleeType).getMembers()) {
                    Preconditions.checkState((member.getKind() == SoyType.Kind.TEMPLATE ? 1 : 0) != 0);
                    signatures.add((Object)((TemplateType)member));
                }
                return signatures.build();
            }
            if (calleeType.getKind() == SoyType.Kind.UNKNOWN) {
                return ImmutableList.of();
            }
            throw new IllegalStateException("Unexpected type in call: " + calleeType.getClass() + " - " + node.toSourceString());
        }
        String calleeName = ((CallDelegateNode)node).getDelCalleeName();
        return (ImmutableList)fileSetMetadata.getDelTemplateSelector().delTemplateNameToValues().get((Object)calleeName).stream().map(TemplateMetadata::getTemplateType).collect(ImmutableList.toImmutableList());
    }

    public static Optional<SanitizedContentKind> getCallContentKind(FileSetMetadata fileSetMetadata, CallNode node) {
        ImmutableList<TemplateType> templateNodes = Metadata.getTemplates(fileSetMetadata, node);
        if (!templateNodes.isEmpty()) {
            return Optional.of(((TemplateType)templateNodes.get(0)).getContentKind().getSanitizedContentKind());
        }
        return Optional.empty();
    }

    private static FileMetadata merge(FileMetadata primary, FileMetadata secondary) {
        return new MergedFileMetadata(primary, secondary);
    }

    private static DelTemplateSelector<TemplateMetadata> buildDelTemplateSelector(Collection<TemplateMetadata> allTemplates, ErrorReporter errorReporter, FileSetMetadata fileSetMetadata) {
        DelTemplateSelector.Builder builder = new DelTemplateSelector.Builder();
        allTemplates.stream().filter(t -> t.getTemplateType().getTemplateKind() == TemplateType.TemplateKind.DELTEMPLATE).forEach(template -> {
            TemplateMetadata nameCollision;
            String delTemplateName = template.getDelTemplateName();
            String delPackageName = template.getDelPackageName();
            String variant = template.getDelTemplateVariant();
            if (delPackageName == null) {
                TemplateMetadata previous = builder.addDefault(delTemplateName, variant, template);
                if (previous != null) {
                    errorReporter.report(template.getSourceLocation(), DUPLICATE_DEFAULT_DELEGATE_TEMPLATES, delTemplateName, previous.getSourceLocation());
                }
            } else {
                TemplateMetadata previous = builder.add(delTemplateName, delPackageName, variant, template);
                if (previous != null) {
                    errorReporter.report(template.getSourceLocation(), DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE, delTemplateName, delPackageName, previous.getSourceLocation());
                }
            }
            if ((nameCollision = fileSetMetadata.getBasicTemplateOrElement(delTemplateName)) != null) {
                errorReporter.report(template.getSourceLocation(), TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME, delTemplateName, nameCollision.getSourceLocation());
            }
        });
        return builder.build();
    }

    private static void warnNameCollision(ErrorReporter errorReporter, TemplateMetadata previous, TemplateMetadata t) {
        if (previous != null && !Metadata.sameFile(previous, t) && t.getTemplateType().getTemplateKind() != TemplateType.TemplateKind.DELTEMPLATE) {
            errorReporter.report(t.getSourceLocation(), DUPLICATE_TEMPLATES, t.getTemplateName(), previous.getSourceLocation());
        }
    }

    private static boolean sameFile(TemplateMetadata t1, TemplateMetadata t2) {
        return t1.getSourceLocation().getFileName().equals(t2.getSourceLocation().getFileName());
    }

    @AutoValue
    public static abstract class CompilationUnitAndKind {
        public static CompilationUnitAndKind create(SoyFileKind fileKind, CompilationUnit compilationUnit) {
            Preconditions.checkArgument((fileKind != SoyFileKind.SRC ? 1 : 0) != 0, (Object)"compilation units should only represent dependencies");
            return new AutoValue_Metadata_CompilationUnitAndKind(fileKind, compilationUnit);
        }

        abstract SoyFileKind fileKind();

        abstract CompilationUnit compilationUnit();
    }

    private static class MergedFileMetadata
    extends AbstractFileMetadata {
        private final FileMetadata primary;
        private final ImmutableMap<String, FileMetadata.Constant> constantIndex;
        private final ImmutableMap<String, TemplateMetadata> templateIndex;

        public MergedFileMetadata(FileMetadata primary, FileMetadata secondary) {
            this.primary = primary;
            LinkedHashMap constants = new LinkedHashMap();
            secondary.getConstants().forEach(c -> constants.put(c.getName(), c));
            primary.getConstants().forEach(c -> constants.put(c.getName(), c));
            this.constantIndex = ImmutableMap.copyOf(constants);
            LinkedHashMap templates = new LinkedHashMap();
            secondary.getTemplates().forEach(t -> templates.put(t.getTemplateName(), t));
            primary.getTemplates().forEach(t -> templates.put(t.getTemplateName(), t));
            this.templateIndex = ImmutableMap.copyOf(templates);
        }

        protected ImmutableMap<String, FileMetadata.Constant> constantIndex() {
            return this.constantIndex;
        }

        @Override
        protected ImmutableListMultimap<String, ? extends FileMetadata.Extern> externIndex() {
            return ((AbstractFileMetadata)this.primary).externIndex();
        }

        public ImmutableCollection<TemplateMetadata> getTemplates() {
            return this.templateIndex.values();
        }

        @Override
        protected ImmutableMap<String, TemplateMetadata> templateIndex() {
            return this.templateIndex;
        }

        @Override
        public SourceFilePath getPath() {
            return this.primary.getPath();
        }

        @Override
        public String getNamespace() {
            return this.primary.getNamespace();
        }

        @Override
        public SoyFileKind getSoyFileKind() {
            return this.primary.getSoyFileKind();
        }
    }

    @AutoValue
    static abstract class ExternImpl
    implements FileMetadata.Extern {
        ExternImpl() {
        }

        private static ExternImpl of(String name, FunctionType signature) {
            return new AutoValue_Metadata_ExternImpl(name, signature);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract FunctionType getSignature();
    }

    @AutoValue
    static abstract class ConstantImpl
    implements FileMetadata.Constant {
        ConstantImpl() {
        }

        private static ConstantImpl of(String name, SoyType type) {
            return new AutoValue_Metadata_ConstantImpl(name, type);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract SoyType getType();
    }

    private static final class AstFileMetadata
    extends AbstractFileMetadata {
        private final SourceFilePath path;
        private final String namespace;
        private final ImmutableMap<String, ConstantImpl> constantIndex;
        private final ImmutableList<TemplateMetadata> allTemplates;
        private final ImmutableMap<String, TemplateMetadata> templateIndex;
        private final ImmutableListMultimap<String, ExternImpl> externIndex;

        public AstFileMetadata(SoyFileNode ast) {
            this.path = ast.getFilePath();
            this.namespace = ast.getNamespace();
            this.constantIndex = (ImmutableMap)ast.getConstants().stream().filter(ConstNode::isExported).collect(ImmutableMap.toImmutableMap(c -> c.getVar().name(), c -> ConstantImpl.of(c.getVar().name(), c.getVar().typeOrDefault(UnknownType.getInstance())), (t1, t2) -> t1));
            this.externIndex = (ImmutableListMultimap)ast.getExterns().stream().filter(ExternNode::isExported).collect(ImmutableListMultimap.toImmutableListMultimap(e -> e.getIdentifier().identifier(), e -> ExternImpl.of(e.getIdentifier().identifier(), e.getType())));
            ImmutableList.Builder templates = ImmutableList.builder();
            LinkedHashMap index = new LinkedHashMap();
            ast.getTemplates().forEach(t -> {
                TemplateMetadata metadata = TemplateMetadata.fromTemplate(t);
                templates.add((Object)metadata);
                index.putIfAbsent(t.getLocalTemplateSymbol(), metadata);
            });
            this.allTemplates = templates.build();
            this.templateIndex = ImmutableMap.copyOf(index);
        }

        public ImmutableList<TemplateMetadata> getTemplates() {
            return this.allTemplates;
        }

        protected ImmutableMap<String, ConstantImpl> constantIndex() {
            return this.constantIndex;
        }

        @Override
        protected ImmutableListMultimap<String, ? extends FileMetadata.Extern> externIndex() {
            return this.externIndex;
        }

        @Override
        protected ImmutableMap<String, TemplateMetadata> templateIndex() {
            return this.templateIndex;
        }

        @Override
        public SourceFilePath getPath() {
            return this.path;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public SoyFileKind getSoyFileKind() {
            return SoyFileKind.SRC;
        }
    }

    private static final class AstPartialFileMetadata
    implements PartialFileMetadata {
        private final SourceFilePath path;
        private final String namespace;
        private final ImmutableSet<String> templateNames;
        private final ImmutableSet<String> constantNames;
        private final ImmutableSet<String> externNames;

        public AstPartialFileMetadata(SoyFileNode ast) {
            this.path = ast.getFilePath();
            this.namespace = ast.getNamespace();
            this.templateNames = (ImmutableSet)ast.getTemplates().stream().map(TemplateNode::getLocalTemplateSymbol).collect(ImmutableSet.toImmutableSet());
            this.constantNames = (ImmutableSet)ast.getConstants().stream().filter(ConstNode::isExported).map(c -> c.getVar().name()).collect(ImmutableSet.toImmutableSet());
            this.externNames = (ImmutableSet)ast.getExterns().stream().filter(ExternNode::isExported).map(e -> e.getIdentifier().identifier()).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public SourceFilePath getPath() {
            return this.path;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        public ImmutableSet<String> getTemplateNames() {
            return this.templateNames;
        }

        public ImmutableSet<String> getConstantNames() {
            return this.constantNames;
        }

        public ImmutableSet<String> getExternNames() {
            return this.externNames;
        }
    }

    @AutoValue
    static abstract class DepsFileMetadata
    extends AbstractFileMetadata {
        DepsFileMetadata() {
        }

        protected abstract SoyFileP proto();

        protected abstract SoyFileKind kind();

        protected abstract ParseContext context();

        @Override
        @Memoized
        public SourceFilePath getPath() {
            return SourceFilePath.create(this.proto().getFilePath());
        }

        @Memoized
        protected ImmutableMap<String, ConstantImpl> constantIndex() {
            return (ImmutableMap)this.proto().getConstantsList().stream().collect(ImmutableMap.toImmutableMap(ConstantP::getName, c -> ConstantImpl.of(c.getName(), TemplateMetadataSerializer.fromProto(c.getType(), this.context().typeRegistry(), this.getPath(), this.context().errorReporter())), (t1, t2) -> t1));
        }

        @Memoized
        public ImmutableList<TemplateMetadata> getTemplates() {
            return (ImmutableList)this.proto().getTemplateList().stream().map(t -> TemplateMetadataSerializer.metadataFromProto(this.proto(), t, this.kind(), this.context().typeRegistry(), this.getPath(), this.context().errorReporter())).collect(ImmutableList.toImmutableList());
        }

        @Override
        @Memoized
        protected ImmutableListMultimap<String, ? extends FileMetadata.Extern> externIndex() {
            return (ImmutableListMultimap)this.proto().getExternsList().stream().collect(ImmutableListMultimap.toImmutableListMultimap(ExternP::getName, e -> ExternImpl.of(e.getName(), (FunctionType)TemplateMetadataSerializer.fromProto(SoyTypeP.newBuilder().setFunction(e.getSignature()).build(), this.context().typeRegistry(), this.getPath(), this.context().errorReporter()))));
        }

        @Override
        public SoyFileKind getSoyFileKind() {
            return this.kind();
        }

        @Override
        @Memoized
        protected ImmutableMap<String, TemplateMetadata> templateIndex() {
            return (ImmutableMap)this.getTemplates().stream().collect(ImmutableMap.toImmutableMap(t -> {
                String name = t.getTemplateName();
                int index = name.lastIndexOf(46);
                return index >= 0 ? name.substring(index + 1) : name;
            }, t -> t, (t1, t2) -> t1));
        }

        @Override
        public String getNamespace() {
            return this.proto().getNamespace();
        }
    }

    static abstract class AbstractFileMetadata
    implements FileMetadata {
        AbstractFileMetadata() {
        }

        protected abstract ImmutableMap<String, ? extends FileMetadata.Constant> constantIndex();

        protected abstract ImmutableListMultimap<String, ? extends FileMetadata.Extern> externIndex();

        protected abstract ImmutableMap<String, TemplateMetadata> templateIndex();

        @Override
        public FileMetadata.Constant getConstant(String name) {
            return (FileMetadata.Constant)this.constantIndex().get((Object)name);
        }

        @Override
        public TemplateMetadata getTemplate(String name) {
            return (TemplateMetadata)this.templateIndex().get((Object)name);
        }

        public final ImmutableCollection<? extends FileMetadata.Constant> getConstants() {
            return this.constantIndex().values();
        }

        public final ImmutableSet<String> getTemplateNames() {
            return this.templateIndex().keySet();
        }

        public final ImmutableSet<String> getConstantNames() {
            return this.constantIndex().keySet();
        }

        @Override
        public Collection<? extends FileMetadata.Extern> getExterns() {
            return this.externIndex().values();
        }

        @Override
        public List<? extends FileMetadata.Extern> getExterns(String name) {
            return this.externIndex().get((Object)name);
        }

        @Override
        public Set<String> getExternNames() {
            return this.externIndex().keySet();
        }
    }

    private static class AstFileSetMetadata
    implements FileSetMetadata {
        private final ParseContext context;
        private final ImmutableMap<SourceFilePath, FileMetadata> fullFileIndex;
        @LazyInit
        private ImmutableMap<String, TemplateMetadata> lazyFullTemplateIndex;
        @LazyInit
        private ImmutableList<TemplateMetadata> lazyAllTemplatesWithCollisions;
        @LazyInit
        private DelTemplateSelector<TemplateMetadata> delTemplateSelector;

        public AstFileSetMetadata(FileSetMetadata deps, List<SoyFileNode> ast, ParseContext context) {
            this.context = context;
            LinkedHashMap<SourceFilePath, FileMetadata> fullFileIndexBuilder = new LinkedHashMap<SourceFilePath, FileMetadata>();
            for (FileMetadata fileMetadata : deps.getAllFiles()) {
                fullFileIndexBuilder.put(fileMetadata.getPath(), fileMetadata);
            }
            ast.forEach(f -> {
                AstFileMetadata astMetadata = new AstFileMetadata((SoyFileNode)f);
                FileMetadata protoMetadata = (FileMetadata)fullFileIndexBuilder.remove(f.getFilePath());
                fullFileIndexBuilder.put(f.getFilePath(), astMetadata);
                if (protoMetadata != null && protoMetadata.getNamespace().equals(astMetadata.getNamespace())) {
                    fullFileIndexBuilder.put(f.getFilePath(), Metadata.merge(astMetadata, protoMetadata));
                }
            });
            this.fullFileIndex = ImmutableMap.copyOf(fullFileIndexBuilder);
        }

        private ImmutableMap<String, TemplateMetadata> templateIndex() {
            ImmutableMap tmp = this.lazyFullTemplateIndex;
            ImmutableList.Builder allBuilder = ImmutableList.builder();
            if (tmp == null) {
                LinkedHashMap builder = new LinkedHashMap();
                this.fullFileIndex.values().forEach(f -> f.getTemplates().forEach(t -> {
                    allBuilder.add(t);
                    TemplateMetadata previous = builder.put(t.getTemplateName(), t);
                    if (!(f instanceof DepsFileMetadata)) {
                        Metadata.warnNameCollision(this.context.errorReporter(), previous, t);
                    }
                }));
                this.lazyFullTemplateIndex = tmp = ImmutableMap.copyOf(builder);
                this.lazyAllTemplatesWithCollisions = allBuilder.build();
            }
            return tmp;
        }

        @Override
        public TemplateMetadata getTemplate(String templateFqn) {
            return (TemplateMetadata)this.templateIndex().get((Object)templateFqn);
        }

        @Override
        public DelTemplateSelector<TemplateMetadata> getDelTemplateSelector() {
            DelTemplateSelector tmp = this.delTemplateSelector;
            if (tmp == null) {
                this.delTemplateSelector = tmp = Metadata.buildDelTemplateSelector(this.getAllTemplates(), this.context.errorReporter(), this);
            }
            return tmp;
        }

        @Override
        public FileMetadata getFile(SourceFilePath path) {
            return (FileMetadata)this.fullFileIndex.get((Object)path);
        }

        public ImmutableCollection<? extends FileMetadata> getAllFiles() {
            return this.fullFileIndex.values();
        }

        public ImmutableCollection<TemplateMetadata> getAllTemplates() {
            this.templateIndex();
            return this.lazyAllTemplatesWithCollisions;
        }
    }

    private static class AstPartialFileSetMetadata
    implements PartialFileSetMetadata {
        private final ImmutableMap<SourceFilePath, PartialFileMetadata> fullFileIndex;

        public AstPartialFileSetMetadata(PartialFileSetMetadata deps, List<SoyFileNode> ast) {
            LinkedHashMap<SourceFilePath, PartialFileMetadata> fullFileIndexBuilder = new LinkedHashMap<SourceFilePath, PartialFileMetadata>();
            for (PartialFileMetadata partialFileMetadata : deps.getAllPartialFiles()) {
                fullFileIndexBuilder.put(partialFileMetadata.getPath(), partialFileMetadata);
            }
            ast.forEach(f -> {
                PartialFileMetadata cfr_ignored_0 = fullFileIndexBuilder.put(f.getFilePath(), new AstPartialFileMetadata((SoyFileNode)f));
            });
            this.fullFileIndex = ImmutableMap.copyOf(fullFileIndexBuilder);
        }

        @Override
        public PartialFileMetadata getPartialFile(SourceFilePath path) {
            return (PartialFileMetadata)this.fullFileIndex.get((Object)path);
        }

        public ImmutableCollection<? extends PartialFileMetadata> getAllPartialFiles() {
            return this.fullFileIndex.values();
        }
    }

    @AutoValue
    static abstract class DepsFileSetMetadata
    implements FileSetMetadata {
        DepsFileSetMetadata() {
        }

        abstract ImmutableList<CompilationUnitAndKind> units();

        abstract ParseContext context();

        @Memoized
        protected ImmutableMap<SourceFilePath, FileMetadata> fileIndex() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.units().forEach(u -> u.compilationUnit().getFileList().forEach(f -> builder.put((Object)SourceFilePath.create(f.getFilePath()), (Object)new AutoValue_Metadata_DepsFileMetadata((SoyFileP)f, u.fileKind(), this.context()))));
            return builder.buildOrThrow();
        }

        @Memoized
        protected ImmutableMap<String, TemplateMetadata> templateIndex() {
            LinkedHashMap builder = new LinkedHashMap();
            this.getAllTemplates().forEach(t -> {
                TemplateMetadata previous = builder.put(t.getTemplateName(), t);
                Metadata.warnNameCollision(this.context().errorReporter(), previous, t);
            });
            return ImmutableMap.copyOf(builder);
        }

        @Override
        public TemplateMetadata getTemplate(String templateFqn) {
            return (TemplateMetadata)this.templateIndex().get((Object)templateFqn);
        }

        @Override
        @Memoized
        public DelTemplateSelector<TemplateMetadata> getDelTemplateSelector() {
            return Metadata.buildDelTemplateSelector(this.getAllTemplates(), this.context().errorReporter(), this);
        }

        @Override
        public FileMetadata getFile(SourceFilePath path) {
            return (FileMetadata)this.fileIndex().get((Object)path);
        }

        public ImmutableCollection<? extends FileMetadata> getAllFiles() {
            return this.fileIndex().values();
        }

        @Memoized
        public ImmutableCollection<TemplateMetadata> getAllTemplates() {
            return (ImmutableCollection)this.getAllFiles().stream().flatMap(f -> f.getTemplates().stream()).collect(ImmutableList.toImmutableList());
        }
    }

    @AutoValue
    static abstract class ParseContext {
        ParseContext() {
        }

        static ParseContext of(ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
            return new AutoValue_Metadata_ParseContext(errorReporter, typeRegistry);
        }

        abstract ErrorReporter errorReporter();

        @Nullable
        abstract SoyTypeRegistry typeRegistry();
    }
}

