/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import javax.annotation.Nullable;

public final class TemplateElementNode
extends TemplateNode
implements SoyNode.ExprHolderNode {
    public final String jsnamespace;
    public final String jsclass;

    TemplateElementNode(TemplateElementNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, @Nullable ImmutableList<TemplateHeaderVarDefn> params, @Nullable String jsnamespace, @Nullable String jsclass) {
        super(nodeBuilder, "element", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.jsnamespace = jsnamespace;
        this.jsclass = jsclass;
    }

    private TemplateElementNode(TemplateElementNode orig, CopyState copyState) {
        super(orig, copyState);
        this.jsnamespace = orig.jsnamespace;
        this.jsclass = orig.jsclass;
    }

    public ImmutableList<TemplateStateVar> getStateVars() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TemplateHeaderVarDefn header : this.getHeaderParams()) {
            if (!(header instanceof TemplateStateVar)) continue;
            builder.add((Object)((TemplateStateVar)header));
        }
        return builder.build();
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(super.getExprList());
        for (TemplateStateVar state : this.getStateVars()) {
            builder.add((Object)state.defaultValue());
        }
        return builder.build();
    }

    public boolean hasExternalClassDefinition() {
        return this.jsnamespace != null && this.jsclass != null;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_ELEMENT_NODE;
    }

    @Override
    public TemplateElementNode copy(CopyState copyState) {
        return new TemplateElementNode(this, copyState);
    }
}

