/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import java.util.List;

public final class TemplateElementNodeBuilder
extends TemplateNodeBuilder<TemplateElementNodeBuilder> {
    static final ImmutableSet<String> BANNED_ATTRIBUTE_NAMES = ImmutableSet.of((Object)"autoescape", (Object)"stricthtml", (Object)"visibility");
    private static final SoyErrorKind BANNED_ATTRIBUTE_NAMES_ERROR = SoyErrorKind.of("Attribute ''{0}'' is not allowed on Soy elements.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_ELEMENT_KIND = SoyErrorKind.of("Soy element kind must be html or html<...>.", new SoyErrorKind.StyleAllowance[0]);
    private List<CommandTagAttribute> attrs = ImmutableList.of();
    public String jsNamespace = null;
    public String jsClass = null;

    public TemplateElementNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, errorReporter);
    }

    @Override
    public TemplateElementNodeBuilder setCommandValues(Identifier templateName, List<CommandTagAttribute> attrs) {
        this.attrs = attrs;
        this.cmdText = templateName.identifier() + " " + Joiner.on((char)' ').join(attrs);
        this.setCommonCommandValues(attrs);
        this.setTemplateNames(templateName, this.soyFileHeaderInfo.getNamespace());
        return this;
    }

    @Override
    public TemplateElementNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        for (CommandTagAttribute attr : this.attrs) {
            if (attr.getName().identifier().equals("kind")) {
                if (!this.getContentKind().getSanitizedContentKind().isHtml()) {
                    this.errorReporter.report(attr.getValueLocation(), INVALID_ELEMENT_KIND, new Object[0]);
                }
            } else if (BANNED_ATTRIBUTE_NAMES.contains((Object)attr.getName().identifier())) {
                this.errorReporter.report(attr.getName().location(), BANNED_ATTRIBUTE_NAMES_ERROR, attr.getName().identifier());
            }
            if (attr.getName().identifier().equals("jsnamespace")) {
                this.jsNamespace = attr.getValue();
            }
            if (!attr.getName().identifier().equals("jsclass")) continue;
            this.jsClass = attr.getValue();
        }
        return new TemplateElementNode(this, this.soyFileHeaderInfo, (ImmutableList<TemplateHeaderVarDefn>)this.params, this.jsNamespace, this.jsClass);
    }

    @Override
    protected TemplateElementNodeBuilder self() {
        return this;
    }
}

